/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class TopLeftCorner
extends BorderCorner {
    TopLeftCorner(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        super(cornerRadius, preBorderWidth, postBorderWidth, borderBox);
    }

    @Override
    protected float getAngleBisectorDegree() {
        return 225.0f;
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerExist() {
        return new RectF(this.getPreBorderWidth() / 2.0f, this.getPostBorderWidth() / 2.0f, 2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f, 2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerNotExist() {
        return new RectF(this.getOuterCornerRadius() / 2.0f, this.getOuterCornerRadius() / 2.0f, this.getOuterCornerRadius() * 1.5f, this.getOuterCornerRadius() * 1.5f);
    }

    @Override
    @NonNull
    protected PointF getRoundCornerStart() {
        return new PointF(this.getPreBorderWidth() / 2.0f, this.getOuterCornerRadius());
    }

    @Override
    @NonNull
    protected PointF getSharpCornerVertex() {
        return new PointF(this.getPreBorderWidth() / 2.0f, this.getPostBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getSharpCornerStart() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.x = 0.0f;
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getSharpCornerEnd() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.y = 0.0f;
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getRoundCornerEnd() {
        return new PointF(this.getOuterCornerRadius(), this.getPostBorderWidth() / 2.0f);
    }
}

