/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.ui.view.border.BorderCorner;

class BottomLeftCorner
extends BorderCorner {
    BottomLeftCorner(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        super(cornerRadius, preBorderWidth, postBorderWidth, borderBox);
    }

    @Override
    protected float getAngleBisectorDegree() {
        return 135.0f;
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerExist() {
        return new RectF(this.getPostBorderWidth() / 2.0f, this.getBorderBox().height() - (2.0f * this.getOuterCornerRadius() - this.getPreBorderWidth() / 2.0f), 2.0f * this.getOuterCornerRadius() - this.getPostBorderWidth() / 2.0f, this.getBorderBox().height() - this.getPreBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected RectF getOvalIfInnerCornerNotExist() {
        return new RectF(this.getOuterCornerRadius() / 2.0f, this.getBorderBox().height() - 1.5f * this.getOuterCornerRadius(), 1.5f * this.getOuterCornerRadius(), this.getBorderBox().height() - this.getOuterCornerRadius() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getRoundCornerStart() {
        return new PointF(this.getOuterCornerRadius(), this.getBorderBox().height() - this.getPreBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getSharpCornerVertex() {
        return new PointF(this.getPostBorderWidth() / 2.0f, this.getBorderBox().height() - this.getPreBorderWidth() / 2.0f);
    }

    @Override
    @NonNull
    protected PointF getSharpCornerStart() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.y = this.getBorderBox().height();
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getSharpCornerEnd() {
        PointF pointF = this.getSharpCornerVertex();
        pointF.x = 0.0f;
        return pointF;
    }

    @Override
    @NonNull
    protected PointF getRoundCornerEnd() {
        return new PointF(this.getPostBorderWidth() / 2.0f, this.getBorderBox().height() - this.getOuterCornerRadius());
    }
}

