/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.taobao.weex.dom.flex.FloatUtil;
import com.taobao.weex.ui.view.border.BorderEdge;
import com.taobao.weex.ui.view.border.BorderStyle;
import com.taobao.weex.ui.view.border.BorderUtil;
import com.taobao.weex.ui.view.border.BottomLeftCorner;
import com.taobao.weex.ui.view.border.BottomRightCorner;
import com.taobao.weex.ui.view.border.TopLeftCorner;
import com.taobao.weex.ui.view.border.TopRightCorner;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class BorderDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    public static final int BORDER_RADIUS_ALL = 8;
    static final int DEFAULT_BORDER_COLOR = -16777216;
    static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final float DEFAULT_BORDER_RADIUS = 0.0f;
    private static final BorderStyle DEFAULT_BORDER_STYLE = BorderStyle.SOLID;
    private static final String TAG = "Border";
    private final Paint mPaint = new Paint(1);
    @Nullable
    private SparseArray<Float> mBorderWidth;
    @Nullable
    private SparseArray<Float> mBorderRadius;
    @Nullable
    private SparseArray<Float> mOverlappingBorderRadius;
    @Nullable
    private SparseIntArray mBorderColor;
    @Nullable
    private SparseIntArray mBorderStyle;
    @Nullable
    private Path mPathForBorderOutline;
    private boolean mNeedUpdatePath = false;
    private int mColor = 0;
    private Shader mShader = null;
    private int mAlpha = 255;

    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        this.updateBorderOutline();
        if (this.mPathForBorderOutline != null) {
            int useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha);
            if (this.mShader != null) {
                this.mPaint.setShader(this.mShader);
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawPath(this.mPathForBorderOutline, this.mPaint);
                this.mPaint.setShader(null);
            } else if (useColor >>> 24 != 0) {
                this.mPaint.setColor(useColor);
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawPath(this.mPathForBorderOutline, this.mPaint);
                this.mPaint.setShader(null);
            }
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.drawBorders(canvas);
        this.mPaint.setShader(null);
        canvas.restore();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePath = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return this.mShader != null ? -1 : WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mPathForBorderOutline == null) {
                this.mNeedUpdatePath = true;
            }
            this.updateBorderOutline();
            outline.setConvexPath(this.mPathForBorderOutline);
        }
    }

    public void setBorderWidth(int position, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new SparseArray(5);
            this.mBorderWidth.put(8, (Object)Float.valueOf(0.0f));
        }
        if (!FloatUtil.floatsEqual(this.getBorderWidth(position), width)) {
            BorderUtil.updateSparseArray(this.mBorderWidth, position, Float.valueOf(width));
            this.mBorderWidth.put(position, (Object)Float.valueOf(width));
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    float getBorderWidth(int position) {
        return BorderUtil.fetchFromSparseArray(this.mBorderWidth, position, Float.valueOf(0.0f)).floatValue();
    }

    public void setBorderRadius(int position, float radius) {
        if (this.mBorderRadius == null) {
            this.mBorderRadius = new SparseArray(5);
            this.mBorderRadius.put(8, (Object)Float.valueOf(0.0f));
        }
        if (!FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, position), radius)) {
            BorderUtil.updateSparseArray(this.mBorderRadius, position, Float.valueOf(radius), true);
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    @Deprecated
    float getBorderRadius(int position) {
        return this.getBorderRadius(this.mOverlappingBorderRadius, position);
    }

    @NonNull
    public float[] getBorderRadius(RectF borderBox) {
        this.prepareBorderRadius(borderBox);
        float topLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 0);
        float topRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 1);
        float bottomRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 2);
        float bottomLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 3);
        return new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
    }

    public void setBorderColor(int position, int color) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new SparseIntArray(5);
            this.mBorderColor.put(8, -16777216);
        }
        if (this.getBorderColor(position) != color) {
            BorderUtil.updateSparseArray(this.mBorderColor, position, color);
            this.invalidateSelf();
        }
    }

    int getBorderColor(int position) {
        return BorderUtil.fetchFromSparseArray(this.mBorderColor, position, -16777216);
    }

    public void setBorderStyle(int position, @NonNull String style) {
        if (this.mBorderStyle == null) {
            this.mBorderStyle = new SparseIntArray(5);
            this.mBorderStyle.put(8, DEFAULT_BORDER_STYLE.ordinal());
        }
        try {
            int borderStyle = BorderStyle.valueOf(style.toUpperCase(Locale.US)).ordinal();
            if (this.getBorderStyle(position) != borderStyle) {
                BorderUtil.updateSparseArray(this.mBorderStyle, position, borderStyle);
                this.invalidateSelf();
            }
        }
        catch (IllegalArgumentException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
    }

    int getBorderStyle(int position) {
        return BorderUtil.fetchFromSparseArray(this.mBorderStyle, position, BorderStyle.SOLID.ordinal());
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    public void setImage(Shader shader) {
        this.mShader = shader;
        this.invalidateSelf();
    }

    public boolean isRounded() {
        return this.mBorderRadius != null && (!FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, 0), 0.0f) || !FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, 1), 0.0f) || !FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, 2), 0.0f) || !FloatUtil.floatsEqual(this.getBorderRadius(this.mBorderRadius, 3), 0.0f));
    }

    @NonNull
    public Path getContentPath(@NonNull RectF borderBox) {
        Path contentClip = new Path();
        this.prepareBorderPath(0, 0, 0, 0, borderBox, contentClip);
        return contentClip;
    }

    private float getBorderRadius(@Nullable SparseArray<Float> borderRadius, int position) {
        return BorderUtil.fetchFromSparseArray(borderRadius, position, Float.valueOf(0.0f)).floatValue();
    }

    private void updateBorderOutline() {
        if (this.mNeedUpdatePath) {
            this.mNeedUpdatePath = false;
            if (this.mPathForBorderOutline == null) {
                this.mPathForBorderOutline = new Path();
            }
            this.mPathForBorderOutline.reset();
            this.prepareBorderPath(0, 0, 0, 0, new RectF(this.getBounds()), this.mPathForBorderOutline);
        }
    }

    private void prepareBorderPath(int topPadding, int rightPadding, int bottomPadding, int leftPadding, @NonNull RectF rectF, @NonNull Path path) {
        if (this.mBorderRadius != null) {
            this.prepareBorderRadius(rectF);
            float topLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 0);
            float topRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 1);
            float bottomRightRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 2);
            float bottomLeftRadius = this.getBorderRadius(this.mOverlappingBorderRadius, 3);
            path.addRoundRect(rectF, new float[]{topLeftRadius - (float)leftPadding, topLeftRadius - (float)topPadding, topRightRadius - (float)rightPadding, topRightRadius - (float)topPadding, bottomRightRadius - (float)rightPadding, bottomRightRadius - (float)bottomPadding, bottomLeftRadius - (float)leftPadding, bottomLeftRadius - (float)bottomPadding}, Path.Direction.CW);
        } else {
            path.addRect(rectF, Path.Direction.CW);
        }
    }

    private void prepareBorderRadius(@NonNull RectF borderBox) {
        if (this.mBorderRadius != null) {
            float factor = this.getScaleFactor(borderBox);
            if (this.mOverlappingBorderRadius == null) {
                this.mOverlappingBorderRadius = new SparseArray(5);
                this.mOverlappingBorderRadius.put(8, (Object)Float.valueOf(0.0f));
            }
            if (!Float.isNaN(factor) && factor < 1.0f) {
                this.mOverlappingBorderRadius.put(0, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 0) * factor));
                this.mOverlappingBorderRadius.put(1, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 1) * factor));
                this.mOverlappingBorderRadius.put(2, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 2) * factor));
                this.mOverlappingBorderRadius.put(3, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 3) * factor));
            } else {
                this.mOverlappingBorderRadius.put(0, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 0)));
                this.mOverlappingBorderRadius.put(1, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 1)));
                this.mOverlappingBorderRadius.put(2, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 2)));
                this.mOverlappingBorderRadius.put(3, (Object)Float.valueOf(this.getBorderRadius(this.mBorderRadius, 3)));
            }
        }
    }

    private float getScaleFactor(@NonNull RectF borderBox) {
        float topRadius = this.getBorderRadius(this.mBorderRadius, 0) + this.getBorderRadius(this.mBorderRadius, 1);
        float rightRadius = this.getBorderRadius(this.mBorderRadius, 1) + this.getBorderRadius(this.mBorderRadius, 2);
        float bottomRadius = this.getBorderRadius(this.mBorderRadius, 2) + this.getBorderRadius(this.mBorderRadius, 3);
        float leftRadius = this.getBorderRadius(this.mBorderRadius, 3) + this.getBorderRadius(this.mBorderRadius, 0);
        ArrayList<Float> factors = new ArrayList<Float>(4);
        this.updateFactor(factors, borderBox.width(), topRadius);
        this.updateFactor(factors, borderBox.height(), rightRadius);
        this.updateFactor(factors, borderBox.width(), bottomRadius);
        this.updateFactor(factors, borderBox.height(), leftRadius);
        float factor = factors.isEmpty() ? Float.NaN : Collections.min(factors).floatValue();
        return factor;
    }

    private void updateFactor(@NonNull List<Float> list, float numerator, float denominator) {
        if (!FloatUtil.floatsEqual(denominator, 0.0f)) {
            list.add(Float.valueOf(numerator / denominator));
        }
    }

    private void drawBorders(Canvas canvas) {
        RectF rectBounds = new RectF(this.getBounds());
        TopLeftCorner topLeft = new TopLeftCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 0), this.getBorderWidth(0), this.getBorderWidth(1), rectBounds);
        TopRightCorner topRight = new TopRightCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 1), this.getBorderWidth(1), this.getBorderWidth(2), rectBounds);
        BottomRightCorner bottomRight = new BottomRightCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 2), this.getBorderWidth(2), this.getBorderWidth(3), rectBounds);
        BottomLeftCorner bottomLeft = new BottomLeftCorner(this.getBorderRadius(this.mOverlappingBorderRadius, 3), this.getBorderWidth(3), this.getBorderWidth(0), rectBounds);
        this.drawOneSide(canvas, new BorderEdge(topLeft, topRight, 1, this.getBorderWidth(1)));
        this.drawOneSide(canvas, new BorderEdge(topRight, bottomRight, 2, this.getBorderWidth(2)));
        this.drawOneSide(canvas, new BorderEdge(bottomRight, bottomLeft, 3, this.getBorderWidth(3)));
        this.drawOneSide(canvas, new BorderEdge(bottomLeft, topLeft, 0, this.getBorderWidth(0)));
    }

    private void drawOneSide(Canvas canvas, @NonNull BorderEdge borderEdge) {
        if (!FloatUtil.floatsEqual(0.0f, this.getBorderWidth(borderEdge.getEdge()))) {
            this.preparePaint(borderEdge.getEdge());
            borderEdge.drawEdge(canvas, this.mPaint);
        }
    }

    private void preparePaint(int side) {
        float borderWidth = this.getBorderWidth(side);
        int color = WXViewUtils.multiplyColorAlpha(this.getBorderColor(side), this.mAlpha);
        BorderStyle borderStyle = BorderStyle.values()[this.getBorderStyle(side)];
        Shader shader = borderStyle.getLineShader(borderWidth, color, side);
        this.mPaint.setShader(shader);
        this.mPaint.setColor(color);
        this.mPaint.setStrokeWidth(borderWidth);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }
}

