/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import com.taobao.weex.dom.flex.FloatUtil;

abstract class BorderCorner {
    static final float SWEEP_ANGLE = 45.0f;
    private final float mCornerRadius;
    private final float mPreBorderWidth;
    private final float mPostBorderWidth;
    private final RectF mBorderBox;

    BorderCorner(float cornerRadius, float preBorderWidth, float postBorderWidth, @NonNull RectF borderBox) {
        this.mCornerRadius = cornerRadius;
        this.mPreBorderWidth = preBorderWidth;
        this.mPostBorderWidth = postBorderWidth;
        this.mBorderBox = borderBox;
    }

    boolean hasInnerCorner() {
        return this.hasOuterCorner() && this.getPreBorderWidth() >= 0.0f && this.getPostBorderWidth() >= 0.0f && this.getOuterCornerRadius() > this.getPreBorderWidth() && this.getOuterCornerRadius() > this.getPostBorderWidth();
    }

    boolean hasOuterCorner() {
        return this.getOuterCornerRadius() > 0.0f && !FloatUtil.floatsEqual(0.0f, this.getOuterCornerRadius());
    }

    protected float getPreBorderWidth() {
        return this.mPreBorderWidth;
    }

    protected float getPostBorderWidth() {
        return this.mPostBorderWidth;
    }

    protected float getOuterCornerRadius() {
        return this.mCornerRadius;
    }

    @NonNull
    PointF getCornerStart() {
        PointF lineStart = this.hasOuterCorner() ? this.getRoundCornerStart() : this.getSharpCornerVertex();
        return lineStart;
    }

    @NonNull
    protected abstract PointF getRoundCornerStart();

    @NonNull
    protected abstract PointF getSharpCornerVertex();

    @NonNull
    PointF getCornerEnd() {
        PointF lineEnd = this.hasOuterCorner() ? this.getRoundCornerEnd() : this.getSharpCornerVertex();
        return lineEnd;
    }

    @NonNull
    protected abstract PointF getRoundCornerEnd();

    protected abstract float getAngleBisectorDegree();

    @NonNull
    protected abstract PointF getSharpCornerStart();

    @NonNull
    protected abstract PointF getSharpCornerEnd();

    @NonNull
    protected abstract RectF getOvalIfInnerCornerExist();

    @NonNull
    protected abstract RectF getOvalIfInnerCornerNotExist();

    protected RectF getBorderBox() {
        return this.mBorderBox;
    }
}

