/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomTask;
import com.taobao.weex.ui.animation.DimensionUpdateListener;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WXAnimationModule
extends WXModule {
    @JSMethod
    public void transition(@Nullable String ref, @Nullable String animation, @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)ref) && !TextUtils.isEmpty((CharSequence)animation)) {
            Message msg = Message.obtain();
            WXDomTask task = new WXDomTask();
            task.instanceId = this.mWXSDKInstance.getInstanceId();
            task.args = new ArrayList<Object>();
            task.args.add(ref);
            task.args.add(animation);
            task.args.add(callBack);
            msg.what = 12;
            msg.obj = task;
            WXSDKManager.getInstance().getWXDomManager().sendMessage(msg);
        }
    }

    public static void startAnimation(WXSDKInstance mWXSDKInstance, WXComponent component, @NonNull WXAnimationBean animationBean, @Nullable String callback) {
        if (component == null) {
            return;
        }
        if (component.getHostView() == null) {
            AnimationHolder holder = new AnimationHolder(animationBean, callback);
            component.postAnimation(holder);
            return;
        }
        try {
            ObjectAnimator animator = WXAnimationModule.createAnimator(animationBean, component.getHostView(), mWXSDKInstance.getViewPortWidth());
            if (animator != null) {
                Animator.AnimatorListener animatorCallback = WXAnimationModule.createAnimatorListener(mWXSDKInstance, callback);
                if (Build.VERSION.SDK_INT < 18) {
                    component.getHostView().setLayerType(2, null);
                }
                Interpolator interpolator = WXAnimationModule.createTimeInterpolator(animationBean);
                if (animatorCallback != null) {
                    animator.addListener(animatorCallback);
                }
                if (interpolator != null) {
                    animator.setInterpolator((TimeInterpolator)interpolator);
                }
                animator.setDuration(animationBean.duration);
                animator.start();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            WXLogUtils.e("", e);
        }
    }

    @Nullable
    private static ObjectAnimator createAnimator(@NonNull WXAnimationBean animation, View target, int viewPortWidth) {
        if (target == null) {
            return null;
        }
        WXAnimationBean.Style style = animation.styles;
        if (style != null) {
            List<PropertyValuesHolder> holders = style.getHolders();
            if (!TextUtils.isEmpty((CharSequence)style.backgroundColor)) {
                BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(target);
                if (borderDrawable != null) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{borderDrawable.getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                } else if (target.getBackground() instanceof ColorDrawable) {
                    holders.add(PropertyValuesHolder.ofObject((String)"backgroundColor", (TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{((ColorDrawable)target.getBackground()).getColor(), WXResourceUtils.getColor(style.backgroundColor)}));
                }
            }
            if (style.getPivot() != null) {
                Pair<Float, Float> pair = style.getPivot();
                target.setPivotX(((Float)pair.first).floatValue());
                target.setPivotY(((Float)pair.second).floatValue());
            }
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])holders.toArray(new PropertyValuesHolder[holders.size()]));
            animator.setStartDelay(animation.delay);
            if (!(target.getLayoutParams() == null || TextUtils.isEmpty((CharSequence)style.width) && TextUtils.isEmpty((CharSequence)style.height))) {
                DimensionUpdateListener listener = new DimensionUpdateListener(target);
                ViewGroup.LayoutParams layoutParams = target.getLayoutParams();
                if (!TextUtils.isEmpty((CharSequence)style.width)) {
                    listener.setWidth(layoutParams.width, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.width), viewPortWidth));
                }
                if (!TextUtils.isEmpty((CharSequence)style.height)) {
                    listener.setHeight(layoutParams.height, (int)WXViewUtils.getRealPxByWidth(WXUtils.getFloat(style.height), viewPortWidth));
                }
                animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)listener);
            }
            return animator;
        }
        return null;
    }

    @Nullable
    public static Animator.AnimatorListener createAnimatorListener(final WXSDKInstance mWXSDKInstance, final @Nullable String callBack) {
        if (!TextUtils.isEmpty((CharSequence)callBack)) {
            return new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (mWXSDKInstance == null) {
                        WXLogUtils.e("WXRenderStatement-onAnimationEnd mWXSDKInstance == null NPE");
                    } else {
                        WXSDKManager.getInstance().callback(mWXSDKInstance.getInstanceId(), callBack, new HashMap<String, Object>());
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    private static Interpolator createTimeInterpolator(@NonNull WXAnimationBean animation) {
        String interpolator = animation.timingFunction;
        if (!TextUtils.isEmpty((CharSequence)interpolator)) {
            switch (interpolator) {
                case "ease-in": {
                    return new AccelerateInterpolator();
                }
                case "ease-out": {
                    return new DecelerateInterpolator();
                }
                case "ease-in-out": {
                    return new AccelerateDecelerateInterpolator();
                }
                case "linear": {
                    return new LinearInterpolator();
                }
            }
            try {
                SingleFunctionParser<Float> parser = new SingleFunctionParser<Float>(animation.timingFunction, new SingleFunctionParser.FlatMapper<Float>(){

                    @Override
                    public Float map(String raw) {
                        return Float.valueOf(Float.parseFloat(raw));
                    }
                });
                List<Float> params = parser.parse("cubic-bezier");
                if (params != null && params.size() == 4) {
                    return PathInterpolatorCompat.create((float)params.get(0).floatValue(), (float)params.get(1).floatValue(), (float)params.get(2).floatValue(), (float)params.get(3).floatValue());
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }

    public static class AnimationHolder {
        private WXAnimationBean wxAnimationBean;
        private String callback;

        public void execute(WXSDKInstance mInstance, WXComponent component) {
            WXAnimationModule.startAnimation(mInstance, component, this.wxAnimationBean, this.callback);
        }

        private AnimationHolder(WXAnimationBean wxAnimationBean, String callback) {
            this.wxAnimationBean = wxAnimationBean;
            this.callback = callback;
        }
    }
}

