/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSLayoutContext;
import com.taobao.weex.dom.flex.Spacing;
import com.taobao.weex.ui.IWXRenderTask;
import com.taobao.weex.ui.WXRenderManager;
import com.taobao.weex.ui.animation.WXAnimationBean;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class WXDomStatement {
    final ConcurrentHashMap<String, WXDomObject> mRegistry;
    private WXDomObject.Consumer mAddDOMConsumer;
    private String mInstanceId;
    private WXRenderManager mWXRenderManager;
    private ArrayList<IWXRenderTask> mNormalTasks;
    private Set<Pair<String, Map<String, Object>>> animations;
    private CSSLayoutContext mLayoutContext;
    private volatile boolean mDirty;
    private boolean mDestroy = false;
    private Map<String, AddDomInfo> mAddDom = new HashMap<String, AddDomInfo>();

    public WXDomStatement(String instanceId, WXRenderManager renderManager) {
        this.mInstanceId = instanceId;
        this.mLayoutContext = new CSSLayoutContext();
        this.mRegistry = new ConcurrentHashMap();
        this.mNormalTasks = new ArrayList();
        this.animations = new LinkedHashSet<Pair<String, Map<String, Object>>>();
        this.mWXRenderManager = renderManager;
        this.mAddDOMConsumer = new AddDOMConsumer(this.mRegistry);
    }

    public void destroy() {
        this.mDestroy = true;
        this.mRegistry.clear();
        this.mAddDOMConsumer = null;
        this.mNormalTasks.clear();
        this.mAddDom.clear();
        this.mLayoutContext = null;
        this.mWXRenderManager = null;
        this.animations.clear();
    }

    void rebuildingFixedDomTree(WXDomObject root) {
        if (root != null && root.getFixedStyleRefs() != null) {
            int size = root.getFixedStyleRefs().size();
            for (int i = 0; i < size; ++i) {
                String fixedRef = root.getFixedStyleRefs().get(i);
                WXDomObject wxDomObject = this.mRegistry.get(fixedRef);
                if (wxDomObject == null || wxDomObject.parent == null) continue;
                wxDomObject.parent.remove(wxDomObject);
                root.add(wxDomObject, -1);
            }
        }
    }

    void batch() {
        if (!this.mDirty || this.mDestroy) {
            return;
        }
        WXDomObject rootDom = this.mRegistry.get("_root");
        this.layout(rootDom);
    }

    void layout(WXDomObject rootDom) {
        if (rootDom == null) {
            return;
        }
        long start0 = System.currentTimeMillis();
        this.rebuildingFixedDomTree(rootDom);
        rootDom.traverseTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (!dom.hasUpdate() || WXDomStatement.this.mDestroy) {
                    return;
                }
                dom.layoutBefore();
            }
        });
        long start = System.currentTimeMillis();
        rootDom.calculateLayout(this.mLayoutContext);
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.cssLayoutTime(System.currentTimeMillis() - start);
        }
        rootDom.traverseTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                if (!dom.hasUpdate() || WXDomStatement.this.mDestroy) {
                    return;
                }
                dom.layoutAfter();
            }
        });
        start = System.currentTimeMillis();
        rootDom.traverseTree(new ApplyUpdateConsumer());
        if (instance != null) {
            instance.applyUpdateTime(System.currentTimeMillis() - start);
        }
        start = System.currentTimeMillis();
        this.updateDomObj();
        if (instance != null) {
            instance.updateDomObjTime(System.currentTimeMillis() - start);
        }
        this.parseAnimation();
        int count = this.mNormalTasks.size();
        for (int i = 0; i < count && !this.mDestroy; ++i) {
            this.mWXRenderManager.runOnThread(this.mInstanceId, this.mNormalTasks.get(i));
        }
        this.mNormalTasks.clear();
        this.mAddDom.clear();
        this.animations.clear();
        this.mDirty = false;
        if (instance != null) {
            instance.batchTime(System.currentTimeMillis() - start0);
        }
    }

    private void parseAnimation() {
        for (final Pair<String, Map<String, Object>> pair : this.animations) {
            WXAnimationBean animationBean;
            if (TextUtils.isEmpty((CharSequence)((CharSequence)pair.first)) || (animationBean = this.createAnimationBean((String)pair.first, (Map)pair.second)) == null) continue;
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    WXDomStatement.this.mWXRenderManager.startAnimation(WXDomStatement.this.mInstanceId, (String)pair.first, animationBean, null);
                }

                public String toString() {
                    return "startAnimationByStyle";
                }
            });
        }
    }

    void createBody(JSONObject dom) {
        this.addDomInternal(dom, true, null, -1);
    }

    private void updateDomObj() {
        long start = System.currentTimeMillis();
        for (Map.Entry<String, AddDomInfo> entry : this.mAddDom.entrySet()) {
            AddDomInfo value = entry.getValue();
            this.updateDomObj(value.component);
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("updateDomObj", "time:" + (System.currentTimeMillis() - start));
        }
    }

    private void updateDomObj(WXComponent component) {
        if (component == null) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(component.getRef());
        if (domObject == null) {
            return;
        }
        domObject.old();
        component.updateDom(domObject);
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                this.updateDomObj(container.getChild(i));
            }
        }
    }

    void invokeMethod(String ref, String method, JSONArray args) {
        if (this.mDestroy) {
            return;
        }
        WXComponent comp = this.mWXRenderManager.getWXComponent(this.mInstanceId, ref);
        if (comp == null) {
            WXLogUtils.e("DomStatement", "target component not found.");
            return;
        }
        comp.invoke(method, args);
    }

    private void addDomInternal(JSONObject dom, boolean isRoot, String parentRef, int index) {
        WXComponent component;
        WXDomObject domObject;
        WXErrorCode errCode;
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance == null) {
            return;
        }
        WXErrorCode wXErrorCode = errCode = isRoot ? WXErrorCode.WX_ERR_DOM_CREATEBODY : WXErrorCode.WX_ERR_DOM_ADDELEMENT;
        if (dom == null) {
            instance.commitUTStab("domModule", errCode);
        }
        if ((domObject = WXDomObject.parse(dom, instance)) == null || this.mRegistry.containsKey(domObject.getRef())) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXDomStatement] " + (isRoot ? "createBody" : "addDom") + " error,DOM object is null or already registered!!");
            }
            instance.commitUTStab("domModule", errCode);
            return;
        }
        if (isRoot) {
            WXDomObject.prepareRoot(domObject, WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexHeight(this.mInstanceId), WXSDKManager.getInstanceViewPortWidth(this.mInstanceId)), WXViewUtils.getWebPxByWidth(WXViewUtils.getWeexWidth(this.mInstanceId), WXSDKManager.getInstanceViewPortWidth(this.mInstanceId)));
        } else {
            WXDomObject parent = this.mRegistry.get(parentRef);
            if (parent == null) {
                instance.commitUTStab("domModule", errCode);
                return;
            }
            parent.add(domObject, index);
        }
        domObject.traverseTree(this.mAddDOMConsumer, ApplyStyleConsumer.getInstance());
        WXComponent wXComponent = component = isRoot ? this.mWXRenderManager.createBodyOnDomThread(this.mInstanceId, domObject) : this.mWXRenderManager.createComponentOnDomThread(this.mInstanceId, domObject, parentRef, index);
        if (component == null) {
            instance.commitUTStab("domModule", errCode);
            return;
        }
        AddDomInfo addDomInfo = new AddDomInfo();
        addDomInfo.component = component;
        this.mAddDom.put(domObject.getRef(), addDomInfo);
        IWXRenderTask task = isRoot ? new CreateBodyTask(component) : new AddDOMTask(component, parentRef, index);
        this.mNormalTasks.add(task);
        this.addAnimationForDomTree(domObject);
        this.mDirty = true;
        instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
    }

    void addDom(JSONObject dom, String parentRef, int index) {
        this.addDomInternal(dom, false, parentRef, index);
    }

    void moveDom(final String ref, final String parentRef, int index) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        WXDomObject parentObject = this.mRegistry.get(parentRef);
        if (domObject == null || domObject.parent == null || parentObject == null || parentObject.hasNewLayout()) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_MOVEELEMENT);
            }
            return;
        }
        if (domObject.parent.equals(parentObject)) {
            if (parentObject.index(domObject) == index) {
                return;
            }
            if (domObject.parent.index(domObject) < index) {
                --index;
            }
        }
        final int newIndex = index;
        domObject.parent.remove(domObject);
        parentObject.add(domObject, newIndex);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.moveComponent(WXDomStatement.this.mInstanceId, ref, parentRef, newIndex);
            }

            public String toString() {
                return "moveDom";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeDom(final String ref) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        WXDomObject parent = domObject.parent;
        if (parent == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEELEMENT);
            }
            return;
        }
        domObject.traverseTree(new WXDomObject.Consumer(){

            @Override
            public void accept(WXDomObject dom) {
                WXDomStatement.this.mRegistry.remove(dom.getRef());
            }
        });
        parent.remove(domObject);
        this.mRegistry.remove(ref);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.removeComponent(WXDomStatement.this.mInstanceId, ref);
            }

            public String toString() {
                return "removeDom";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void updateAttrs(String ref, final JSONObject attrs) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        final WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATEATTRS);
            }
            return;
        }
        domObject.updateAttr((Map<String, Object>)attrs);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateAttrs(WXDomStatement.this.mInstanceId, domObject.getRef(), (Map<String, Object>)attrs);
            }

            public String toString() {
                return "updateAttr";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void updateStyle(String ref, JSONObject style, boolean byPesudo) {
        if (this.mDestroy || style == null) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_UPDATESTYLE);
            }
            return;
        }
        ArrayMap animationMap = new ArrayMap(2);
        animationMap.put("transform", style.remove((Object)"transform"));
        animationMap.put("transformOrigin", style.remove((Object)"transformOrigin"));
        this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)ref, (Object)animationMap));
        if (!style.isEmpty()) {
            domObject.updateStyle((Map<String, Object>)style, byPesudo);
            domObject.traverseTree(ApplyStyleConsumer.getInstance());
            this.updateStyle(domObject, (Map<String, Object>)style);
        }
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    private void updateStyle(final WXDomObject domObject, final Map<String, Object> update) {
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateStyle(WXDomStatement.this.mInstanceId, domObject.getRef(), update);
            }

            public String toString() {
                return "updateStyle";
            }
        });
        if (update.containsKey("padding") || update.containsKey("paddingTop") || update.containsKey("paddingLeft") || update.containsKey("paddingRight") || update.containsKey("paddingBottom") || update.containsKey("borderWidth")) {
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    Spacing padding = domObject.getPadding();
                    Spacing border = domObject.getBorder();
                    WXDomStatement.this.mWXRenderManager.setPadding(WXDomStatement.this.mInstanceId, domObject.getRef(), padding, border);
                }

                public String toString() {
                    return "setPadding";
                }
            });
        }
    }

    void addEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        final WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_ADDEVENT);
            }
            return;
        }
        domObject.addEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXComponent comp = WXDomStatement.this.mWXRenderManager.getWXComponent(WXDomStatement.this.mInstanceId, ref);
                if (comp != null) {
                    comp.updateDom(domObject);
                    WXDomStatement.this.mWXRenderManager.addEvent(WXDomStatement.this.mInstanceId, ref, type);
                }
            }

            public String toString() {
                return "Add event";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void removeEvent(final String ref, final String type) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        final WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            if (instance != null) {
                instance.commitUTStab("domModule", WXErrorCode.WX_ERR_DOM_REMOVEEVENT);
            }
            return;
        }
        domObject.removeEvent(type);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXComponent comp = WXDomStatement.this.mWXRenderManager.getWXComponent(WXDomStatement.this.mInstanceId, ref);
                if (comp != null) {
                    comp.updateDom(domObject);
                    WXDomStatement.this.mWXRenderManager.removeEvent(WXDomStatement.this.mInstanceId, ref, type);
                }
            }

            public String toString() {
                return "removeEvent";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void scrollToDom(final String ref, final JSONObject options) {
        if (this.mDestroy) {
            return;
        }
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.scrollToComponent(WXDomStatement.this.mInstanceId, ref, (Map<String, Object>)options);
            }

            public String toString() {
                return "scrollToPosition";
            }
        });
        this.mDirty = true;
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void createFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.createFinish(WXDomStatement.this.mInstanceId, (int)root.getLayoutWidth(), (int)root.getLayoutHeight());
            }

            public String toString() {
                return "createFinish";
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void refreshFinish() {
        if (this.mDestroy) {
            return;
        }
        final WXDomObject root = this.mRegistry.get("_root");
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                int realWidth = (int)root.getLayoutWidth();
                int realHeight = (int)root.getLayoutHeight();
                WXDomStatement.this.mWXRenderManager.refreshFinish(WXDomStatement.this.mInstanceId, realWidth, realHeight);
            }

            public String toString() {
                return "refreshFinish";
            }
        });
        this.mDirty = true;
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void updateFinish() {
        if (this.mDestroy) {
            return;
        }
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.updateFinish(WXDomStatement.this.mInstanceId);
            }

            public String toString() {
                return "updateFinish";
            }
        });
        WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (instance != null) {
            instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
        }
    }

    void startAnimation(final @NonNull String ref, @NonNull String animation, final @Nullable String callBack) {
        if (this.mDestroy) {
            return;
        }
        WXDomObject domObject = this.mRegistry.get(ref);
        if (domObject == null) {
            return;
        }
        final WXAnimationBean animationBean = this.createAnimationBean(ref, animation);
        if (animationBean != null) {
            this.mNormalTasks.add(new IWXRenderTask(){

                @Override
                public void execute() {
                    WXDomStatement.this.mWXRenderManager.startAnimation(WXDomStatement.this.mInstanceId, ref, animationBean, callBack);
                }

                public String toString() {
                    return "startAnimationByCall";
                }
            });
            this.mDirty = true;
        }
    }

    private void addAnimationForDomTree(WXDomObject domObject) {
        this.animations.add((Pair<String, Map<String, Object>>)new Pair((Object)domObject.getRef(), (Object)domObject.getStyles()));
        for (int i = 0; i < domObject.childCount(); ++i) {
            this.addAnimationForDomTree(domObject.getChild(i));
        }
    }

    private WXAnimationBean createAnimationBean(String ref, String animation) {
        try {
            WXAnimationBean animationBean = (WXAnimationBean)JSONObject.parseObject((String)animation, WXAnimationBean.class);
            if (animationBean != null && animationBean.styles != null) {
                WXDomObject domObject = this.mRegistry.get(ref);
                int width = (int)domObject.getLayoutWidth();
                int height = (int)domObject.getLayoutHeight();
                WXAnimationBean.Style style = animationBean.styles;
                String string2 = animationBean.styles.transformOrigin;
                String string3 = animationBean.styles.transform;
                WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
                style.init(string2, string3, width, height, WXSDKInstance.getViewPortWidth());
            }
            return animationBean;
        }
        catch (RuntimeException e) {
            WXLogUtils.e("", e);
            return null;
        }
    }

    private WXAnimationBean createAnimationBean(String ref, Map<String, Object> style) {
        if (style != null) {
            try {
                Object transform = style.get("transform");
                if (transform instanceof String && !TextUtils.isEmpty((CharSequence)((String)transform))) {
                    String transformOrigin = (String)style.get("transformOrigin");
                    WXAnimationBean animationBean = new WXAnimationBean();
                    WXDomObject domObject = this.mRegistry.get(ref);
                    int width = (int)domObject.getLayoutWidth();
                    int height = (int)domObject.getLayoutHeight();
                    WXAnimationBean.Style style2 = animationBean.styles = new WXAnimationBean.Style();
                    String string2 = (String)transform;
                    WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
                    style2.init(transformOrigin, string2, width, height, WXSDKInstance.getViewPortWidth());
                    return animationBean;
                }
            }
            catch (RuntimeException e) {
                WXLogUtils.e("", e);
                return null;
            }
        }
        return null;
    }

    public void getComponentSize(final String ref, final JSCallback callback) {
        if (this.mDestroy) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Component does not exist");
            callback.invoke(options);
            return;
        }
        this.mNormalTasks.add(new IWXRenderTask(){

            @Override
            public void execute() {
                WXDomStatement.this.mWXRenderManager.getComponentSize(WXDomStatement.this.mInstanceId, ref, callback);
            }

            public String toString() {
                return "getComponentSize";
            }
        });
        this.mDirty = true;
    }

    static class AddDomInfo {
        public WXComponent component;

        AddDomInfo() {
        }
    }

    static class ApplyStyleConsumer
    implements WXDomObject.Consumer {
        static ApplyStyleConsumer sInstance;

        public static ApplyStyleConsumer getInstance() {
            if (sInstance == null) {
                sInstance = new ApplyStyleConsumer();
            }
            return sInstance;
        }

        private ApplyStyleConsumer() {
        }

        @Override
        public void accept(WXDomObject dom) {
            WXStyle style = dom.getStyles();
            Map<String, String> defaults = dom.getDefaultStyle();
            if (defaults != null) {
                for (Map.Entry<String, String> entry : defaults.entrySet()) {
                    if (style.containsKey(entry.getKey())) continue;
                    style.put(entry.getKey(), (Object)entry.getValue());
                }
            }
            if (dom.getStyles().size() > 0) {
                dom.applyStyleToNode();
            }
        }
    }

    private static class AddDOMConsumer
    implements WXDomObject.Consumer {
        final ConcurrentHashMap<String, WXDomObject> mRegistry;

        AddDOMConsumer(ConcurrentHashMap<String, WXDomObject> r) {
            this.mRegistry = r;
        }

        @Override
        public void accept(WXDomObject dom) {
            dom.young();
            this.mRegistry.put(dom.getRef(), dom);
            WXDomObject rootDom = this.mRegistry.get("_root");
            if (rootDom != null && dom.isFixed()) {
                rootDom.add2FixedDomList(dom.getRef());
            }
        }
    }

    private class AddDOMTask
    implements IWXRenderTask {
        final WXComponent mComponent;
        final String mParentRef;
        final int mIndex;

        AddDOMTask(WXComponent comp, String parentRef, int index) {
            this.mComponent = comp;
            this.mParentRef = parentRef;
            this.mIndex = index;
        }

        @Override
        public void execute() {
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(WXDomStatement.this.mInstanceId);
            if (instance == null || instance.getContext() == null) {
                WXLogUtils.e("instance is null or instance is destroy!");
                return;
            }
            try {
                WXDomStatement.this.mWXRenderManager.addComponent(WXDomStatement.this.mInstanceId, this.mComponent, this.mParentRef, this.mIndex);
            }
            catch (Exception e) {
                WXLogUtils.e("add component failed.", e);
            }
        }

        public String toString() {
            return "AddDom";
        }
    }

    private class CreateBodyTask
    implements IWXRenderTask {
        final WXComponent mComponent;

        CreateBodyTask(WXComponent component) {
            this.mComponent = component;
        }

        @Override
        public void execute() {
            WXSDKInstance instance = WXSDKManager.getInstance().getSDKInstance(WXDomStatement.this.mInstanceId);
            if (instance == null || instance.getContext() == null) {
                WXLogUtils.e("instance is null or instance is destroy!");
                return;
            }
            try {
                WXDomStatement.this.mWXRenderManager.createBody(WXDomStatement.this.mInstanceId, this.mComponent);
                instance.commitUTStab("domModule", WXErrorCode.WX_SUCCESS);
            }
            catch (Exception e) {
                WXLogUtils.e("create body failed.", e);
            }
        }

        public String toString() {
            return "createBody";
        }
    }

    class ApplyUpdateConsumer
    implements WXDomObject.Consumer {
        ApplyUpdateConsumer() {
        }

        @Override
        public void accept(WXDomObject dom) {
            if (dom.hasUpdate()) {
                dom.markUpdateSeen();
                if (!dom.isYoung()) {
                    final WXDomObject copy = dom.clone();
                    if (copy == null) {
                        return;
                    }
                    WXDomStatement.this.mNormalTasks.add(new IWXRenderTask(){

                        @Override
                        public void execute() {
                            WXDomStatement.this.mWXRenderManager.setLayout(WXDomStatement.this.mInstanceId, copy.getRef(), copy);
                            if (copy.getExtra() != null) {
                                WXDomStatement.this.mWXRenderManager.setExtra(WXDomStatement.this.mInstanceId, copy.getRef(), copy.getExtra());
                            }
                        }

                        public String toString() {
                            return "setLayout & setExtra";
                        }
                    });
                }
            }
        }
    }
}

