/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.dom;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.dom.DomContext;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObjectFactory;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.dom.flex.CSSNode;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class WXDomObject
extends CSSNode
implements Cloneable,
ImmutableDomObject {
    public static final String CHILDREN = "children";
    public static final String TYPE = "type";
    public static final String TAG = WXDomObject.class.getSimpleName();
    public static final String ROOT = "_root";
    public static final String TRANSFORM = "transform";
    public static final String TRANSFORM_ORIGIN = "transformOrigin";
    private AtomicBoolean sDestroy = new AtomicBoolean();
    private int mViewPortWidth = 750;
    private DomContext mDomContext;
    String mRef = "_root";
    String mType = "div";
    WXStyle mStyles;
    WXAttr mAttributes;
    WXEvent mEvents;
    private List<WXDomObject> mDomChildren;
    @Deprecated
    public WXDomObject parent;
    private ArrayList<String> fixedStyleRefs;
    private boolean mYoung = false;

    void traverseTree(Consumer ... consumers) {
        if (consumers == null) {
            return;
        }
        for (Consumer consumer : consumers) {
            consumer.accept(this);
        }
        int count = this.childCount();
        for (int i = 0; i < count; ++i) {
            WXDomObject child = this.getChild(i);
            child.traverseTree(consumers);
        }
    }

    public int getViewPortWidth() {
        return this.mViewPortWidth;
    }

    public void setViewPortWidth(int mViewPortWidth) {
        this.mViewPortWidth = mViewPortWidth;
    }

    @Override
    public String getRef() {
        return this.mRef;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    @Override
    @NonNull
    public WXStyle getStyles() {
        if (this.mStyles == null) {
            this.mStyles = new WXStyle();
        }
        return this.mStyles;
    }

    @Override
    @NonNull
    public WXAttr getAttrs() {
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr();
        }
        return this.mAttributes;
    }

    @Override
    @NonNull
    public WXEvent getEvents() {
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        return this.mEvents;
    }

    @NonNull
    public DomContext getDomContext() {
        return this.mDomContext;
    }

    public void clearEvents() {
        if (this.mEvents != null) {
            this.mEvents.clear();
        }
    }

    public static void prepareRoot(WXDomObject domObj, float defaultHeight, float defaultWidth) {
        domObj.mRef = ROOT;
        WXStyle domStyles = domObj.getStyles();
        HashMap<String, Object> style = new HashMap<String, Object>(5);
        if (!domStyles.containsKey("flexDirection")) {
            style.put("flexDirection", "column");
        }
        if (!domStyles.containsKey("backgroundColor")) {
            style.put("backgroundColor", "#ffffff");
        }
        style.put("defaultWidth", Float.valueOf(defaultWidth));
        style.put("defaultHeight", Float.valueOf(defaultHeight));
        domObj.updateStyle(style);
    }

    protected final void copyFields(WXDomObject dest) {
        dest.cssstyle.copy(this.cssstyle);
        dest.mRef = this.mRef;
        dest.mType = this.mType;
        dest.mStyles = this.mStyles == null ? null : this.mStyles.clone();
        dest.mAttributes = this.mAttributes == null ? null : this.mAttributes.clone();
        dest.mEvents = this.mEvents == null ? null : this.mEvents.clone();
        dest.csslayout.copy(this.csslayout);
    }

    public void parseFromJson(JSONObject map) {
        Object event;
        Object attr;
        String type;
        if (map == null || map.size() <= 0) {
            return;
        }
        this.mType = type = (String)map.get((Object)TYPE);
        this.mRef = (String)map.get((Object)"ref");
        Object style = map.get((Object)"style");
        if (style != null && style instanceof JSONObject) {
            WXStyle styles = new WXStyle();
            styles.putAll((Map<? extends String, ?>)((JSONObject)style), false);
            this.mStyles = styles;
        }
        if ((attr = map.get((Object)"attr")) != null && attr instanceof JSONObject) {
            WXAttr attrs;
            this.mAttributes = attrs = new WXAttr((Map<String, Object>)((JSONObject)attr));
        }
        if ((event = map.get((Object)"event")) != null && event instanceof JSONArray) {
            WXEvent events = new WXEvent();
            JSONArray eventArray = (JSONArray)event;
            int count = eventArray.size();
            for (int i = 0; i < count; ++i) {
                events.add(eventArray.getString(i));
            }
            this.mEvents = events;
        }
    }

    public void layoutBefore() {
    }

    public void layoutAfter() {
    }

    public final boolean hasUpdate() {
        return this.hasNewLayout() || this.isDirty();
    }

    void young() {
        this.mYoung = true;
    }

    void old() {
        this.mYoung = false;
    }

    boolean isYoung() {
        return this.mYoung;
    }

    public final void markUpdateSeen() {
        if (this.hasNewLayout()) {
            this.markLayoutSeen();
        }
    }

    @Override
    public boolean isFixed() {
        return this.mStyles == null ? false : this.mStyles.isFixed();
    }

    @Override
    public Object getExtra() {
        return null;
    }

    public void remove(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return;
        }
        int index = this.mDomChildren.indexOf(child);
        this.removeFromDom(child);
        if (index != -1) {
            super.removeChildAt(index);
        }
    }

    public void removeFromDom(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return;
        }
        int index = this.mDomChildren.indexOf(child);
        if (index == -1) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("[WXDomObject] remove function error");
            }
            return;
        }
        this.mDomChildren.remove((int)index).parent = null;
    }

    public int index(WXDomObject child) {
        if (child == null || this.mDomChildren == null || this.sDestroy.get()) {
            return -1;
        }
        return this.mDomChildren.indexOf(child);
    }

    public void add(WXDomObject child, int index) {
        int count;
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        if (this.mDomChildren == null) {
            this.mDomChildren = new ArrayList<WXDomObject>();
        }
        int n = index = index >= (count = this.mDomChildren.size()) ? -1 : index;
        if (index == -1) {
            this.mDomChildren.add(child);
            super.addChildAt(child, super.getChildCount());
        } else {
            this.mDomChildren.add(index, child);
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    @Deprecated
    public void add2Dom(WXDomObject child, int index) {
        if (child == null || index < -1 || this.sDestroy.get()) {
            return;
        }
        int count = super.getChildCount();
        int n = index = index >= count ? -1 : index;
        if (index == -1) {
            super.addChildAt(child, super.getChildCount());
        } else {
            super.addChildAt(child, index);
        }
        child.parent = this;
    }

    public WXDomObject getChild(int index) {
        if (this.mDomChildren == null || this.sDestroy.get()) {
            return null;
        }
        return this.mDomChildren.get(index);
    }

    public void addEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.mEvents == null) {
            this.mEvents = new WXEvent();
        }
        if (this.containsEvent(e)) {
            return;
        }
        this.mEvents.add(e);
    }

    public boolean containsEvent(String e) {
        if (this.mEvents == null) {
            return false;
        }
        return this.mEvents.contains(e);
    }

    public void removeEvent(String e) {
        if (TextUtils.isEmpty((CharSequence)e)) {
            return;
        }
        if (this.mEvents == null) {
            return;
        }
        this.mEvents.remove(e);
    }

    public void updateAttr(Map<String, Object> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return;
        }
        if (this.mAttributes == null) {
            this.mAttributes = new WXAttr();
        }
        this.mAttributes.putAll((Map<? extends String, ?>)attrs);
        super.dirty();
    }

    public void updateStyle(Map<String, Object> styles) {
        this.updateStyle(styles, false);
    }

    public void updateStyle(Map<String, Object> styles, boolean byPesudo) {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        if (this.mStyles == null) {
            this.mStyles = new WXStyle();
        }
        this.mStyles.putAll(styles, byPesudo);
        super.dirty();
    }

    void applyStyleToNode() {
        WXStyle stylesMap = this.getStyles();
        if (!stylesMap.isEmpty()) {
            for (Map.Entry<String, Object> item : stylesMap.entrySet()) {
                switch (item.getKey()) {
                    case "alignItems": {
                        this.setAlignItems(stylesMap.getAlignItems());
                        break;
                    }
                    case "alignSelf": {
                        this.setAlignSelf(stylesMap.getAlignSelf());
                        break;
                    }
                    case "flex": {
                        this.setFlex(stylesMap.getFlex());
                        break;
                    }
                    case "flexDirection": {
                        this.setFlexDirection(stylesMap.getFlexDirection());
                        break;
                    }
                    case "justifyContent": {
                        this.setJustifyContent(stylesMap.getJustifyContent());
                        break;
                    }
                    case "flexWrap": {
                        this.setWrap(stylesMap.getCSSWrap());
                        break;
                    }
                    case "minWidth": {
                        this.setMinWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMinWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "minHeight": {
                        this.setMinHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMinHeight(), this.getViewPortWidth()));
                        break;
                    }
                    case "maxWidth": {
                        this.setMaxWidth(WXViewUtils.getRealPxByWidth(stylesMap.getMaxWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "maxHeight": {
                        this.setMaxHeight(WXViewUtils.getRealPxByWidth(stylesMap.getMaxHeight(), this.getViewPortWidth()));
                        break;
                    }
                    case "defaultHeight": 
                    case "height": {
                        this.setStyleHeight(WXViewUtils.getRealPxByWidth(stylesMap.containsKey("height") ? stylesMap.getHeight() : stylesMap.getDefaultHeight(), this.getViewPortWidth()));
                        break;
                    }
                    case "width": 
                    case "defaultWidth": {
                        this.setStyleWidth(WXViewUtils.getRealPxByWidth(stylesMap.containsKey("width") ? stylesMap.getWidth() : stylesMap.getDefaultWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "position": {
                        this.setPositionType(stylesMap.getPosition());
                        break;
                    }
                    case "left": {
                        this.setPositionLeft(WXViewUtils.getRealPxByWidth(stylesMap.getLeft(), this.getViewPortWidth()));
                        break;
                    }
                    case "top": {
                        this.setPositionTop(WXViewUtils.getRealPxByWidth(stylesMap.getTop(), this.getViewPortWidth()));
                        break;
                    }
                    case "right": {
                        this.setPositionRight(WXViewUtils.getRealPxByWidth(stylesMap.getRight(), this.getViewPortWidth()));
                        break;
                    }
                    case "bottom": {
                        this.setPositionBottom(WXViewUtils.getRealPxByWidth(stylesMap.getBottom(), this.getViewPortWidth()));
                        break;
                    }
                    case "margin": {
                        this.setMargin(8, WXViewUtils.getRealPxByWidth(stylesMap.getMargin(), this.getViewPortWidth()));
                        break;
                    }
                    case "marginLeft": {
                        this.setMargin(0, WXViewUtils.getRealPxByWidth(stylesMap.getMarginLeft(), this.getViewPortWidth()));
                        break;
                    }
                    case "marginTop": {
                        this.setMargin(1, WXViewUtils.getRealPxByWidth(stylesMap.getMarginTop(), this.getViewPortWidth()));
                        break;
                    }
                    case "marginRight": {
                        this.setMargin(2, WXViewUtils.getRealPxByWidth(stylesMap.getMarginRight(), this.getViewPortWidth()));
                        break;
                    }
                    case "marginBottom": {
                        this.setMargin(3, WXViewUtils.getRealPxByWidth(stylesMap.getMarginBottom(), this.getViewPortWidth()));
                        break;
                    }
                    case "borderWidth": {
                        this.setBorder(8, WXViewUtils.getRealPxByWidth(stylesMap.getBorderWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "borderTopWidth": {
                        this.setBorder(1, WXViewUtils.getRealPxByWidth(stylesMap.getBorderTopWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "borderRightWidth": {
                        this.setBorder(2, WXViewUtils.getRealPxByWidth(stylesMap.getBorderRightWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "borderBottomWidth": {
                        this.setBorder(3, WXViewUtils.getRealPxByWidth(stylesMap.getBorderBottomWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "borderLeftWidth": {
                        this.setBorder(0, WXViewUtils.getRealPxByWidth(stylesMap.getBorderLeftWidth(), this.getViewPortWidth()));
                        break;
                    }
                    case "padding": {
                        this.setPadding(8, WXViewUtils.getRealPxByWidth(stylesMap.getPadding(), this.getViewPortWidth()));
                        break;
                    }
                    case "paddingLeft": {
                        this.setPadding(0, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingLeft(), this.getViewPortWidth()));
                        break;
                    }
                    case "paddingTop": {
                        this.setPadding(1, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingTop(), this.getViewPortWidth()));
                        break;
                    }
                    case "paddingRight": {
                        this.setPadding(2, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingRight(), this.getViewPortWidth()));
                        break;
                    }
                    case "paddingBottom": {
                        this.setPadding(3, WXViewUtils.getRealPxByWidth(stylesMap.getPaddingBottom(), this.getViewPortWidth()));
                    }
                }
            }
        }
    }

    public int childCount() {
        return this.mDomChildren == null ? 0 : this.mDomChildren.size();
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public boolean isVisible() {
        return super.isShow();
    }

    public WXDomObject clone() {
        WXDomObject dom;
        block3: {
            if (this.sDestroy.get()) {
                return null;
            }
            dom = null;
            try {
                dom = WXDomObjectFactory.newInstance(this.mType);
                this.copyFields(dom);
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block3;
                WXLogUtils.e("WXDomObject clone error: ", e);
            }
        }
        return dom;
    }

    public void destroy() {
        this.sDestroy.set(true);
        if (this.mStyles != null) {
            this.mStyles.clear();
        }
        if (this.mAttributes != null) {
            this.mAttributes.clear();
        }
        if (this.mEvents != null) {
            this.mEvents.clear();
        }
        if (this.mDomChildren != null) {
            int count = this.mDomChildren.size();
            for (int i = 0; i < count; ++i) {
                this.mDomChildren.get(i).destroy();
            }
            this.mDomChildren.clear();
        }
        this.mDomContext = null;
    }

    protected Map<String, String> getDefaultStyle() {
        return null;
    }

    public ArrayList<String> getFixedStyleRefs() {
        return this.fixedStyleRefs;
    }

    public void add2FixedDomList(String ref) {
        if (this.fixedStyleRefs == null) {
            this.fixedStyleRefs = new ArrayList();
        }
        this.fixedStyleRefs.add(ref);
    }

    public String dumpDomTree() {
        return this.mRef + ": " + this.toString();
    }

    @Nullable
    public static WXDomObject parse(JSONObject json, WXSDKInstance wxsdkInstance) {
        if (json == null || json.size() <= 0) {
            return null;
        }
        String type = (String)json.get((Object)TYPE);
        WXDomObject domObject = WXDomObjectFactory.newInstance(type);
        domObject.setViewPortWidth(wxsdkInstance.getViewPortWidth());
        if (domObject == null) {
            return null;
        }
        domObject.parseFromJson(json);
        domObject.mDomContext = wxsdkInstance;
        Object children = json.get((Object)CHILDREN);
        if (children != null && children instanceof JSONArray) {
            JSONArray childrenArray = (JSONArray)children;
            int count = childrenArray.size();
            for (int i = 0; i < count; ++i) {
                domObject.add(WXDomObject.parse(childrenArray.getJSONObject(i), wxsdkInstance), -1);
            }
        }
        return domObject;
    }

    static interface Consumer {
        public void accept(WXDomObject var1);
    }
}

