/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.devtools.inspector.network;

import com.taobao.weex.devtools.inspector.network.DefaultResponseHandler;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporter;
import com.taobao.weex.devtools.inspector.network.NetworkEventReporterManager;
import com.taobao.weex.devtools.inspector.network.utils.RequestConverter;
import com.taobao.weex.devtools.inspector.network.utils.ResponseConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class GeneralEventReporter {
    private static GeneralEventReporter sInstance;
    private NetworkEventReporter mReporter = NetworkEventReporterManager.get();

    public static synchronized GeneralEventReporter getInstance() {
        if (sInstance == null) {
            sInstance = new GeneralEventReporter();
        }
        return sInstance;
    }

    private GeneralEventReporter() {
    }

    public void requestWillBeSent(Map<String, Object> request) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.requestWillBeSent(RequestConverter.convertFrom(request));
        }
    }

    public void responseHeadersReceived(Map<String, Object> response) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.responseHeadersReceived(ResponseConverter.convertFrom(response));
        }
    }

    public void httpExchangeFailed(String requestId, String errorInfo) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.httpExchangeFailed(requestId, errorInfo);
        }
    }

    public InputStream interpretResponseStream(String requestId, String contentType, String contentEncoding, InputStream stream, boolean continueRead) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            DefaultResponseHandler defaultHandler = new DefaultResponseHandler(this.mReporter, requestId);
            InputStream wrappedStream = this.mReporter.interpretResponseStream(requestId, contentType, contentEncoding, stream, defaultHandler);
            if (!continueRead) {
                try {
                    this.read(wrappedStream);
                    if (wrappedStream != null) {
                        wrappedStream.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (wrappedStream != null) {
                return wrappedStream;
            }
        }
        return stream;
    }

    public void responseReadFailed(String requestId, String errorInfo) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.responseReadFailed(requestId, errorInfo);
        }
    }

    public void responseReadFinished(String requestId) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.responseReadFinished(requestId);
        }
    }

    public void dataSent(String requestId, int dataLength, int encodedDataLength) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.dataSent(requestId, dataLength, encodedDataLength);
        }
    }

    public void dataReceived(String requestId, int dataLength, int encodedDataLength) {
        if (this.mReporter != null && this.mReporter.isEnabled()) {
            this.mReporter.dataReceived(requestId, dataLength, encodedDataLength);
        }
    }

    private byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        byte[] result = out.toByteArray();
        out.flush();
        out.close();
        return result;
    }
}

