/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view.highlight;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import com.taobao.weex.analyzer.view.highlight.ViewHighlightOverlays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ViewHighlighter {
    public static ViewHighlighter newInstance() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new OverlayHighlighter();
        }
        return new NoopHighlighter();
    }

    protected ViewHighlighter() {
    }

    public abstract void clearHighlight();

    public abstract void setHighlightedView(View var1, int var2);

    public abstract boolean hasHighlight(View var1);

    @TargetApi(value=18)
    private static final class OverlayHighlighter
    extends ViewHighlighter {
        private final Handler mHandler;
        private final ViewHighlightOverlays mHighlightOverlays = ViewHighlightOverlays.newInstance();
        private View mHighlightedView;
        private AtomicReference<View> mViewToHighlight = new AtomicReference();
        private AtomicInteger mContentColor = new AtomicInteger();
        private final Runnable mHighlightViewOnUiThreadRunnable = new Runnable(){

            @Override
            public void run() {
                OverlayHighlighter.this.highlightViewOnUiThread();
            }
        };

        public OverlayHighlighter() {
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void clearHighlight() {
            this.setHighlightedViewImpl(null, 0);
        }

        @Override
        public void setHighlightedView(View view, int color) {
            this.setHighlightedViewImpl(view, color);
        }

        @Override
        public boolean hasHighlight(View itemView) {
            return this.mHighlightedView != null && this.mHighlightedView.equals(itemView);
        }

        private void setHighlightedViewImpl(@Nullable View view, int color) {
            this.mHandler.removeCallbacks(this.mHighlightViewOnUiThreadRunnable);
            this.mViewToHighlight.set(view);
            this.mContentColor.set(color);
            this.mHandler.postDelayed(this.mHighlightViewOnUiThreadRunnable, 5L);
        }

        private void highlightViewOnUiThread() {
            View viewToHighlight = this.mViewToHighlight.getAndSet(null);
            if (viewToHighlight == this.mHighlightedView) {
                return;
            }
            if (this.mHighlightedView != null) {
                this.mHighlightOverlays.removeHighlight(this.mHighlightedView);
            }
            if (viewToHighlight != null) {
                this.mHighlightOverlays.highlightView(viewToHighlight, this.mContentColor.get());
            }
            this.mHighlightedView = viewToHighlight;
        }
    }

    private static final class NoopHighlighter
    extends ViewHighlighter {
        private NoopHighlighter() {
        }

        @Override
        public void clearHighlight() {
        }

        @Override
        public void setHighlightedView(View view, int color) {
        }

        @Override
        public boolean hasHighlight(View itemView) {
            return false;
        }
    }
}

