/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view.highlight;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

abstract class ViewHighlightOverlays {
    ViewHighlightOverlays() {
    }

    public abstract void highlightView(@NonNull View var1, int var2);

    public abstract void removeHighlight(@NonNull View var1);

    static ViewHighlightOverlays newInstance() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new ViewHighlightOverlaysJellybeanMR2();
        }
        return new NoOpViewHighlightOverlays();
    }

    @TargetApi(value=18)
    private static class ViewHighlightOverlaysJellybeanMR2
    extends ViewHighlightOverlays {
        private static final int MARGIN_OVERLAY_COLOR = -1426797922;
        private static final int PADDING_OVERLAY_COLOR = -1430332746;
        private final MainHighlightDrawable mMainHighlightDrawable = new MainHighlightDrawable();
        private final HighlightDrawable[] mHighlightDrawables = new HighlightDrawable[]{this.mMainHighlightDrawable};

        ViewHighlightOverlaysJellybeanMR2() {
        }

        @Override
        public void highlightView(@NonNull View view, int mainColor) {
            this.mMainHighlightDrawable.setColor(mainColor);
            for (HighlightDrawable drawable2 : this.mHighlightDrawables) {
                drawable2.highlightView(view);
                view.getOverlay().add((Drawable)drawable2);
            }
        }

        @Override
        public void removeHighlight(@NonNull View view) {
            for (HighlightDrawable drawable2 : this.mHighlightDrawables) {
                view.getOverlay().remove((Drawable)drawable2);
            }
        }

        static class MarginLeftHighlightDrawable
        extends HighlightDrawable {
            MarginLeftHighlightDrawable() {
                super(-1426797922);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(0, 0, this.mMargins.left, view.getHeight() + this.mMargins.top + this.mMargins.bottom);
            }

            public void draw(Canvas canvas) {
                canvas.translate((float)(-(this.mMargins.left + this.mMargins.right)), 0.0f);
                super.draw(canvas);
            }
        }

        static class MarginRightHighlightDrawable
        extends HighlightDrawable {
            MarginRightHighlightDrawable() {
                super(-1426797922);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(view.getWidth() - this.mMargins.right, 0, view.getWidth(), view.getHeight() + this.mMargins.top + this.mMargins.bottom);
            }

            public void draw(Canvas canvas) {
                canvas.translate((float)this.mMargins.right, (float)(-(this.mMargins.top + this.mMargins.bottom)));
                super.draw(canvas);
            }
        }

        static class MarginBottomHighlightDrawable
        extends HighlightDrawable {
            MarginBottomHighlightDrawable() {
                super(-1426797922);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(0, view.getHeight() - this.mMargins.bottom, view.getWidth(), view.getHeight());
            }

            public void draw(Canvas canvas) {
                canvas.translate(0.0f, (float)(this.mMargins.bottom + this.mMargins.top));
                super.draw(canvas);
            }
        }

        static class MarginTopHighlightDrawable
        extends HighlightDrawable {
            MarginTopHighlightDrawable() {
                super(-1426797922);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(0, 0, view.getWidth(), this.mMargins.top);
            }

            public void draw(Canvas canvas) {
                canvas.translate(0.0f, (float)(-this.mMargins.top));
                super.draw(canvas);
            }
        }

        static class PaddingLeftHighlightDrawable
        extends HighlightDrawable {
            PaddingLeftHighlightDrawable() {
                super(-1430332746);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(0, 0, this.mPaddings.left, view.getHeight());
            }
        }

        static class PaddingRightHighlightDrawable
        extends HighlightDrawable {
            PaddingRightHighlightDrawable() {
                super(-1430332746);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(view.getWidth() - this.mPaddings.right, 0, view.getWidth(), view.getHeight());
            }
        }

        static class PaddingBottomHighlightDrawable
        extends HighlightDrawable {
            PaddingBottomHighlightDrawable() {
                super(-1430332746);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(this.mPaddings.left, view.getHeight() - this.mPaddings.bottom, view.getWidth() - this.mPaddings.right, view.getHeight());
            }
        }

        static class PaddingTopHighlightDrawable
        extends HighlightDrawable {
            PaddingTopHighlightDrawable() {
                super(-1430332746);
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(this.mPaddings.left, 0, view.getWidth() - this.mPaddings.right, this.mPaddings.top);
            }
        }

        static class MainHighlightDrawable
        extends HighlightDrawable {
            MainHighlightDrawable() {
            }

            @Override
            public void highlightView(View view) {
                super.highlightView(view);
                this.setBounds(0, 0, view.getWidth(), view.getHeight());
            }

            public void draw(Canvas canvas) {
                Rect newRect = canvas.getClipBounds();
                newRect.inset(-(this.mMargins.right + this.mMargins.left), -(this.mMargins.top + this.mMargins.bottom));
                canvas.clipRect(newRect, Region.Op.REPLACE);
                super.draw(canvas);
            }
        }

        static abstract class HighlightDrawable
        extends ColorDrawable {
            final Rect mMargins = new Rect();
            final Rect mPaddings = new Rect();

            HighlightDrawable(int color) {
                super(color);
            }

            HighlightDrawable() {
            }

            protected void highlightView(View view) {
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                    this.mMargins.left = marginLayoutParams.leftMargin;
                    this.mMargins.top = marginLayoutParams.topMargin;
                    this.mMargins.right = marginLayoutParams.rightMargin;
                    this.mMargins.bottom = marginLayoutParams.bottomMargin;
                } else {
                    this.mMargins.left = 0;
                    this.mMargins.top = 0;
                    this.mMargins.right = 0;
                    this.mMargins.bottom = 0;
                }
                this.mPaddings.left = view.getPaddingLeft();
                this.mPaddings.top = view.getPaddingTop();
                this.mPaddings.right = view.getPaddingRight();
                this.mPaddings.bottom = view.getPaddingBottom();
            }
        }
    }

    private static class NoOpViewHighlightOverlays
    extends ViewHighlightOverlays {
        private NoOpViewHighlightOverlays() {
        }

        @Override
        public void highlightView(@NonNull View view, int mainColor) {
        }

        @Override
        public void removeHighlight(@NonNull View view) {
        }
    }
}

