/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view.highlight;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.View;
import com.taobao.weex.analyzer.view.highlight.ViewHighlightOverlays;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MutipleViewHighlighter {
    public static MutipleViewHighlighter newInstance() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new OverlayHighlighter();
        }
        return new NoOpHighlighter();
    }

    public abstract void clearHighlight();

    public abstract void addHighlightedView(View var1);

    public abstract void setColor(@ColorInt int var1);

    public boolean isSupport() {
        return Build.VERSION.SDK_INT >= 18;
    }

    @TargetApi(value=18)
    private static final class OverlayHighlighter
    extends MutipleViewHighlighter {
        private final Handler mHandler;
        private AtomicInteger mContentColor = new AtomicInteger();
        private CopyOnWriteArrayList<HighLightedView> mViewListToHighlight = new CopyOnWriteArrayList();

        OverlayHighlighter() {
            this.mHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void clearHighlight() {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    OverlayHighlighter.this.hideHighlightViewOnUiThread();
                }
            }, 0L);
        }

        @Override
        public void addHighlightedView(View view) {
            if (view == null) {
                return;
            }
            if (this.mViewListToHighlight != null && this.contains(view)) {
                return;
            }
            this.mHandler.removeCallbacksAndMessages(null);
            HighLightedView node = new HighLightedView();
            node.viewRef = new WeakReference<View>(view);
            node.highlightOverlays = ViewHighlightOverlays.newInstance();
            this.mViewListToHighlight.add(node);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    OverlayHighlighter.this.highlightViewOnUiThread();
                }
            }, 0L);
        }

        @Override
        public void setColor(@ColorInt int color) {
            this.mContentColor.set(color);
        }

        private boolean contains(@NonNull View view) {
            if (this.mViewListToHighlight == null || this.mViewListToHighlight.isEmpty()) {
                return false;
            }
            for (HighLightedView highLightedView : this.mViewListToHighlight) {
                if (highLightedView.viewRef == null || !view.equals(highLightedView.viewRef.get())) continue;
                return true;
            }
            return false;
        }

        private void highlightViewOnUiThread() {
            for (HighLightedView highLightedView : this.mViewListToHighlight) {
                if (highLightedView == null || highLightedView.highlightOverlays == null || highLightedView.viewRef == null || highLightedView.viewRef.get() == null) continue;
                highLightedView.highlightOverlays.removeHighlight((View)highLightedView.viewRef.get());
                highLightedView.highlightOverlays.highlightView((View)highLightedView.viewRef.get(), this.mContentColor.get());
            }
        }

        private void hideHighlightViewOnUiThread() {
            for (HighLightedView highLightedView : this.mViewListToHighlight) {
                if (highLightedView == null || highLightedView.highlightOverlays == null || highLightedView.viewRef == null || highLightedView.viewRef.get() == null) continue;
                highLightedView.highlightOverlays.removeHighlight((View)highLightedView.viewRef.get());
            }
        }
    }

    private static class HighLightedView {
        ViewHighlightOverlays highlightOverlays;
        WeakReference<View> viewRef;

        private HighLightedView() {
        }
    }

    private static final class NoOpHighlighter
    extends MutipleViewHighlighter {
        private NoOpHighlighter() {
        }

        @Override
        public void clearHighlight() {
        }

        @Override
        public void addHighlightedView(View view) {
        }

        @Override
        public void setColor(@ColorInt int color) {
        }
    }
}

