/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.ViewInspectorManager;
import com.taobao.weex.analyzer.view.AbstractBizItemView;
import com.taobao.weex.analyzer.view.CSSBoxModelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

public class WXInspectorItemView
extends AbstractBizItemView<ViewInspectorManager.InspectorInfo> {
    private TextView mContent;
    private CSSBoxModelView mBoxView;
    public static final String TYPE_VIRTUAL_DOM = "virtual_dom";
    public static final String TYPE_NATIVE_LAYOUT = "native_layout";
    private String mType;

    public WXInspectorItemView(Context context) {
        super(context);
    }

    public WXInspectorItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WXInspectorItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void prepareView() {
        this.mContent = (TextView)this.findViewById(R.id.content);
        this.mBoxView = (CSSBoxModelView)this.findViewById(R.id.box_model);
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_panel_inspector_view;
    }

    public void setType(String type) {
        this.mType = type;
    }

    @Override
    protected void inflateData(ViewInspectorManager.InspectorInfo data) {
        if (TYPE_VIRTUAL_DOM.equals(this.mType)) {
            this.mBoxView.setNative(false);
            this.applyInspectorInfoToBoxView(data.virtualViewInfo, this.mBoxView);
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : data.virtualViewInfo.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getValue()) || "0".equals(entry.getValue())) continue;
                builder.append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
            }
            this.mContent.setText((CharSequence)builder.toString());
        } else if (TYPE_NATIVE_LAYOUT.equals(this.mType)) {
            this.mBoxView.setNative(true);
            this.applyInspectorInfoToBoxView(data.nativeViewInfo, this.mBoxView);
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : data.nativeViewInfo.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getValue()) || "0".equals(entry.getValue())) continue;
                builder.append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
            }
            this.mContent.setText((CharSequence)builder.toString());
        }
    }

    @VisibleForTesting
    static String getPureValue(@Nullable String rawValue) {
        if (rawValue == null || "".equals(rawValue.trim())) {
            return "0";
        }
        String digits = rawValue.replaceAll("[^0-9.-]", "");
        int dotIndex = digits.indexOf(46);
        int len = digits.length();
        if (dotIndex >= 0) {
            if (len - 1 > dotIndex) {
                try {
                    double d = Double.valueOf(digits);
                    d = Math.round(d);
                    return String.valueOf((int)d);
                }
                catch (Exception e) {
                    return digits.substring(0, dotIndex);
                }
            }
            return digits.substring(0, dotIndex);
        }
        return digits;
    }

    private void applyInspectorInfoToBoxView(@NonNull Map<String, String> inspectorInfo, @NonNull CSSBoxModelView boxView) {
        if (!TextUtils.isEmpty((CharSequence)inspectorInfo.get("margin"))) {
            String margin = inspectorInfo.get("margin");
            margin = WXInspectorItemView.getPureValue(margin);
            boxView.setMarginLeftText(margin);
            boxView.setMarginRightText(margin);
            boxView.setMarginTopText(margin);
            boxView.setMarginBottomText(margin);
        } else {
            boxView.setMarginLeftText(WXInspectorItemView.getPureValue(inspectorInfo.get("marginLeft")));
            boxView.setMarginRightText(WXInspectorItemView.getPureValue(inspectorInfo.get("marginRight")));
            boxView.setMarginTopText(WXInspectorItemView.getPureValue(inspectorInfo.get("marginTop")));
            boxView.setMarginBottomText(WXInspectorItemView.getPureValue(inspectorInfo.get("marginBottom")));
        }
        if (!TextUtils.isEmpty((CharSequence)inspectorInfo.get("borderWidth"))) {
            String border = inspectorInfo.get("borderWidth");
            border = WXInspectorItemView.getPureValue(border);
            boxView.setBorderLeftText(border);
            boxView.setBorderRightText(border);
            boxView.setBorderTopText(border);
            boxView.setBorderBottomText(border);
        } else {
            boxView.setBorderLeftText(WXInspectorItemView.getPureValue(inspectorInfo.get("borderLeftWidth")));
            boxView.setBorderRightText(WXInspectorItemView.getPureValue(inspectorInfo.get("borderRightWidth")));
            boxView.setBorderTopText(WXInspectorItemView.getPureValue(inspectorInfo.get("borderTopWidth")));
            boxView.setBorderBottomText(WXInspectorItemView.getPureValue(inspectorInfo.get("borderBottomWidth")));
        }
        if (!TextUtils.isEmpty((CharSequence)inspectorInfo.get("padding"))) {
            String padding = inspectorInfo.get("padding");
            padding = WXInspectorItemView.getPureValue(padding);
            boxView.setPaddingLeftText(padding);
            boxView.setPaddingRightText(padding);
            boxView.setPaddingTopText(padding);
            boxView.setPaddingBottomText(padding);
        } else {
            boxView.setPaddingLeftText(WXInspectorItemView.getPureValue(inspectorInfo.get("paddingLeft")));
            boxView.setPaddingRightText(WXInspectorItemView.getPureValue(inspectorInfo.get("paddingRight")));
            boxView.setPaddingTopText(WXInspectorItemView.getPureValue(inspectorInfo.get("paddingTop")));
            boxView.setPaddingBottomText(WXInspectorItemView.getPureValue(inspectorInfo.get("paddingBottom")));
        }
        boxView.setWidthText(WXInspectorItemView.getPureValue(inspectorInfo.get("width")));
        boxView.setHeightText(WXInspectorItemView.getPureValue(inspectorInfo.get("height")));
        boxView.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

