/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.DomTracker;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.ReportSupportLoopTask;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.highlight.MutipleViewHighlighter;
import com.taobao.weex.ui.component.WXComponent;

public class ProfileDomView
extends DragSupportOverlayView {
    private SampleTask mTask;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public ProfileDomView(Context application) {
        super(application);
        this.mWidth = -1;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        View hostView = View.inflate((Context)this.mContext, (int)R.layout.wxt_depth_sample_view, null);
        View closeBtn = hostView.findViewById(R.id.close);
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ProfileDomView.this.isViewAttached && ProfileDomView.this.mOnCloseListener != null) {
                    ProfileDomView.this.mOnCloseListener.close(ProfileDomView.this);
                    ProfileDomView.this.dismiss();
                }
            }
        });
        return hostView;
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new SampleTask(this.mWholeView);
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
    }

    public void bindInstance(WXSDKInstance instance) {
        if (this.mTask != null) {
            this.mTask.setInstance(instance);
        }
    }

    private static class SampleTask
    extends ReportSupportLoopTask<HealthReport>
    implements DomTracker.OnTrackNodeListener {
        WXSDKInstance instance;
        TextView resultTextView;
        MutipleViewHighlighter mViewHighlighter;
        static final int MAX_VDOM_LAYER = 14;
        static final int MAX_REAL_DOM_LAYER = 20;

        SampleTask(@NonNull View hostView) {
            super(false);
            this.mDelayMillis = 1000;
            this.resultTextView = (TextView)hostView.findViewById(R.id.result);
            this.mViewHighlighter = MutipleViewHighlighter.newInstance();
            this.mViewHighlighter.setColor(Color.parseColor((String)"#420000ff"));
        }

        void setInstance(WXSDKInstance instance) {
            this.instance = instance;
        }

        private String convertResult(boolean result) {
            return result ? "\u2713 " : "\u2715 ";
        }

        @Override
        protected void onRun() {
            if (this.instance == null) {
                return;
            }
            DomTracker tracker = new DomTracker(this.instance);
            tracker.setOnTrackNodeListener(this);
            HealthReport report = tracker.traverse();
            if (report == null) {
                return;
            }
            final StringBuilder builder = new StringBuilder();
            this.reportIfNeeded(new IDataReporter.ProcessedDataBuilder().sequenceId(this.generateSequenceId()).deviceId(LaunchConfig.getDeviceId()).type("render_analysis").data(report).build());
            builder.append(this.convertResult(report.maxLayerOfRealDom < 20)).append("\u68c0\u6d4b\u5230native\u6700\u6df1\u5d4c\u5957\u5c42\u7ea7\u4e3a ").append(report.maxLayerOfRealDom).append("(\u4ec5\u7edf\u8ba1weex\u81ea\u8eab\u6e32\u67d3\u51fa\u6765\u7684\u5c42\u7ea7)").append("\n");
            boolean deepLayer = report.maxLayer >= 14;
            builder.append(this.convertResult(!deepLayer));
            builder.append("\u68c0\u6d4b\u5230VDOM\u6700\u6df1\u5d4c\u5957\u5c42\u7ea7\u4e3a ").append(report.maxLayer).append(",\u5efa\u8bae<14");
            if (deepLayer && this.mViewHighlighter != null && this.mViewHighlighter.isSupport()) {
                builder.append(",\u6df1\u5c42\u5d4c\u5957\u5df2\u9ad8\u4eae\u900f\u51fa");
            }
            builder.append("\n");
            if (report.hasScroller) {
                builder.append(this.convertResult(true));
                builder.append("\u68c0\u6d4b\u5230\u8be5\u9875\u9762\u4f7f\u7528\u4e86\u7eb5\u5411\u7684Scroller,\u957f\u5217\u8868\u5efa\u8bae\u4f7f\u7528ListView").append("\n");
            }
            if (report.hasList && report.listDescMap != null) {
                int listNum = report.listDescMap.size();
                builder.append(this.convertResult(true));
                builder.append("\u68c0\u6d4b\u5230\u8be5\u9875\u9762\u4f7f\u7528\u4e86List,\u5171").append(listNum).append("\u4e2a").append("\n");
                for (HealthReport.ListDesc listDesc : report.listDescMap.values()) {
                    builder.append(this.convertResult(true)).append("\u68c0\u6d4b\u5230ref\u4e3a'").append(listDesc.ref).append("'\u7684list,\u5176cell\u4e2a\u6570\u4e3a").append(listDesc.cellNum).append(",\u9884\u4f30\u9ad8\u5ea6\u4e3a").append(listDesc.totalHeight).append("px\n");
                }
                builder.append(this.convertResult(!report.hasBigCell));
                if (report.hasBigCell) {
                    builder.append("\u68c0\u6d4b\u5230\u9875\u9762\u53ef\u80fd\u5b58\u5728\u5927cell,\u6700\u5927\u7684cell\u4e2d\u5305\u542b").append(report.componentNumOfBigCell).append("\u4e2a\u7ec4\u4ef6,\u5efa\u8bae\u6309\u884c\u5408\u7406\u62c6\u5206").append("\n");
                } else {
                    builder.append("\u7ecf\u68c0\u6d4b\uff0ccell\u5927\u5c0f\u5408\u7406").append("\n");
                }
            }
            if (report.hasEmbed) {
                int embedNum = report.embedDescList.size();
                builder.append(this.convertResult(true));
                builder.append("\u68c0\u6d4b\u5230\u8be5\u9875\u9762\u4f7f\u7528\u4e86Embed\u6807\u7b7e").append(",").append("\u8be5\u6807\u7b7e\u6570\u76ee\u4e3a").append(embedNum).append("\n");
                for (int i = 0; i < embedNum; ++i) {
                    HealthReport.EmbedDesc embedDesc = report.embedDescList.get(i);
                    boolean isEmbedDeep = embedDesc.actualMaxLayer >= 14;
                    builder.append(this.convertResult(!isEmbedDeep)).append("\u7b2c").append(i + 1).append("\u4e2aembed\u6807\u7b7e\u5730\u5740\u4e3a").append(embedDesc.src).append(",\u5185\u5bb9\u6700\u6df1\u5d4c\u5957\u5c42\u7ea7\u4e3a").append(embedDesc.actualMaxLayer).append("\n");
                }
            }
            builder.append(this.convertResult(true)).append("\u68c0\u6d4b\u5230\u5f53\u524d\u5185\u5bb9\u9ad8\u5ea6\u7ea6\u4e3a").append(report.estimateContentHeight).append("px,\u7ea6\u7b49\u4e8e").append(report.estimatePages).append("\u5c4f").append("\n");
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    SampleTask.this.resultTextView.setText((CharSequence)builder.toString());
                }
            });
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.instance = null;
            if (this.mViewHighlighter != null) {
                this.mViewHighlighter.clearHighlight();
            }
        }

        @Override
        public void onTrackNode(@NonNull WXComponent component, int layer) {
            if (layer < 14) {
                return;
            }
            View hostView = component.getHostView();
            if (hostView == null) {
                return;
            }
            if (this.mViewHighlighter != null) {
                this.mViewHighlighter.addHighlightedView(hostView);
            }
        }
    }
}

