/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.ViewInspectorManager;
import com.taobao.weex.analyzer.core.ViewPropertiesSupplier;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.MDSDataReporterFactory;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.WXInspectorItemView;
import com.taobao.weex.analyzer.view.highlight.ViewHighlighter;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class InspectorView
extends DragSupportOverlayView {
    private ViewHighlighter mViewHighlighter;
    private GestureDetector mGestureDetector;
    private ViewInspectorManager mInspectorManager;
    private IOverlayView.OnCloseListener mOnCloseListener;
    private static final int INSPECTOR_COLOR = 1107296511;
    private WXInspectorItemView mVirtualInspectorItemView;
    private WXInspectorItemView mNativeInspectorItemView;
    private TextView virtualDomBtn;
    private TextView nativeLayoutBtn;
    private View closeBtn;
    private TextView mTips;
    private static final int BTN_ENABLED_COLOR = -1127359431;
    private static final int BTN_DISABLED_COLOR = 0xFFFFFF;
    @Nullable
    private IDataReporter<ViewInspectorManager.InspectorInfo> mDataReporter;
    private AtomicInteger mCounter = new AtomicInteger(0);

    public InspectorView(Context application) {
        super(application);
        this.mWidth = -1;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        View hostView = View.inflate((Context)this.mContext, (int)R.layout.wxt_inspector_view, null);
        this.mVirtualInspectorItemView = (WXInspectorItemView)hostView.findViewById(R.id.panel_virtual_dom);
        this.mVirtualInspectorItemView.setType("virtual_dom");
        this.mNativeInspectorItemView = (WXInspectorItemView)hostView.findViewById(R.id.panel_native_layout);
        this.mNativeInspectorItemView.setType("native_layout");
        this.virtualDomBtn = (TextView)hostView.findViewById(R.id.btn_panel_virtual_dom);
        this.nativeLayoutBtn = (TextView)hostView.findViewById(R.id.btn_panel_native_layout);
        this.closeBtn = hostView.findViewById(R.id.close);
        this.mTips = (TextView)hostView.findViewById(R.id.tips);
        this.virtualDomBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InspectorView.this.mVirtualInspectorItemView.setVisibility(0);
                InspectorView.this.mNativeInspectorItemView.setVisibility(8);
                InspectorView.this.virtualDomBtn.setBackgroundColor(-1127359431);
                InspectorView.this.nativeLayoutBtn.setBackgroundColor(0xFFFFFF);
            }
        });
        this.nativeLayoutBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InspectorView.this.mVirtualInspectorItemView.setVisibility(8);
                InspectorView.this.mNativeInspectorItemView.setVisibility(0);
                InspectorView.this.nativeLayoutBtn.setBackgroundColor(-1127359431);
                InspectorView.this.virtualDomBtn.setBackgroundColor(0xFFFFFF);
            }
        });
        this.closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (InspectorView.this.isViewAttached && InspectorView.this.mOnCloseListener != null) {
                    InspectorView.this.mOnCloseListener.close(InspectorView.this);
                    InspectorView.this.dismiss();
                }
            }
        });
        String from = LaunchConfig.getFrom();
        String deviceId = LaunchConfig.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)from) && !TextUtils.isEmpty((CharSequence)deviceId)) {
            this.mDataReporter = MDSDataReporterFactory.create(from, deviceId);
        }
        return hostView;
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public void bindInstance(@Nullable WXSDKInstance instance) {
        if (this.mInspectorManager != null) {
            this.mInspectorManager.setInstance(instance);
        }
    }

    public void receiveTouchEvent(@NonNull MotionEvent event) {
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetector(this.mContext, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public void onLongPress(MotionEvent e) {
                }

                public void onShowPress(MotionEvent e) {
                    if (InspectorView.this.mInspectorManager != null) {
                        InspectorView.this.mInspectorManager.inspectByMotionEvent(e);
                    }
                }
            });
        }
        this.mGestureDetector.onTouchEvent(event);
    }

    @Override
    protected void onShown() {
        this.mInspectorManager = ViewInspectorManager.newInstance(Executors.newSingleThreadExecutor(), new ViewPropertiesSupplier(), new ViewInspectorManager.OnInspectorListener(){

            @Override
            public void onInspectorSuccess(@NonNull ViewInspectorManager.InspectorInfo info) {
                InspectorView.this.notifyOnInspectorSuccess(info);
                if (InspectorView.this.mDataReporter != null && InspectorView.this.mDataReporter.isEnabled()) {
                    InspectorView.this.mDataReporter.report(new IDataReporter.ProcessedDataBuilder().sequenceId(InspectorView.this.mCounter.getAndIncrement()).data(info).deviceId(LaunchConfig.getDeviceId()).type("view_inspector").build());
                }
            }

            @Override
            public void onInspectorFailed(@NonNull String msg) {
            }
        });
    }

    private void notifyOnInspectorSuccess(@NonNull ViewInspectorManager.InspectorInfo info) {
        if (info.targetView == null || this.mWholeView == null) {
            return;
        }
        if (this.mViewHighlighter == null) {
            this.mViewHighlighter = ViewHighlighter.newInstance();
        }
        this.mViewHighlighter.setHighlightedView(info.targetView, 1107296511);
        if (info.targetComponent != null) {
            String tips = ViewUtils.getComponentName(info.targetComponent);
            this.mTips.setText((CharSequence)("tips:\u4f60\u9009\u4e2d\u4e86weex\u5143\u7d20[" + tips + "]"));
        } else if (this.mContext != null && info.targetView != null) {
            this.mTips.setText((CharSequence)("tips:\u4f60\u9009\u4e2d\u4e86native\u5143\u7d20[" + info.targetView.getClass().getSimpleName() + "]"));
        }
        if (info.virtualViewInfo != null) {
            this.mVirtualInspectorItemView.inflateData(info);
        }
        if (info.nativeViewInfo != null) {
            this.mNativeInspectorItemView.inflateData(info);
        }
    }

    @Override
    protected void onDismiss() {
        this.mGestureDetector = null;
        this.mCounter.set(0);
        if (this.mInspectorManager != null) {
            this.mInspectorManager.destroy();
            this.mInspectorManager = null;
        }
        if (this.mViewHighlighter != null) {
            this.mViewHighlighter.clearHighlight();
        }
        this.mViewHighlighter = null;
    }
}

