/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.FpsTaskEntity;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.ReportSupportLoopTask;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.DynamicChartViewController;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.chart.TimestampLabelFormatter;

public class FpsSampleView
extends DragSupportOverlayView {
    private SampleFPSTask mTask;
    private DynamicChartViewController mChartViewController;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public FpsSampleView(Context application) {
        super(application);
        this.mWidth = -1;
        this.mHeight = (int)ViewUtils.dp2px(application, 150);
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        int expectFPS = 60;
        this.mChartViewController = new DynamicChartViewController.Builder(this.mContext).title(this.mContext.getResources().getString(R.string.wxt_fps)).titleOfAxisX(null).titleOfAxisY("fps").labelColor(-1).backgroundColor(Color.parseColor((String)"#ba000000")).lineColor(Color.parseColor((String)"#BACDDC39")).isFill(true).fillColor(Color.parseColor((String)"#BACDDC39")).numXLabels(5).minX(0.0).maxX(20.0).numYLabels(5).minY(0.0).maxY(expectFPS).labelFormatter(new TimestampLabelFormatter()).maxDataPoints(22).build();
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        View chartView = this.mChartViewController.getChartView();
        frameLayout.addView(chartView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView closeBtn = new TextView(this.mContext);
        closeBtn.setTextColor(-1);
        closeBtn.setText((CharSequence)this.mContext.getResources().getString(R.string.wxt_close));
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FpsSampleView.this.mOnCloseListener != null && FpsSampleView.this.isViewAttached) {
                    FpsSampleView.this.mOnCloseListener.close(FpsSampleView.this);
                    FpsSampleView.this.dismiss();
                }
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)ViewUtils.dp2px(this.mContext, 50), (int)ViewUtils.dp2px(this.mContext, 30));
        params.gravity = 5;
        frameLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new SampleFPSTask(this.mChartViewController, SDKUtils.isDebugMode(this.mContext));
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
    }

    private static class SampleFPSTask
    extends ReportSupportLoopTask<Double> {
        private DynamicChartViewController mController;
        private int mAxisXValue = -1;
        private boolean isDebug;
        private FpsTaskEntity mEntity;

        SampleFPSTask(@NonNull DynamicChartViewController controller, boolean isDebug) {
            super(false, 1000);
            this.mController = controller;
            this.isDebug = isDebug;
            this.mEntity = new FpsTaskEntity();
        }

        @Override
        protected void onStart() {
            super.onStart();
            this.mEntity.onTaskInit();
        }

        @Override
        protected void onRun() {
            if (this.mController == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                ++this.mAxisXValue;
                final double fps = this.mEntity.onTaskRun();
                if (this.isDebug) {
                    Log.d((String)"weex-analyzer", (String)("current fps : " + fps));
                }
                this.reportIfNeeded(new IDataReporter.ProcessedDataBuilder().sequenceId(this.generateSequenceId()).deviceId(LaunchConfig.getDeviceId()).type("fps").data((double)Math.round(fps * 100.0) / 100.0).build());
                this.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SampleFPSTask.this.mController.appendPointAndInvalidate(SampleFPSTask.this.mAxisXValue, fps);
                    }
                });
            }
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.mController = null;
            this.mEntity.onTaskStop();
        }
    }
}

