/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.taobao.weex.analyzer.view.AbstractOverlayView;

public abstract class DragSupportOverlayView
extends AbstractOverlayView
implements View.OnTouchListener {
    private int mCurrentX = 0;
    private int mCurrentY = 0;
    private float mDx;
    private float mDy;
    private float downX;
    private float downY;
    private static boolean hasMoved = false;
    private boolean isDragEnabled = true;

    public DragSupportOverlayView(Context application) {
        super(application);
    }

    public DragSupportOverlayView(Context application, boolean enableDrag) {
        this(application);
        this.isDragEnabled = enableDrag;
    }

    @Override
    protected void onViewCreated(@NonNull View hostView) {
        super.onViewCreated(hostView);
        this.mCurrentX = this.mX;
        this.mCurrentY = this.mY;
        this.mWholeView.setOnTouchListener((View.OnTouchListener)this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.isDragEnabled) {
            return false;
        }
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mDx = (float)this.mCurrentX - event.getRawX();
                this.mDy = (float)this.mCurrentY - event.getRawY();
                this.downX = event.getX();
                this.downY = event.getY();
                hasMoved = false;
                break;
            }
            case 2: {
                this.mCurrentX = (int)(event.getRawX() + this.mDx);
                this.mCurrentY = (int)(event.getRawY() + this.mDy);
                if (!DragSupportOverlayView.isValidMove(this.mContext, event.getX() - this.downX) && !DragSupportOverlayView.isValidMove(this.mContext, event.getY() - this.downY)) break;
                this.updateViewPosition(this.mCurrentX, this.mCurrentY);
                hasMoved = true;
            }
        }
        return false;
    }

    private static boolean isValidMove(Context context, float distance) {
        return hasMoved || (float)ViewConfiguration.get((Context)context).getScaledTouchSlop() < Math.abs(distance);
    }

    protected void updateViewPosition(int x, int y) {
        if (this.mWholeView == null || this.mWindowManager == null) {
            return;
        }
        WindowManager.LayoutParams newParams = (WindowManager.LayoutParams)this.mWholeView.getLayoutParams();
        newParams.x = x;
        newParams.y = y;
        this.mWindowManager.updateViewLayout(this.mWholeView, (ViewGroup.LayoutParams)newParams);
        this.mCurrentX = x;
        this.mCurrentY = y;
    }

    public void setDragEnabled(boolean enabled) {
        this.isDragEnabled = enabled;
    }
}

