/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.CpuTaskEntity;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.ReportSupportLoopTask;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.DynamicChartViewController;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.chart.TimestampLabelFormatter;

public class CpuSampleView
extends DragSupportOverlayView {
    private SampleCpuTask mSampleCpuTask;
    private DynamicChartViewController mChartViewController;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public CpuSampleView(Context application) {
        super(application);
        this.mWidth = -1;
        this.mHeight = (int)ViewUtils.dp2px(application, 150);
    }

    @Override
    @NonNull
    protected View onCreateView() {
        int expectMaxCpuUsage = 40;
        this.mChartViewController = new DynamicChartViewController.Builder(this.mContext).title(this.mContext.getResources().getString(R.string.wxt_cpu)).titleOfAxisX(null).titleOfAxisY("cpu(%)").labelColor(-1).backgroundColor(Color.parseColor((String)"#ba000000")).lineColor(Color.parseColor((String)"#BACDDC39")).isFill(true).fillColor(Color.parseColor((String)"#BACDDC39")).numXLabels(5).minX(0.0).maxX(20.0).numYLabels(5).minY(0.0).maxY(expectMaxCpuUsage).labelFormatter(new TimestampLabelFormatter()).maxDataPoints(22).build();
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        View chartView = this.mChartViewController.getChartView();
        frameLayout.addView(chartView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView closeBtn = new TextView(this.mContext);
        closeBtn.setTextColor(-1);
        closeBtn.setText((CharSequence)this.mContext.getResources().getString(R.string.wxt_close));
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CpuSampleView.this.mOnCloseListener != null && CpuSampleView.this.isViewAttached) {
                    CpuSampleView.this.mOnCloseListener.close(CpuSampleView.this);
                    CpuSampleView.this.dismiss();
                }
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)ViewUtils.dp2px(this.mContext, 50), (int)ViewUtils.dp2px(this.mContext, 30));
        params.gravity = 5;
        frameLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    @Override
    protected void onShown() {
        if (this.mSampleCpuTask != null) {
            this.mSampleCpuTask.stop();
            this.mSampleCpuTask = null;
        }
        this.mSampleCpuTask = new SampleCpuTask(this.mChartViewController, SDKUtils.isDebugMode(this.mContext));
        this.mSampleCpuTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mSampleCpuTask != null) {
            this.mSampleCpuTask.stop();
            this.mSampleCpuTask = null;
        }
    }

    private static class SampleCpuTask
    extends ReportSupportLoopTask<Double> {
        private int mAxisXValue = -1;
        private DynamicChartViewController mController;
        private boolean isDebug = false;
        private static final float LOAD_FACTOR = 0.75f;
        private CpuTaskEntity mEntity;

        SampleCpuTask(DynamicChartViewController controller, boolean isDebug) {
            super(false, 1000);
            this.mController = controller;
            this.isDebug = isDebug;
            this.mEntity = new CpuTaskEntity();
        }

        @Override
        protected void onStart() {
            this.mEntity.onTaskInit();
        }

        @Override
        protected void onRun() {
            CpuTaskEntity.CpuInfo cpuInfo = this.mEntity.onTaskRun();
            final double pidCpuUsage = cpuInfo.pidCpuUsage;
            double pidUserCpuUsage = cpuInfo.pidUserCpuUsage;
            double pidKernelCpuUsage = cpuInfo.pidKernelCpuUsage;
            if (this.isDebug) {
                Log.d((String)"weex-analyzer", (String)("cpu usage:" + pidCpuUsage + "% [user " + pidUserCpuUsage + ",kernel " + pidKernelCpuUsage + "]"));
            }
            this.reportIfNeeded(new IDataReporter.ProcessedDataBuilder().sequenceId(this.generateSequenceId()).deviceId(LaunchConfig.getDeviceId()).type("cpu").data((double)Math.round(pidCpuUsage * 100.0) / 100.0).build());
            ++this.mAxisXValue;
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (SampleCpuTask.this.checkIfNeedUpdateYAxis(pidCpuUsage)) {
                        SampleCpuTask.this.mController.updateAxisY(SampleCpuTask.this.mController.getMinY(), Math.max(100.0, SampleCpuTask.this.mController.getMaxY() - SampleCpuTask.this.mController.getMinY() + 10.0), 0);
                    }
                    SampleCpuTask.this.mController.appendPointAndInvalidate(SampleCpuTask.this.mAxisXValue, pidCpuUsage);
                }
            });
        }

        private boolean checkIfNeedUpdateYAxis(double cpuUsage) {
            double currentMaxY = this.mController.getMaxY() - this.mController.getMinY();
            return currentMaxY * 0.75 <= cpuUsage;
        }

        @Override
        protected void onStop() {
            super.onStop();
            this.mEntity.onTaskStop();
        }
    }
}

