/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.taobao.weex.analyzer.utils.ViewUtils;

public class CSSBoxModelView
extends View {
    private static final int COLOR_MARGIN = -1157968738;
    private static final int COLOR_BORDER = -1157833573;
    private static final int COLOR_PADDING = -1161572726;
    private static final int COLOR_CONTENT = -1173178687;
    private static final int COLOR_TEXT = -1;
    private static final String TEXT_MARGIN = "margin";
    private static final String TEXT_BORDER = "border";
    private static final String TEXT_PADDING = "padding";
    private static final String TEXT_UNKNOWN = "?";
    private static final String TEXT_ZERO = "0";
    private static final String TEXT_NULL = "-";
    private final float DEFAULT_VIEW_HEIGHT = ViewUtils.dp2px(this.getContext(), 160);
    private final float DEFAULT_VIEW_WIDTH = ViewUtils.dp2px(this.getContext(), 200);
    private final float DEFAULT_BOX_GAP = ViewUtils.dp2px(this.getContext(), 45);
    private float mViewMinWidth = this.DEFAULT_VIEW_WIDTH;
    private float mViewMinHeight = this.DEFAULT_VIEW_HEIGHT;
    private Paint mShapePaint;
    private Paint mTextPaint;
    private RectF mOuterBounds;
    private RectF mBorderBounds;
    private RectF mPaddingBounds;
    private RectF mContentBounds;
    private float mTextOffsetX;
    private float mTextOffsetY;
    private PathEffect mPathEffect;
    private Rect mCachedTextBounds;
    private String mMarginLeftText;
    private String mMarginTopText;
    private String mMarginRightText;
    private String mMarginBottomText;
    private String mPaddingLeftText;
    private String mPaddingTopText;
    private String mPaddingRightText;
    private String mPaddingBottomText;
    private String mBorderLeftText;
    private String mBorderTopText;
    private String mBorderRightText;
    private String mBorderBottomText;
    private String mWidthText;
    private String mHeightText;
    private boolean isNative = false;

    public CSSBoxModelView(Context context) {
        super(context);
        this.init();
    }

    public CSSBoxModelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CSSBoxModelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mShapePaint = new Paint(1);
        this.mShapePaint.setStrokeWidth(ViewUtils.dp2px(this.getContext(), 1));
        this.mShapePaint.setDither(true);
        this.mShapePaint.setColor(-1);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setDither(true);
        this.mTextPaint.setTextSize(ViewUtils.sp2px(this.getContext(), 12));
        this.mTextPaint.setColor(-1);
        this.mTextPaint.setTypeface(Typeface.DEFAULT);
        Paint.FontMetrics metrics = this.mTextPaint.getFontMetrics();
        this.mTextOffsetY = -(metrics.descent + metrics.ascent) / 2.0f;
        this.mTextOffsetX = (metrics.descent - metrics.ascent) / 2.0f;
        this.mCachedTextBounds = new Rect();
        this.mViewMinWidth = this.DEFAULT_VIEW_WIDTH;
        this.mViewMinHeight = this.DEFAULT_VIEW_HEIGHT;
        this.mPathEffect = new DashPathEffect(new float[]{5.0f, 5.0f, 5.0f, 5.0f}, 1.0f);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float width = Math.max((float)this.getWidth(), this.mViewMinWidth);
        float height = Math.max((float)this.getHeight(), this.mViewMinHeight);
        this.mOuterBounds = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + width, (float)this.getPaddingTop() + height);
        this.mBorderBounds = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + width - this.DEFAULT_BOX_GAP, (float)this.getPaddingTop() + 3.0f * height / 4.0f);
        this.mPaddingBounds = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + width - this.DEFAULT_BOX_GAP * 2.0f, (float)this.getPaddingTop() + height / 2.0f);
        this.mContentBounds = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + width - this.DEFAULT_BOX_GAP * 3.0f, (float)this.getPaddingTop() + height / 4.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = (int)(this.mViewMinWidth + (float)this.getPaddingLeft() + (float)this.getPaddingRight());
        int height = (int)(this.mViewMinHeight + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(this.getResolvedSize(width, widthMeasureSpec), this.getResolvedSize(height, heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        this.mShapePaint.setStyle(Paint.Style.FILL);
        canvas.save();
        this.mShapePaint.setColor(-1157968738);
        canvas.clipRect((this.mOuterBounds.width() - this.mBorderBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mBorderBounds.height()) / 2.0f, (this.mOuterBounds.width() + this.mBorderBounds.width()) / 2.0f, (this.mOuterBounds.height() + this.mBorderBounds.height()) / 2.0f, Region.Op.DIFFERENCE);
        canvas.drawRect(this.mOuterBounds, this.mShapePaint);
        canvas.restore();
        canvas.save();
        canvas.translate((this.mOuterBounds.width() - this.mBorderBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mBorderBounds.height()) / 2.0f);
        this.mShapePaint.setColor(-1157833573);
        canvas.clipRect((this.mBorderBounds.width() - this.mPaddingBounds.width()) / 2.0f, (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 2.0f, (this.mBorderBounds.width() + this.mPaddingBounds.width()) / 2.0f, (this.mBorderBounds.height() + this.mPaddingBounds.height()) / 2.0f, Region.Op.DIFFERENCE);
        canvas.drawRect(this.mBorderBounds, this.mShapePaint);
        canvas.restore();
        canvas.save();
        canvas.translate((this.mOuterBounds.width() - this.mPaddingBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mPaddingBounds.height()) / 2.0f);
        this.mShapePaint.setColor(-1161572726);
        canvas.clipRect((this.mPaddingBounds.width() - this.mContentBounds.width()) / 2.0f, (this.mPaddingBounds.height() - this.mContentBounds.height()) / 2.0f, (this.mPaddingBounds.width() + this.mContentBounds.width()) / 2.0f, (this.mPaddingBounds.height() + this.mContentBounds.height()) / 2.0f, Region.Op.DIFFERENCE);
        canvas.drawRect(this.mPaddingBounds, this.mShapePaint);
        canvas.restore();
        canvas.save();
        canvas.translate((this.mOuterBounds.width() - this.mContentBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mContentBounds.height()) / 2.0f);
        this.mShapePaint.setColor(-1173178687);
        canvas.drawRect(this.mContentBounds, this.mShapePaint);
        canvas.restore();
        this.mShapePaint.setColor(-1);
        this.mShapePaint.setStyle(Paint.Style.STROKE);
        this.mShapePaint.setPathEffect(this.mPathEffect);
        canvas.save();
        canvas.drawRect(this.mOuterBounds, this.mShapePaint);
        canvas.translate((this.mOuterBounds.width() - this.mBorderBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mBorderBounds.height()) / 2.0f);
        this.mShapePaint.setPathEffect(null);
        canvas.drawRect(this.mBorderBounds, this.mShapePaint);
        canvas.translate((this.mBorderBounds.width() - this.mPaddingBounds.width()) / 2.0f, (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 2.0f);
        this.mShapePaint.setPathEffect(this.mPathEffect);
        canvas.drawRect(this.mPaddingBounds, this.mShapePaint);
        canvas.translate((this.mPaddingBounds.width() - this.mContentBounds.width()) / 2.0f, (this.mPaddingBounds.height() - this.mContentBounds.height()) / 2.0f);
        this.mShapePaint.setPathEffect(null);
        canvas.drawRect(this.mContentBounds, this.mShapePaint);
        canvas.restore();
        canvas.save();
        canvas.drawText(TEXT_MARGIN, this.mTextOffsetX + this.mOuterBounds.left, (this.mOuterBounds.height() - this.mBorderBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        String tempText = this.prepareText(this.mMarginLeftText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mOuterBounds.left + (this.mOuterBounds.width() - this.mBorderBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mOuterBounds.top + this.mOuterBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mMarginTopText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mOuterBounds.left + this.mOuterBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mOuterBounds.top + (this.mOuterBounds.height() - this.mBorderBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mMarginRightText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mOuterBounds.width() - (this.mOuterBounds.width() - this.mBorderBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mOuterBounds.top + this.mOuterBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mMarginBottomText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mOuterBounds.left + this.mOuterBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mOuterBounds.bottom - (this.mOuterBounds.height() - this.mBorderBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        canvas.translate((this.mOuterBounds.width() - this.mBorderBounds.width()) / 2.0f, (this.mOuterBounds.height() - this.mBorderBounds.height()) / 2.0f);
        canvas.drawText(TEXT_BORDER, this.mTextOffsetX, (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mBorderLeftText, this.isNative ? TEXT_NULL : TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mBorderBounds.left + (this.mBorderBounds.width() - this.mPaddingBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mBorderBounds.top + this.mBorderBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mBorderTopText, this.isNative ? TEXT_NULL : TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mBorderBounds.left + this.mBorderBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mBorderBounds.top + (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mBorderRightText, this.isNative ? TEXT_NULL : TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mBorderBounds.width() - (this.mBorderBounds.width() - this.mPaddingBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mBorderBounds.top + this.mBorderBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mBorderBottomText, this.isNative ? TEXT_NULL : TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mBorderBounds.left + this.mBorderBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mBorderBounds.bottom - (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        canvas.translate((this.mBorderBounds.width() - this.mPaddingBounds.width()) / 2.0f, (this.mBorderBounds.height() - this.mPaddingBounds.height()) / 2.0f);
        canvas.drawText(TEXT_PADDING, this.mTextOffsetX / 2.0f, (this.mPaddingBounds.height() - this.mContentBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mPaddingLeftText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mPaddingBounds.left + (this.mPaddingBounds.width() - this.mContentBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mPaddingBounds.top + this.mPaddingBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mPaddingTopText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mPaddingBounds.left + this.mPaddingBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mPaddingBounds.top + (this.mPaddingBounds.height() - this.mContentBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mPaddingRightText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mPaddingBounds.width() - (this.mPaddingBounds.width() - this.mContentBounds.width()) / 4.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mPaddingBounds.top + this.mPaddingBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        tempText = this.prepareText(this.mPaddingBottomText, TEXT_ZERO);
        this.mTextPaint.getTextBounds(tempText, 0, tempText.length(), this.mCachedTextBounds);
        canvas.drawText(tempText, this.mPaddingBounds.left + this.mPaddingBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mPaddingBounds.bottom - (this.mPaddingBounds.height() - this.mContentBounds.height()) / 4.0f + this.mTextOffsetY, this.mTextPaint);
        canvas.translate((this.mPaddingBounds.width() - this.mContentBounds.width()) / 2.0f, (this.mPaddingBounds.height() - this.mContentBounds.height()) / 2.0f);
        String content = this.prepareText(this.mWidthText, TEXT_UNKNOWN) + " x " + this.prepareText(this.mHeightText, TEXT_UNKNOWN);
        this.mTextPaint.getTextBounds(content, 0, content.length(), this.mCachedTextBounds);
        canvas.drawText(content, this.mContentBounds.width() / 2.0f - (float)this.mCachedTextBounds.width() / 2.0f, this.mContentBounds.height() / 2.0f + this.mTextOffsetY, this.mTextPaint);
        canvas.restore();
    }

    private String prepareText(@Nullable String text, @NonNull String placeHolder) {
        return TextUtils.isEmpty((CharSequence)text) || TEXT_ZERO.equals(text) ? placeHolder : text;
    }

    private int getResolvedSize(int desiredSize, int measureSpec) {
        int size;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            size = specSize;
        } else {
            size = desiredSize;
            if (mode == Integer.MIN_VALUE) {
                size = Math.min(desiredSize, specSize);
            }
        }
        return size;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean aNative) {
        this.isNative = aNative;
    }

    public String getMarginTopText() {
        return this.mMarginTopText;
    }

    public void setMarginTopText(String mMarginTopText) {
        this.mMarginTopText = mMarginTopText;
    }

    public String getMarginLeftText() {
        return this.mMarginLeftText;
    }

    public void setMarginLeftText(String mMarginLeftText) {
        this.mMarginLeftText = mMarginLeftText;
    }

    public String getMarginRightText() {
        return this.mMarginRightText;
    }

    public void setMarginRightText(String mMarginRightText) {
        this.mMarginRightText = mMarginRightText;
    }

    public String getMarginBottomText() {
        return this.mMarginBottomText;
    }

    public void setMarginBottomText(String mMarginBottomText) {
        this.mMarginBottomText = mMarginBottomText;
    }

    public String getPaddingLeftText() {
        return this.mPaddingLeftText;
    }

    public void setPaddingLeftText(String mPaddingLeftText) {
        this.mPaddingLeftText = mPaddingLeftText;
    }

    public String getPaddingTopText() {
        return this.mPaddingTopText;
    }

    public void setPaddingTopText(String mPaddingTopText) {
        this.mPaddingTopText = mPaddingTopText;
    }

    public String getPaddingRightText() {
        return this.mPaddingRightText;
    }

    public void setPaddingRightText(String mPaddingRightText) {
        this.mPaddingRightText = mPaddingRightText;
    }

    public String getPaddingBottomText() {
        return this.mPaddingBottomText;
    }

    public void setPaddingBottomText(String mPaddingBottomText) {
        this.mPaddingBottomText = mPaddingBottomText;
    }

    public String getWidthText() {
        return this.mWidthText;
    }

    public void setWidthText(String mWidthText) {
        this.mWidthText = mWidthText;
    }

    public String getHeightText() {
        return this.mHeightText;
    }

    public void setHeightText(String mHeightText) {
        this.mHeightText = mHeightText;
    }

    public String getBorderBottomText() {
        return this.mBorderBottomText;
    }

    public void setBorderBottomText(String mBorderBottomText) {
        this.mBorderBottomText = mBorderBottomText;
    }

    public String getBorderRightText() {
        return this.mBorderRightText;
    }

    public void setBorderRightText(String mBorderRightText) {
        this.mBorderRightText = mBorderRightText;
    }

    public String getBorderTopText() {
        return this.mBorderTopText;
    }

    public void setBorderTopText(String mBorderTopText) {
        this.mBorderTopText = mBorderTopText;
    }

    public String getBorderLeftText() {
        return this.mBorderLeftText;
    }

    public void setBorderLeftText(String mBorderLeftText) {
        this.mBorderLeftText = mBorderLeftText;
    }
}

