/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.pojo;

import android.support.annotation.NonNull;
import android.util.Log;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;
import java.util.Map;

public class HealthReport {
    public boolean hasList;
    public boolean hasScroller;
    public boolean hasBigCell;
    @JSONField(name="maxLayerOfVDom")
    public int maxLayer;
    public int maxLayerOfRealDom;
    @JSONField(serialize=false)
    public int maxCellViewNum;
    @JSONField(serialize=false)
    public int componentNumOfBigCell;
    @JSONField(serialize=false)
    public Map<String, String> extendProps;
    public boolean hasEmbed;
    public int estimateContentHeight;
    public String estimatePages;
    public List<EmbedDesc> embedDescList;
    public Map<String, ListDesc> listDescMap;
    private String bundleUrl;

    public HealthReport(@NonNull String bundleUrl) {
        this.bundleUrl = bundleUrl;
    }

    public void writeToConsole() {
        Log.d((String)"weex-analyzer", (String)("health report(" + this.bundleUrl + ")"));
        Log.d((String)"weex-analyzer", (String)("[health report] maxLayer:" + this.maxLayer));
        Log.d((String)"weex-analyzer", (String)("[health report] maxLayerOfRealDom:" + this.maxLayerOfRealDom));
        Log.d((String)"weex-analyzer", (String)("[health report] hasList:" + this.hasList));
        Log.d((String)"weex-analyzer", (String)("[health report] hasScroller:" + this.hasScroller));
        Log.d((String)"weex-analyzer", (String)("[health report] hasBigCell:" + this.hasBigCell));
        Log.d((String)"weex-analyzer", (String)("[health report] maxCellViewNum:" + this.maxCellViewNum));
        if (this.listDescMap != null && !this.listDescMap.isEmpty()) {
            Log.d((String)"weex-analyzer", (String)("[health report] listNum:" + this.listDescMap.size()));
            for (ListDesc listDesc : this.listDescMap.values()) {
                Log.d((String)"weex-analyzer", (String)("[health report] listDesc: (ref:" + listDesc.ref + ",cellNum:" + listDesc.cellNum + ",totalHeight:" + listDesc.totalHeight + "px)"));
            }
        }
        Log.d((String)"weex-analyzer", (String)("[health report] hasEmbed:" + this.hasEmbed));
        if (this.embedDescList != null && !this.embedDescList.isEmpty()) {
            Log.d((String)"weex-analyzer", (String)("[health report] embedNum:" + this.embedDescList.size()));
            for (EmbedDesc embedDesc : this.embedDescList) {
                Log.d((String)"weex-analyzer", (String)("[health report] embedDesc: (src:" + embedDesc.src + ",layer:" + embedDesc.actualMaxLayer + ")"));
            }
        }
        Log.d((String)"weex-analyzer", (String)("[health report] estimateContentHeight:" + this.estimateContentHeight + "px" + ",estimatePages:" + this.estimatePages));
        Log.d((String)"weex-analyzer", (String)"\n");
        if (this.extendProps != null) {
            for (Map.Entry entry : this.extendProps.entrySet()) {
                Log.d((String)"weex-analyzer", (String)("[health report] " + (String)entry.getKey() + ":" + (String)entry.getValue() + ")"));
            }
        }
    }

    public static class ListDesc {
        public String ref;
        public int totalHeight;
        public int cellNum;
    }

    public static class EmbedDesc {
        public String src;
        public int beginLayer;
        public int actualMaxLayer;
    }
}

