/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core.reporter;

import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.reporter.IDataReporter;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.core.reporter.MDSDataReporterFactory;
import com.taobao.weex.utils.WXLogUtils;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ReportSupportLoopTask<T>
extends AbstractLoopTask {
    private IDataReporter<T> mDataReporter;
    private AtomicInteger mSequenceId = new AtomicInteger(0);
    private static final String TAG = "Reporter";

    public ReportSupportLoopTask(boolean runInMainThread) {
        super(runInMainThread);
        this.mDataReporter = this.newDataReporter();
    }

    public ReportSupportLoopTask(boolean runInMainThread, int delayMillis) {
        super(runInMainThread, delayMillis);
        this.mDataReporter = this.newDataReporter();
    }

    @Nullable
    protected IDataReporter<T> newDataReporter() {
        String from = LaunchConfig.getFrom();
        String deviceId = LaunchConfig.getDeviceId();
        if (!TextUtils.isEmpty((CharSequence)from) && !TextUtils.isEmpty((CharSequence)deviceId)) {
            return MDSDataReporterFactory.create(from, deviceId);
        }
        return null;
    }

    protected void reportIfNeeded(@Nullable IDataReporter.ProcessedData<T> data) {
        if (data == null || this.mDataReporter == null) {
            return;
        }
        try {
            if (this.mDataReporter.isEnabled()) {
                this.mDataReporter.report(data);
            }
        }
        catch (Exception e) {
            WXLogUtils.e((String)TAG, (String)e.getMessage());
        }
    }

    protected int getSequenceId() {
        return this.mSequenceId.get();
    }

    protected int generateSequenceId() {
        return this.mSequenceId.getAndIncrement();
    }

    @Override
    @CallSuper
    protected void onStop() {
        this.mDataReporter = null;
        this.mSequenceId.getAndSet(0);
    }
}

