/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core.reporter;

import android.support.annotation.NonNull;

public interface IDataReporter<T> {
    public static final String TYPE_WEEX_PERFORMANCE_STATISTICS = "weex_performance_statistics";
    public static final String TYPE_VIEW_INSPECTOR = "view_inspector";
    public static final String TYPE_RENDER_ANALYSIS = "render_analysis";
    public static final String TYPE_MTOP_INSPECTOR = "mtop_inspector";
    public static final String TYPE_MEMORY = "memory";
    public static final String TYPE_CPU = "cpu";
    public static final String TYPE_FPS = "fps";
    public static final String TYPE_TRAFFIC = "traffic";
    public static final String API_VERSION = "1";

    public void report(@NonNull ProcessedData<T> var1);

    public boolean isEnabled();

    public static final class ProcessedDataBuilder<T> {
        private int mSequenceId;
        private String mDeviceId;
        private long mTimestamp = System.currentTimeMillis();
        private String mType;
        private T mData;
        private String mVersion = "1";

        public ProcessedDataBuilder<T> sequenceId(int sequenceId) {
            this.mSequenceId = sequenceId;
            return this;
        }

        public ProcessedDataBuilder<T> deviceId(String deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        public ProcessedDataBuilder<T> type(String type) {
            this.mType = type;
            return this;
        }

        public ProcessedDataBuilder<T> data(T data) {
            this.mData = data;
            return this;
        }

        public ProcessedData<T> build() {
            ProcessedData processedData = new ProcessedData();
            processedData.sequenceId = this.mSequenceId;
            processedData.deviceId = this.mDeviceId;
            processedData.timestamp = this.mTimestamp;
            processedData.data = this.mData;
            processedData.type = this.mType;
            processedData.version = this.mVersion;
            return processedData;
        }
    }

    public static class ProcessedData<T> {
        private int sequenceId;
        private String deviceId;
        private String version;
        private long timestamp;
        private String type;
        private T data;

        public int getSequenceId() {
            return this.sequenceId;
        }

        public void setSequenceId(int sequenceId) {
            this.sequenceId = sequenceId;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }
    }
}

