/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.core.PerformanceMonitor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXPerfStorage {
    private static final int DEFAULT_SAMPLE_NUM = 6;
    private Map<String, LinkedList<Performance>> mHistoryData = new HashMap<String, LinkedList<Performance>>();
    private int mSampleNum = 6;
    private static WXPerfStorage sInstance;

    private WXPerfStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WXPerfStorage getInstance() {
        if (sInstance != null) return sInstance;
        Class<WXPerfStorage> clazz = WXPerfStorage.class;
        synchronized (WXPerfStorage.class) {
            if (sInstance != null) return sInstance;
            sInstance = new WXPerfStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public String savePerformance(@NonNull WXSDKInstance instance) {
        String pageName = null;
        Performance performance = PerformanceMonitor.monitor(instance);
        if (performance != null) {
            pageName = WXPerfStorage.fetchPageName(instance, performance);
            this.put(pageName, performance);
        }
        return pageName;
    }

    @Nullable
    public Performance getLatestPerformance(@Nullable String pageName) {
        List<Performance> cachedList = this.getPerformanceList(pageName);
        if (cachedList.size() == 0) {
            return null;
        }
        return cachedList.get(cachedList.size() - 1);
    }

    @NonNull
    public List<Performance> getPerformanceList(@Nullable String pageName) {
        if (TextUtils.isEmpty((CharSequence)pageName) || this.mHistoryData == null) {
            return Collections.emptyList();
        }
        List cachedList = this.mHistoryData.get(pageName);
        if (cachedList == null || cachedList.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(cachedList);
    }

    @Nullable
    private static String fetchPageName(@NonNull WXSDKInstance instance, @NonNull Performance performance) {
        String templateUrl = performance.templateUrl;
        if (!TextUtils.isEmpty((CharSequence)templateUrl)) {
            return templateUrl;
        }
        try {
            Method method = instance.getClass().getDeclaredMethod("getBundleUrl", new Class[0]);
            method.setAccessible(true);
            templateUrl = (String)method.invoke((Object)instance, new Object[0]);
            method.setAccessible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)templateUrl)) {
            return templateUrl;
        }
        return performance.pageName;
    }

    private void put(@Nullable String pageName, @Nullable Performance performance) {
        if (TextUtils.isEmpty((CharSequence)pageName) || performance == null || this.mHistoryData == null) {
            return;
        }
        LinkedList<Performance> list = this.mHistoryData.get(pageName);
        if (list == null) {
            list = new LinkedList();
            this.mHistoryData.put(pageName, list);
        }
        if (list.size() >= this.mSampleNum) {
            list.removeFirst();
        }
        list.add(performance);
    }

    public void setSampleNum(int sampleNum) {
        if (sampleNum <= 0) {
            return;
        }
        this.mSampleNum = sampleNum;
    }

    public int getSampleNum() {
        return this.mSampleNum;
    }
}

