/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.dom.ImmutableDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXTextView;
import com.taobao.weex.ui.view.border.BorderDrawable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class ViewPropertiesSupplier {
    @NonNull
    public Map<String, String> supplyPropertiesFromVirtualView(@NonNull WXComponent component) {
        ImmutableDomObject domObject = component.getDomObject();
        if (domObject == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        if (domObject.getStyles() != null) {
            for (Map.Entry entry : domObject.getStyles().entrySet()) {
                if (entry.getValue() == null) continue;
                result.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if (domObject.getAttrs() != null) {
            for (Map.Entry entry : domObject.getAttrs().entrySet()) {
                if (entry.getValue() == null) continue;
                result.put(entry.getKey(), entry.getValue().toString());
            }
        }
        return Collections.unmodifiableMap(result);
    }

    @NonNull
    public Map<String, String> supplyPropertiesFromNativeView(@NonNull View view) {
        Drawable drawable2;
        WXTextView textView;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("left", String.valueOf(view.getLeft()));
        result.put("top", String.valueOf(view.getTop()));
        result.put("right", String.valueOf(view.getRight()));
        result.put("bottom", String.valueOf(view.getBottom()));
        result.put("width", String.valueOf(view.getWidth()));
        result.put("height", String.valueOf(view.getHeight()));
        result.put("paddingLeft", String.valueOf(view.getPaddingLeft()));
        result.put("paddingTop", String.valueOf(view.getPaddingTop()));
        result.put("paddingRight", String.valueOf(view.getPaddingRight()));
        result.put("paddingBottom", String.valueOf(view.getPaddingBottom()));
        result.put("visibility", view.getVisibility() == 0 ? "visible" : "invisible");
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (params != null && params instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)params;
            result.put("marginLeft", String.valueOf(marginLayoutParams.leftMargin));
            result.put("marginTop", String.valueOf(marginLayoutParams.topMargin));
            result.put("marginRight", String.valueOf(marginLayoutParams.rightMargin));
            result.put("marginBottom", String.valueOf(marginLayoutParams.bottomMargin));
        }
        result.put("borderLeftWidth", null);
        result.put("borderRightWidth", null);
        result.put("borderTopWidth", null);
        result.put("borderBottomWidth", null);
        if (view instanceof WXTextView && (textView = (WXTextView)view).getText() != null) {
            result.put("value", textView.getText().toString());
        }
        if (view.getBackground() != null && (drawable2 = view.getBackground()) instanceof BorderDrawable) {
            int borderColor;
            BorderDrawable borderDrawable = (BorderDrawable)drawable2;
            result.put("backgroundColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderDrawable.getColor()));
            if (borderDrawable.getOpacity() != -1) {
                result.put("opacity", borderDrawable.getOpacity() + "");
            }
            if ((borderColor = ViewPropertiesSupplier.getBorderColorNative(borderDrawable, 8)) != 0) {
                result.put("borderLeftColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderColor));
                result.put("borderTopColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderColor));
                result.put("borderRightColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderColor));
                result.put("borderBottomColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderColor));
            } else {
                int borderLeftColor = ViewPropertiesSupplier.getBorderColorNative(borderDrawable, 0);
                result.put("borderLeftColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderLeftColor));
                int borderTopColor = ViewPropertiesSupplier.getBorderColorNative(borderDrawable, 1);
                result.put("borderTopColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderTopColor));
                int borderRightColor = ViewPropertiesSupplier.getBorderColorNative(borderDrawable, 2);
                result.put("borderRightColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderRightColor));
                int borderBottomColor = ViewPropertiesSupplier.getBorderColorNative(borderDrawable, 3);
                result.put("borderBottomColor", String.format(Locale.CHINA, "#%06X", 0xFFFFFF & borderBottomColor));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static float getBorderWidthNative(@NonNull BorderDrawable drawable2, int position) {
        try {
            Method method = drawable2.getClass().getDeclaredMethod("getBorderWidth", Integer.TYPE);
            method.setAccessible(true);
            return ((Float)method.invoke((Object)drawable2, position)).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private static int getBorderColorNative(@NonNull BorderDrawable drawable2, int position) {
        try {
            Method method = drawable2.getClass().getDeclaredMethod("getBorderColor", Integer.TYPE);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)drawable2, position);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static interface BoxModelConstants {
        public static final String DEFAULT_WIDTH = "defaultWidth";
        public static final String DEFAULT_HEIGHT = "defaultHeight";
        public static final String HREF = "href";
        public static final String WIDTH = "width";
        public static final String MIN_WIDTH = "minWidth";
        public static final String MAX_WIDTH = "maxWidth";
        public static final String HEIGHT = "height";
        public static final String MIN_HEIGHT = "minHeight";
        public static final String MAX_HEIGHT = "maxHeight";
        public static final String ALIGN_ITEMS = "alignItems";
        public static final String ALIGN_SELF = "alignSelf";
        public static final String FLEX = "flex";
        public static final String FLEX_DIRECTION = "flexDirection";
        public static final String JUSTIFY_CONTENT = "justifyContent";
        public static final String FLEX_WRAP = "flexWrap";
        public static final String MARGIN = "margin";
        public static final String MARGIN_TOP = "marginTop";
        public static final String MARGIN_LEFT = "marginLeft";
        public static final String MARGIN_RIGHT = "marginRight";
        public static final String MARGIN_BOTTOM = "marginBottom";
        public static final String PADDING = "padding";
        public static final String PADDING_TOP = "paddingTop";
        public static final String PADDING_LEFT = "paddingLeft";
        public static final String PADDING_RIGHT = "paddingRight";
        public static final String PADDING_BOTTOM = "paddingBottom";
        public static final String LEFT = "left";
        public static final String TOP = "top";
        public static final String RIGHT = "right";
        public static final String BOTTOM = "bottom";
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String BACKGROUND_IMAGE = "backgroundImage";
        public static final String OPACITY = "opacity";
        public static final String BORDER_RADIUS = "borderRadius";
        public static final String BORDER_WIDTH = "borderWidth";
        public static final String BORDER_COLOR = "borderColor";
        public static final String BORDER_STYLE = "borderStyle";
        public static final String BORDER_TOP_WIDTH = "borderTopWidth";
        public static final String BORDER_RIGHT_WIDTH = "borderRightWidth";
        public static final String BORDER_BOTTOM_WIDTH = "borderBottomWidth";
        public static final String BORDER_LEFT_WIDTH = "borderLeftWidth";
        public static final String BORDER_TOP_COLOR = "borderTopColor";
        public static final String BORDER_RIGHT_COLOR = "borderRightColor";
        public static final String BORDER_BOTTOM_COLOR = "borderBottomColor";
        public static final String BORDER_LEFT_COLOR = "borderLeftColor";
        public static final String BORDER_TOP_LEFT_RADIUS = "borderTopLeftRadius";
        public static final String BORDER_TOP_RIGHT_RADIUS = "borderTopRightRadius";
        public static final String BORDER_BOTTOM_RIGHT_RADIUS = "borderBottomRightRadius";
        public static final String BORDER_BOTTOM_LEFT_RADIUS = "borderBottomLeftRadius";
        public static final String BORDER_RIGHT_STYLE = "borderRightStyle";
        public static final String BORDER_BOTTOM_STYLE = "borderBottomStyle";
        public static final String BORDER_LEFT_STYLE = "borderLeftStyle";
        public static final String BORDER_TOP_STYLE = "borderTopStyle";
        public static final String POSITION = "position";
        public static final String TEXT_DECORATION = "textDecoration";
        public static final String TEXT_ALIGN = "textAlign";
        public static final String FONT_WEIGHT = "fontWeight";
        public static final String FONT_STYLE = "fontStyle";
        public static final String FONT_SIZE = "fontSize";
        public static final String COLOR = "color";
        public static final String LINES = "lines";
        public static final String FONT_FAMILY = "fontFamily";
        public static final String TEXT_OVERFLOW = "textOverflow";
        public static final String ELLIPSIS = "ellipsis";
        public static final String LINE_HEIGHT = "lineHeight";
        public static final String DISABLED = "disabled";
        public static final String VALUE = "value";
        public static final String IMAGE_QUALITY = "imageQuality";
        public static final String FILTER = "filter";
        public static final String QUALITY = "quality";
        public static final String SRC = "src";
        public static final String PLACE_HOLDER = "placeHolder";
        public static final String RESIZE_MODE = "resizeMode";
        public static final String SHOW_INDICATORS = "showIndicators";
        public static final String AUTO_PLAY = "autoPlay";
        public static final String SHOW_SCROLLBAR = "showScrollbar";
        public static final String SCROLL_DIRECTION = "scrollDirection";
        public static final String SCOPE = "scope";
        public static final String LOADMORERETRY = "loadmoreretry";
        public static final String LOADMOREOFFSET = "loadmoreoffset";
        public static final String RECYCLE_IMAGE = "recycleImage";
        public static final String OVERFLOW = "overflow";
        public static final String TYPE = "type";
        public static final String PLACEHOLDER = "placeholder";
        public static final String PLACEHOLDER_COLOR = "placeholderColor";
        public static final String AUTOFOCUS = "autofocus";
        public static final String SINGLELINE = "singleline";
        public static final String MAX_LENGTH = "maxLength";
        public static final String MAXLENGTH = "maxlength";
        public static final String ROWS = "rows";
        public static final String CHECKED = "checked";
        public static final String VISIBILITY = "visibility";
        public static final String ITEM_COLOR = "itemColor";
        public static final String ITEM_SELECTED_COLOR = "itemSelectedColor";
        public static final String ITEM_SIZE = "itemSize";
        public static final String DISPLAY = "display";
        public static final String SHOW_LOADING = "show-loading";
        public static final String SUFFIX = "suffix";
        public static final String RESIZE = "resize";
        public static final String IMAGE_SHARPEN = "imageSharpen";
        public static final String SHARPEN = "sharpen";
        public static final String PREFIX = "prefix";
        public static final String INDEX = "index";
        public static final String INTERVAL = "interval";
        public static final String PLAY_STATUS = "playStatus";
        public static final String FONT_FACE = "fontFace";
        public static final String MAX = "max";
        public static final String MIN = "min";
        public static final String NAV_BAR_VISIBILITY = "hidden";
        public static final String OFFSET_X_ACCURACY = "offsetXAccuracy";
        public static final String OFFSET_X_RATIO = "offsetXRatio";
        public static final String ELEVATION = "elevation";
        public static final String SCROLLABLE = "scrollable";
        public static final String DISTANCE_Y = "dy";
        public static final String PULLING_DISTANCE = "pullingDistance";
        public static final String VIEW_HEIGHT = "viewHeight";
        public static final String PREVENT_MOVE_EVENT = "preventMoveEvent";
    }
}

