/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.fastjson.annotation.JSONField;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.core.ViewPropertiesSupplier;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXVContainer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ViewInspectorManager {
    private OnInspectorListener mListener;
    private ViewPropertiesSupplier mSupplier;
    private ExecutorService mExecutor;
    private WXSDKInstance mInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    private ViewInspectorManager(@NonNull ExecutorService executor, @NonNull ViewPropertiesSupplier supplier, @NonNull OnInspectorListener listener) {
        this.mListener = listener;
        this.mSupplier = supplier;
        this.mExecutor = executor;
    }

    public void setInstance(@Nullable WXSDKInstance instance) {
        this.mInstance = instance;
    }

    @NonNull
    public static ViewInspectorManager newInstance(@NonNull ExecutorService executor, @NonNull ViewPropertiesSupplier supplier, @NonNull OnInspectorListener listener) {
        return new ViewInspectorManager(executor, supplier, listener);
    }

    public void inspectByMotionEvent(final @NonNull MotionEvent event) {
        if (this.mExecutor == null || this.mInstance == null) {
            return;
        }
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (ViewInspectorManager.this.mInstance == null) {
                    return;
                }
                WXComponent rootComponent = ViewInspectorManager.this.mInstance.getRootComponent();
                if (rootComponent == null) {
                    return;
                }
                View rootView = rootComponent.getHostView();
                if (rootView == null) {
                    return;
                }
                View targetView = ViewInspectorManager.this.findPossibleTouchedView(rootView, event.getRawX(), event.getRawY());
                if (targetView != null) {
                    WXComponent targetComponent = ViewInspectorManager.this.findBoundComponentBy(targetView, rootComponent);
                    final InspectorInfo inspectorInfo = new InspectorInfo();
                    inspectorInfo.targetView = targetView;
                    inspectorInfo.targetComponent = targetComponent;
                    inspectorInfo.nativeViewInfo = Collections.emptyMap();
                    inspectorInfo.virtualViewInfo = Collections.emptyMap();
                    inspectorInfo.simpleName = targetComponent != null ? ViewUtils.getComponentName(targetComponent) : targetView.getClass().getSimpleName();
                    if (ViewInspectorManager.this.mSupplier != null) {
                        Map<String, String> nativeViewInfo = ViewInspectorManager.this.mSupplier.supplyPropertiesFromNativeView(targetView);
                        Map<String, String> virtualViewInfo = null;
                        if (targetComponent != null) {
                            virtualViewInfo = ViewInspectorManager.this.mSupplier.supplyPropertiesFromVirtualView(targetComponent);
                        }
                        inspectorInfo.nativeViewInfo = nativeViewInfo;
                        inspectorInfo.virtualViewInfo = virtualViewInfo;
                    }
                    if (ViewInspectorManager.this.mListener != null) {
                        ViewInspectorManager.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ViewInspectorManager.this.mListener.onInspectorSuccess(inspectorInfo);
                            }
                        });
                    }
                } else if (ViewInspectorManager.this.mListener != null) {
                    ViewInspectorManager.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ViewInspectorManager.this.mListener.onInspectorFailed("target view not found");
                        }
                    });
                }
            }
        });
    }

    @Nullable
    private View findPossibleTouchedView(@NonNull View rootView, float x, float y) {
        ArrayDeque<View> deque = new ArrayDeque<View>();
        deque.add(rootView);
        View target = null;
        int[] location = new int[2];
        while (!deque.isEmpty()) {
            View view = (View)deque.removeFirst();
            view.getLocationInWindow(location);
            if (x > (float)location[0] && x < (float)(location[0] + view.getWidth()) && y > (float)location[1] && y < (float)(location[1] + view.getHeight())) {
                target = view;
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            int len = group.getChildCount();
            for (int i = 0; i < len; ++i) {
                View child = group.getChildAt(i);
                deque.add(child);
            }
        }
        return target;
    }

    @Nullable
    private WXComponent findBoundComponentBy(@NonNull View targetView, @NonNull WXComponent rootComponent) {
        ArrayDeque<WXComponent> deque = new ArrayDeque<WXComponent>();
        deque.add(rootComponent);
        WXComponent targetComponent = null;
        while (!deque.isEmpty()) {
            WXComponent component = (WXComponent)deque.removeFirst();
            View view = component.getHostView();
            if (view != null && view.equals(targetView)) {
                targetComponent = component;
            }
            if (component instanceof WXEmbed) {
                WXComponent nestedRootComponent = ViewUtils.getNestedRootComponent((WXEmbed)component);
                if (nestedRootComponent == null) continue;
                deque.add(nestedRootComponent);
                continue;
            }
            if (!(component instanceof WXVContainer)) continue;
            WXVContainer container = (WXVContainer)component;
            int len = container.getChildCount();
            for (int i = 0; i < len; ++i) {
                WXComponent c = container.getChild(i);
                deque.add(c);
            }
        }
        return targetComponent;
    }

    public void destroy() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
        this.mSupplier = null;
        this.mListener = null;
        this.mInstance = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public static class InspectorInfo {
        public Map<String, String> virtualViewInfo;
        public Map<String, String> nativeViewInfo;
        @JSONField(serialize=false)
        public WXComponent targetComponent;
        @JSONField(serialize=false)
        public View targetView;
        public String simpleName;

        public String toString() {
            return "InspectorInfo{virtualViewInfo=" + this.virtualViewInfo + ", nativeViewInfo=" + this.nativeViewInfo + ", targetComponent=" + this.targetComponent + ", targetView=" + this.targetView + ", simpleName='" + this.simpleName + '\'' + '}';
        }
    }

    public static interface OnInspectorListener {
        public void onInspectorSuccess(@NonNull InspectorInfo var1);

        public void onInspectorFailed(@NonNull String var1);
    }
}

