/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Process;
import android.support.annotation.NonNull;
import com.taobao.weex.analyzer.core.TaskEntity;
import com.taobao.weex.analyzer.core.TrafficSampler;

public class TrafficTaskEntity
implements TaskEntity<TrafficInfo> {
    private double mTotalRxKBytes = 0.0;
    private double mTotalTxKBytes = 0.0;
    private TrafficInfo mCachedTrafficInfo;
    private int mDelayInMillis = 1000;

    public TrafficTaskEntity(int delayInMillis) {
        this.mDelayInMillis = delayInMillis;
    }

    @Override
    public void onTaskInit() {
        this.mCachedTrafficInfo = new TrafficInfo();
    }

    @Override
    @NonNull
    public TrafficInfo onTaskRun() {
        double rxSpeed;
        double txSpeed;
        double txKBytes = TrafficSampler.getUidTxBytes(Process.myUid()) / 1024.0;
        double rxKBytes = TrafficSampler.getUidRxBytes(Process.myUid()) / 1024.0;
        int ratio = this.mDelayInMillis / 1000;
        if (this.mTotalTxKBytes == 0.0 && this.mTotalRxKBytes == 0.0) {
            txSpeed = 0.0;
            rxSpeed = 0.0;
        } else {
            txSpeed = Math.max(0.0, (txKBytes - this.mTotalTxKBytes) / (double)ratio);
            rxSpeed = Math.max(0.0, (rxKBytes - this.mTotalRxKBytes) / (double)ratio);
        }
        if (this.mCachedTrafficInfo == null) {
            this.mCachedTrafficInfo = new TrafficInfo();
        }
        this.mCachedTrafficInfo.rxSpeed = (double)Math.round(rxSpeed * 100.0) / 100.0;
        this.mCachedTrafficInfo.txSpeed = (double)Math.round(txSpeed * 100.0) / 100.0;
        this.mTotalRxKBytes = rxKBytes;
        this.mTotalTxKBytes = txKBytes;
        return this.mCachedTrafficInfo;
    }

    @Override
    public void onTaskStop() {
        this.mTotalRxKBytes = 0.0;
        this.mTotalTxKBytes = 0.0;
        this.mCachedTrafficInfo = null;
    }

    public static class TrafficInfo {
        public double txSpeed;
        public double rxSpeed;
    }
}

