/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class LogcatDumper
implements Handler.Callback {
    private ExecutorService mExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "wx_analyzer_logcat_dumper");
        }
    });
    private static final int MESSAGE_DUMP_LOG = 1;
    private static final int MESSAGE_FILTER_LOG = 2;
    private Handler mHandler;
    private DumpLogRunnable mDumpLogRunnable;
    private OnLogReceivedListener mListener;
    private int mLevel;
    private List<Rule> mRules;
    private static final int DEFAULT_CACHE_LIMIT = 1000;
    private int mCacheLimit;
    private boolean isCacheEnabled = true;
    private volatile LinkedList<LogInfo> mCachedLogList;

    LogcatDumper(@Nullable OnLogReceivedListener listener) {
        this.mListener = listener;
        this.mCacheLimit = 1000;
        this.mRules = new LinkedList<Rule>();
        this.mCachedLogList = new LinkedList();
    }

    public void addRule(@Nullable Rule rule) {
        if (rule == null) {
            return;
        }
        this.mRules.add(rule);
    }

    public void setLevel(int level) {
        this.mLevel = level;
    }

    public boolean removeRule(@Nullable Rule rule) {
        if (rule == null) {
            return false;
        }
        return this.mRules.remove(rule);
    }

    public boolean removeRule(@Nullable String ruleName) {
        if (TextUtils.isEmpty((CharSequence)ruleName)) {
            return false;
        }
        Rule r = new Rule(ruleName, "");
        return this.mRules.remove(r);
    }

    public void removeAllRule() {
        this.mRules.clear();
    }

    public void setCacheLimit(int cacheLimit) {
        if (cacheLimit <= 0) {
            return;
        }
        this.mCacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.mCacheLimit;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.isCacheEnabled = cacheEnabled;
    }

    public boolean isCacheEnabled() {
        return this.isCacheEnabled;
    }

    public void beginDump() {
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        this.mDumpLogRunnable = new DumpLogRunnable(true);
        this.execute(this.mDumpLogRunnable);
    }

    public void findCachedLogByNewFilters() {
        if (this.mHandler == null || !this.isCacheEnabled) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                List result = LogcatDumper.this.filterCachedLog();
                Message msg = Message.obtain();
                msg.what = 2;
                msg.obj = result;
                if (LogcatDumper.this.mHandler != null) {
                    LogcatDumper.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    public synchronized void clearCachedLog() {
        if (this.mCachedLogList != null) {
            this.mCachedLogList.clear();
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                LogcatDumper.this.clearLog();
            }
        });
    }

    @VisibleForTesting
    @Nullable
    public Handler getHandler() {
        return this.mHandler;
    }

    public void destroy() {
        if (this.mDumpLogRunnable != null) {
            this.mDumpLogRunnable.destroy();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
        }
        this.mHandler = null;
        this.mExecutor = null;
        this.mDumpLogRunnable = null;
        this.mCachedLogList.clear();
        this.mCachedLogList = null;
    }

    private synchronized void cacheLog(@NonNull LogInfo logInfo) {
        if (this.mCachedLogList == null) {
            return;
        }
        if (this.mCachedLogList.size() >= this.mCacheLimit) {
            this.mCachedLogList.removeFirst();
        }
        this.mCachedLogList.add(logInfo);
    }

    private synchronized List<LogInfo> filterCachedLog() {
        if (this.mCachedLogList == null || this.mCachedLogList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LogInfo> resultList = new ArrayList<LogInfo>();
        for (LogInfo info : this.mCachedLogList) {
            int level = info.level;
            String message = info.message;
            if (!this.checkLevel(level) || !this.checkRule(message)) continue;
            resultList.add(info);
        }
        return resultList;
    }

    public boolean handleMessage(Message msg) {
        if (this.mListener == null) {
            return false;
        }
        if (msg.what == 1) {
            LogInfo log = (LogInfo)msg.obj;
            this.mListener.onReceived(Collections.singletonList(log));
        } else if (msg.what == 2) {
            List list = (List)msg.obj;
            this.mListener.onReceived(list);
        }
        return false;
    }

    private void clearLog() {
        Process tempProcess = null;
        try {
            tempProcess = Runtime.getRuntime().exec("logcat -c");
            Thread.sleep(500L);
        }
        catch (Exception e) {
            Log.d((String)"weex-analyzer", (String)e.getMessage());
        }
        finally {
            if (tempProcess != null) {
                tempProcess.destroy();
            }
        }
    }

    private boolean checkRule(String log) {
        if (this.mRules.isEmpty()) {
            return true;
        }
        for (Rule rule : this.mRules) {
            if (rule.accept(log)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLevel(int level) {
        if (this.mLevel == 0 || this.mLevel == 2) {
            return true;
        }
        return level == this.mLevel;
    }

    private int getLevel(@NonNull String log) {
        if (log.length() < 20) {
            return 86;
        }
        char level = log.charAt(19);
        switch (level) {
            case 'V': {
                return 2;
            }
            case 'I': {
                return 4;
            }
            case 'D': {
                return 3;
            }
            case 'W': {
                return 5;
            }
            case 'E': {
                return 6;
            }
        }
        return 0;
    }

    private void dumpLog(@NonNull String log, int level) {
        if (this.mHandler == null) {
            return;
        }
        LogInfo info = new LogInfo();
        info.message = log;
        info.level = level;
        Message message = Message.obtain();
        message.what = 1;
        message.obj = info;
        this.mHandler.sendMessage(message);
    }

    private void execute(Runnable command) {
        if (this.mExecutor != null) {
            this.mExecutor.execute(command);
        }
    }

    public static class Rule {
        private String name;
        private String filter;

        public Rule(@Nullable String name, @Nullable String filter) {
            this.name = name;
            this.filter = filter;
        }

        public boolean accept(@NonNull String log) {
            if (TextUtils.isEmpty((CharSequence)this.filter)) {
                return true;
            }
            return log.contains(this.filter);
        }

        public String getName() {
            return this.name;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            return this.name != null ? this.name.equals(rule.name) : rule.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    private class DumpLogRunnable
    implements Runnable {
        private Process logProcess;
        private boolean isAllowClear;

        DumpLogRunnable(boolean allowClear) {
            this.isAllowClear = allowClear;
        }

        @Override
        public void run() {
            try {
                String line;
                if (this.isAllowClear) {
                    LogcatDumper.this.clearLog();
                }
                this.logProcess = Runtime.getRuntime().exec("logcat -v time");
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.logProcess.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    int level = LogcatDumper.this.getLevel(line);
                    if (LogcatDumper.this.checkLevel(level) && LogcatDumper.this.checkRule(line)) {
                        LogcatDumper.this.dumpLog(line, level);
                    }
                    if (!LogcatDumper.this.isCacheEnabled) continue;
                    LogcatDumper.this.cacheLog(new LogInfo(line, level));
                }
            }
            catch (IOException e) {
                Log.e((String)"weex-analyzer", (String)e.getMessage());
            }
        }

        void destroy() {
            try {
                if (this.logProcess != null) {
                    this.logProcess.destroy();
                }
            }
            catch (Exception e) {
                Log.e((String)"weex-analyzer", (String)e.getMessage());
            }
        }
    }

    public class LogInfo {
        public String message;
        public int level;

        public LogInfo() {
        }

        public LogInfo(String message, int level) {
            this.message = message;
            this.level = level;
        }
    }

    public static interface OnLogReceivedListener {
        public void onReceived(@NonNull List<LogInfo> var1);
    }
}

