/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.annotation.TargetApi;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.Choreographer;

@TargetApi(value=16)
public class FPSSampler
implements Choreographer.FrameCallback {
    private Choreographer mChoreographer;
    private long mFirstFrameTime = -1L;
    private long mLastFrameTime = -1L;
    private int mNumFrameCallbacks = 0;
    private boolean bShouldStop = false;
    private static final float DEVICE_REFRESH_RATE_IN_MS = 16.67f;

    public FPSSampler(@NonNull Choreographer choreographer) {
        this.mChoreographer = choreographer;
    }

    public void start() {
        this.bShouldStop = false;
        this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void stop() {
        this.bShouldStop = true;
        this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
    }

    public void reset() {
        this.mFirstFrameTime = -1L;
        this.mLastFrameTime = -1L;
        this.mNumFrameCallbacks = 0;
    }

    public void doFrame(long frameTimeNanos) {
        if (this.bShouldStop) {
            return;
        }
        long currentTimeMillis = frameTimeNanos;
        if (this.mFirstFrameTime == -1L) {
            this.mFirstFrameTime = currentTimeMillis;
        } else {
            ++this.mNumFrameCallbacks;
        }
        this.mLastFrameTime = currentTimeMillis;
        this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public int getExpectedNumFrames() {
        double totalTimeMillis = (int)((double)this.mLastFrameTime - (double)this.mFirstFrameTime) / 1000000;
        return (int)(totalTimeMillis / (double)16.67f);
    }

    public int getNumFrames() {
        return this.mNumFrameCallbacks;
    }

    public double getFPS() {
        if (this.mLastFrameTime == this.mFirstFrameTime) {
            return 0.0;
        }
        return (double)this.getNumFrames() * 1.0E9 / (double)(this.mLastFrameTime - this.mFirstFrameTime);
    }

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 16;
    }
}

