/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

class CpuSampler {
    private CpuSampler() {
    }

    static String sampleCpuRate() {
        return CpuSampler.doSample("/proc/stat");
    }

    static String samplePidCpuRate() {
        int pid = Process.myPid();
        return CpuSampler.doSample("/proc/" + pid + "/stat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String doSample(@NonNull String filename) {
        BufferedReader cpuReader = null;
        String cpuRate = "";
        try {
            cpuReader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)), 1024);
            cpuRate = cpuReader.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (cpuReader != null) {
                    cpuReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cpuRate;
    }
}

