/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.listview.WXRecyclerView;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;

public class ComponentHeightComputer {
    private ComponentHeightComputer() {
    }

    public static int computeComponentContentHeight(@NonNull WXComponent component) {
        View view = component.getHostView();
        if (view == null) {
            return 0;
        }
        if (component instanceof WXListComponent) {
            WXListComponent listComponent = (WXListComponent)component;
            BounceRecyclerView bounceRecyclerView = (BounceRecyclerView)listComponent.getHostView();
            if (bounceRecyclerView == null) {
                return 0;
            }
            WXRecyclerView innerView = (WXRecyclerView)bounceRecyclerView.getInnerView();
            if (innerView == null) {
                return bounceRecyclerView.getMeasuredHeight();
            }
            return innerView.computeVerticalScrollRange();
        }
        if (component instanceof WXScroller) {
            WXScroller scroller = (WXScroller)component;
            if (!ViewUtils.isVerticalScroller(scroller)) {
                return view.getMeasuredHeight();
            }
            ViewGroup group = scroller.getInnerView();
            if (group == null) {
                return view.getMeasuredHeight();
            }
            if (group.getChildCount() != 1) {
                return view.getMeasuredHeight();
            }
            return group.getChildAt(0).getMeasuredHeight();
        }
        return view.getMeasuredHeight();
    }
}

