/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.SensorManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Toast;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.IWXDevOptions;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.DevOptionsConfig;
import com.taobao.weex.analyzer.core.FPSSampler;
import com.taobao.weex.analyzer.core.JSExceptionCatcher;
import com.taobao.weex.analyzer.core.Performance;
import com.taobao.weex.analyzer.core.PollingVDomMonitor;
import com.taobao.weex.analyzer.core.RemoteDebugManager;
import com.taobao.weex.analyzer.core.ShakeDetector;
import com.taobao.weex.analyzer.core.StandardVDomMonitor;
import com.taobao.weex.analyzer.core.VDomController;
import com.taobao.weex.analyzer.core.WXPerfStorage;
import com.taobao.weex.analyzer.core.reporter.LaunchConfig;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.view.CpuSampleView;
import com.taobao.weex.analyzer.view.DevOption;
import com.taobao.weex.analyzer.view.EntranceView;
import com.taobao.weex.analyzer.view.FpsSampleView;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.IResizableView;
import com.taobao.weex.analyzer.view.InspectorView;
import com.taobao.weex.analyzer.view.LogView;
import com.taobao.weex.analyzer.view.MemorySampleView;
import com.taobao.weex.analyzer.view.NetworkInspectorView;
import com.taobao.weex.analyzer.view.PerfSampleOverlayView;
import com.taobao.weex.analyzer.view.ProfileDomView;
import com.taobao.weex.analyzer.view.ScalpelFrameLayout;
import com.taobao.weex.analyzer.view.ScalpelViewController;
import com.taobao.weex.analyzer.view.SettingsActivity;
import com.taobao.weex.analyzer.view.StorageView;
import com.taobao.weex.analyzer.view.TrafficSampleView;
import com.taobao.weex.analyzer.view.WXPerformanceAnalysisView;
import java.util.ArrayList;
import java.util.List;

public class WeexDevOptions
implements IWXDevOptions {
    private Context mContext;
    private ShakeDetector mShakeDetector;
    private DevOptionsConfig mConfig;
    private LogView mLogView;
    private MemorySampleView mMemorySampleView;
    private CpuSampleView mCpuSampleView;
    private FpsSampleView mFpsSampleView;
    private TrafficSampleView mTrafficSampleView;
    private String mCurPageName;
    private ScalpelViewController mScalpelViewController;
    private PerfSampleOverlayView mPerfMonitorOverlayView;
    private ProfileDomView mProfileDomView;
    private InspectorView mInspectorView;
    private NetworkInspectorView mNetworkInspectorView;
    private boolean shown = false;
    private List<DevOption> mExtraOptions = null;
    private VDomController mVdomController;
    private WXSDKInstance mInstance;
    private static final String ACTION_LAUNCH = "action_launch_analyzer";
    public static final String EXTRA_FROM = "from";
    public static final String EXTRA_DEVICE_ID = "deviceId";
    private LaunchUIReceiver mLaunchUIReceiver;

    public WeexDevOptions(@NonNull Context context) {
        this.mContext = context;
        this.mConfig = DevOptionsConfig.getInstance(context);
        this.mPerfMonitorOverlayView = new PerfSampleOverlayView(context);
        this.mProfileDomView = new ProfileDomView(context);
        this.mProfileDomView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setVdomDepthEnabled(false);
                }
            }
        });
        this.mNetworkInspectorView = new NetworkInspectorView(context);
        this.mNetworkInspectorView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setNetworkInspectorEnabled(false);
                }
            }
        });
        this.mNetworkInspectorView.setOnSizeChangedListener(new IResizableView.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(int size) {
                WeexDevOptions.this.mConfig.setNetworkInspectorViewSize(size);
            }
        });
        this.mLogView = new LogView(context);
        this.mLogView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(false);
                }
            }
        });
        this.mLogView.setOnLogConfigChangedListener(new LogView.OnLogConfigChangedListener(){

            @Override
            public void onLogLevelChanged(int level) {
                WeexDevOptions.this.mConfig.setLogLevel(level);
            }

            @Override
            public void onLogFilterChanged(String filterName) {
                WeexDevOptions.this.mConfig.setLogFilter(filterName);
            }
        });
        this.mLogView.setOnSizeChangedListener(new IResizableView.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(int size) {
                WeexDevOptions.this.mConfig.setLogViewSize(size);
            }
        });
        this.mMemorySampleView = new MemorySampleView(context);
        this.mMemorySampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(false);
                }
            }
        });
        this.mCpuSampleView = new CpuSampleView(context);
        this.mCpuSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(false);
                }
            }
        });
        this.mTrafficSampleView = new TrafficSampleView(context);
        this.mTrafficSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(false);
                }
            }
        });
        this.mFpsSampleView = new FpsSampleView(context);
        this.mFpsSampleView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(false);
                }
            }
        });
        this.mInspectorView = new InspectorView(context);
        this.mInspectorView.setOnCloseListener(new IOverlayView.OnCloseListener(){

            @Override
            public void close(IOverlayView host) {
                if (host != null) {
                    WeexDevOptions.this.mConfig.setViewInspectorEnabled(false);
                }
            }
        });
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                LaunchConfig.setFrom(null);
                LaunchConfig.setDeviceId(null);
                WeexDevOptions.this.showDevOptions();
            }
        });
        this.mVdomController = new VDomController(new PollingVDomMonitor(), new StandardVDomMonitor());
        this.mLaunchUIReceiver = new LaunchUIReceiver(new OnLaunchListener(){

            @Override
            public void onLaunch(@NonNull String from, @Nullable String deviceId) {
                LaunchConfig.setFrom(from);
                LaunchConfig.setDeviceId(deviceId);
                WeexDevOptions.this.showDevOptions();
            }
        });
    }

    public static void launchByBroadcast(@NonNull Context context, @NonNull String from, @Nullable String deviceId) {
        Intent intent = new Intent(ACTION_LAUNCH);
        intent.putExtra(EXTRA_FROM, from);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            intent.putExtra(EXTRA_DEVICE_ID, deviceId);
        }
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    private List<DevOption> registerDefaultOptions() {
        ArrayList<DevOption> options = new ArrayList<DevOption>();
        options.add(new DevOption("weex\u6027\u80fd\u6307\u6807", R.drawable.wxt_icon_performance, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mCurPageName == null) {
                    Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)"internal error", (int)0).show();
                    return;
                }
                Performance performance = WXPerfStorage.getInstance().getLatestPerformance(WeexDevOptions.this.mCurPageName);
                List<Performance> list = WXPerfStorage.getInstance().getPerformanceList(WeexDevOptions.this.mCurPageName);
                if (performance == null) {
                    return;
                }
                WXPerformanceAnalysisView view = new WXPerformanceAnalysisView(WeexDevOptions.this.mContext, performance, list);
                view.show();
            }
        }));
        options.add(new DevOption("\u89c6\u56fe\u5ba1\u67e5", R.drawable.wxt_icon_view_inspector, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isViewInspectorEnabled()) {
                    WeexDevOptions.this.mConfig.setViewInspectorEnabled(false);
                    WeexDevOptions.this.mInspectorView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setViewInspectorEnabled(true);
                    WeexDevOptions.this.mInspectorView.show();
                    WeexDevOptions.this.mInspectorView.bindInstance(WeexDevOptions.this.mInstance);
                }
            }
        }, true));
        options.add(new DevOption("\u6e32\u67d3\u6027\u80fd\u5206\u6790", R.drawable.wxt_icon_render_analysis, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isVDomDepthEnabled()) {
                    WeexDevOptions.this.mConfig.setVdomDepthEnabled(false);
                    WeexDevOptions.this.mProfileDomView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setVdomDepthEnabled(true);
                    WeexDevOptions.this.mProfileDomView.show();
                    WeexDevOptions.this.mProfileDomView.bindInstance(WeexDevOptions.this.mInstance);
                }
            }
        }, true));
        options.add(new DevOption("MTOP", R.drawable.wxt_icon_mtop, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isNetworkInspectorEnabled()) {
                    WeexDevOptions.this.mConfig.setNetworkInspectorEnabled(false);
                    WeexDevOptions.this.mNetworkInspectorView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setNetworkInspectorEnabled(true);
                    WeexDevOptions.this.mNetworkInspectorView.setViewSize(WeexDevOptions.this.mConfig.getNetworkInspectorViewSize());
                    WeexDevOptions.this.mNetworkInspectorView.show();
                }
            }
        }, true));
        options.add(new DevOption("weex storage", R.drawable.wxt_icon_storage, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                StorageView mStorageView = new StorageView(WeexDevOptions.this.mContext);
                mStorageView.show();
            }
        }));
        options.add(new DevOption("3d\u89c6\u56fe", R.drawable.wxt_icon_3d_rotation, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mScalpelViewController != null) {
                    WeexDevOptions.this.mScalpelViewController.toggleScalpelEnabled();
                }
            }
        }, true));
        options.add(new DevOption("\u65e5\u5fd7", R.drawable.wxt_icon_log, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isLogOutputEnabled()) {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(false);
                    WeexDevOptions.this.mLogView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setLogOutputEnabled(true);
                    WeexDevOptions.this.mLogView.setLogLevel(WeexDevOptions.this.mConfig.getLogLevel());
                    WeexDevOptions.this.mLogView.setFilterName(WeexDevOptions.this.mConfig.getLogFilter());
                    WeexDevOptions.this.mLogView.setViewSize(WeexDevOptions.this.mConfig.getLogViewSize());
                    WeexDevOptions.this.mLogView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u5185\u5b58", R.drawable.wxt_icon_memory, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isMemoryChartEnabled()) {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(false);
                    WeexDevOptions.this.mMemorySampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setMemoryChartEnabled(true);
                    WeexDevOptions.this.mMemorySampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("CPU", R.drawable.wxt_icon_cpu, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isCPUChartEnabled()) {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(false);
                    WeexDevOptions.this.mCpuSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setCpuChartEnabled(true);
                    WeexDevOptions.this.mCpuSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("fps", R.drawable.wxt_icon_fps, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (!FPSSampler.isSupported()) {
                    Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)"your device is not support.", (int)0).show();
                    return;
                }
                if (WeexDevOptions.this.mConfig.isFpsChartEnabled()) {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(false);
                    WeexDevOptions.this.mFpsSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setFpsChartEnabled(true);
                    WeexDevOptions.this.mFpsSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u6d41\u91cf", R.drawable.wxt_icon_traffic, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isTrafficChartEnabled()) {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(false);
                    WeexDevOptions.this.mTrafficSampleView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setTrafficChartEnabled(true);
                    WeexDevOptions.this.mTrafficSampleView.show();
                }
            }
        }, true));
        options.add(new DevOption("\u7efc\u5408\u6027\u80fd", R.drawable.wxt_icon_multi_performance, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                if (WeexDevOptions.this.mConfig.isPerfCommonEnabled()) {
                    WeexDevOptions.this.mConfig.setPerfCommonEnabled(false);
                    WeexDevOptions.this.mPerfMonitorOverlayView.dismiss();
                } else {
                    WeexDevOptions.this.mConfig.setPerfCommonEnabled(true);
                    WeexDevOptions.this.mPerfMonitorOverlayView.show();
                }
            }
        }, true));
        options.add(new DevOption("js\u8fdc\u7a0b\u8c03\u8bd5", R.drawable.wxt_icon_debug, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                RemoteDebugManager.getInstance().toggle(WeexDevOptions.this.mContext);
            }
        }));
        options.add(new DevOption("\u914d\u7f6e", R.drawable.wxt_icon_settings, new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                SettingsActivity.launch(WeexDevOptions.this.mContext);
            }
        }));
        return options;
    }

    private void showDevOptions() {
        if (this.shown) {
            return;
        }
        if (this.mContext == null) {
            return;
        }
        if (this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing()) {
            return;
        }
        EntranceView.Creator creator = new EntranceView.Creator(this.mContext).injectOptions(this.registerDefaultOptions());
        if (this.mExtraOptions != null && !this.mExtraOptions.isEmpty()) {
            creator.injectOptions(this.mExtraOptions);
        }
        EntranceView e = creator.create();
        e.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                WeexDevOptions.this.shown = false;
            }
        });
        e.show();
        this.shown = true;
    }

    public void registerExtraOption(@NonNull DevOption option) {
        if (this.mExtraOptions == null) {
            this.mExtraOptions = new ArrayList<DevOption>();
        }
        this.mExtraOptions.add(option);
    }

    public void registerExtraOption(@NonNull String optionName, int iconRes, final @NonNull Runnable runnable) {
        DevOption option = new DevOption();
        option.listener = new DevOption.OnOptionClickListener(){

            @Override
            public void onOptionClick() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Log.e((String)"weex-analyzer", (String)e.getMessage());
                }
            }
        };
        option.iconRes = iconRes;
        option.optionName = optionName;
        this.registerExtraOption(option);
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onReceiveTouchEvent(MotionEvent ev) {
        if (ev == null) {
            return;
        }
        if (this.mInspectorView != null && this.mConfig.isViewInspectorEnabled()) {
            this.mInspectorView.receiveTouchEvent(ev);
        }
    }

    @Override
    public void onResume() {
        this.mShakeDetector.start((SensorManager)this.mContext.getSystemService("sensor"));
        LocalBroadcastManager.getInstance((Context)this.mContext).registerReceiver((BroadcastReceiver)this.mLaunchUIReceiver, new IntentFilter(ACTION_LAUNCH));
        if (this.mConfig.isPerfCommonEnabled()) {
            this.mPerfMonitorOverlayView.show();
        } else {
            this.mPerfMonitorOverlayView.dismiss();
        }
        if (this.mConfig.isVDomDepthEnabled()) {
            this.mProfileDomView.show();
            this.mProfileDomView.bindInstance(this.mInstance);
        } else {
            this.mProfileDomView.dismiss();
        }
        if (this.mConfig.isViewInspectorEnabled()) {
            this.mInspectorView.show();
            this.mInspectorView.bindInstance(this.mInstance);
        } else {
            this.mInspectorView.dismiss();
        }
        if (this.mConfig.isNetworkInspectorEnabled()) {
            this.mNetworkInspectorView.setViewSize(this.mConfig.getNetworkInspectorViewSize());
            this.mNetworkInspectorView.show();
        } else {
            this.mNetworkInspectorView.dismiss();
        }
        if (this.mConfig.isLogOutputEnabled()) {
            this.mLogView.setLogLevel(this.mConfig.getLogLevel());
            this.mLogView.setFilterName(this.mConfig.getLogFilter());
            this.mLogView.setViewSize(this.mConfig.getLogViewSize());
            this.mLogView.show();
        } else {
            this.mLogView.dismiss();
        }
        if (this.mConfig.isMemoryChartEnabled()) {
            this.mMemorySampleView.show();
        } else {
            this.mMemorySampleView.dismiss();
        }
        if (this.mConfig.isCPUChartEnabled()) {
            this.mCpuSampleView.show();
        } else {
            this.mCpuSampleView.dismiss();
        }
        if (this.mConfig.isFpsChartEnabled()) {
            this.mFpsSampleView.show();
        } else {
            this.mFpsSampleView.dismiss();
        }
        if (this.mConfig.isTrafficChartEnabled()) {
            this.mTrafficSampleView.show();
        } else {
            this.mTrafficSampleView.dismiss();
        }
        if (this.mScalpelViewController != null) {
            this.mScalpelViewController.resume();
        }
    }

    @Override
    public void onPause() {
        this.mShakeDetector.stop();
        LocalBroadcastManager.getInstance((Context)this.mContext).unregisterReceiver((BroadcastReceiver)this.mLaunchUIReceiver);
        if (this.mConfig.isPerfCommonEnabled()) {
            this.mPerfMonitorOverlayView.dismiss();
        }
        if (this.mConfig.isVDomDepthEnabled()) {
            this.mProfileDomView.dismiss();
        }
        if (this.mConfig.isViewInspectorEnabled()) {
            this.mInspectorView.dismiss();
        }
        if (this.mConfig.isNetworkInspectorEnabled()) {
            this.mNetworkInspectorView.dismiss();
        }
        if (this.mConfig.isLogOutputEnabled()) {
            this.mLogView.dismiss();
        }
        if (this.mConfig.isMemoryChartEnabled()) {
            this.mMemorySampleView.dismiss();
        }
        if (this.mConfig.isFpsChartEnabled()) {
            this.mFpsSampleView.dismiss();
        }
        if (this.mConfig.isCPUChartEnabled()) {
            this.mCpuSampleView.dismiss();
        }
        if (this.mConfig.isTrafficChartEnabled()) {
            this.mTrafficSampleView.dismiss();
        }
        if (this.mScalpelViewController != null) {
            this.mScalpelViewController.pause();
        }
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
        if (this.mVdomController != null) {
            this.mVdomController.destroy();
            this.mVdomController = null;
        }
    }

    @Override
    public void onWeexRenderSuccess(@Nullable WXSDKInstance instance) {
        if (instance == null) {
            return;
        }
        this.mInstance = instance;
        this.mCurPageName = WXPerfStorage.getInstance().savePerformance(instance);
        if (this.mVdomController != null) {
            this.mVdomController.monitor(instance);
        }
        if (this.mProfileDomView != null) {
            this.mProfileDomView.bindInstance(instance);
        }
        if (this.mInspectorView != null) {
            this.mInspectorView.bindInstance(instance);
        }
    }

    @Override
    public View onWeexViewCreated(WXSDKInstance instance, View view) {
        if (instance == null || view == null || view.getContext() == null) {
            return null;
        }
        if (view.getParent() != null) {
            return view;
        }
        this.mScalpelViewController = new ScalpelViewController(this.mContext);
        this.mScalpelViewController.setOnToggleListener(new ScalpelViewController.OnToggleListener(){

            @Override
            public void onToggle(View view, boolean isScalpelEnabled) {
                Toast.makeText((Context)WeexDevOptions.this.mContext, (CharSequence)("3d layer is " + (isScalpelEnabled ? "enabled" : "disabled")), (int)0).show();
            }
        });
        this.mScalpelViewController.setOnDrawViewNameListener(new ScalpelFrameLayout.OnDrawViewNameListener(){

            @Override
            @Nullable
            public String onDrawViewName(@NonNull View view, @NonNull String rawClazzName) {
                for (String name : DevOptionsConfig.WHITE_SCALPEL_VIEW_NAMES) {
                    if (!rawClazzName.equalsIgnoreCase(name)) continue;
                    return rawClazzName;
                }
                return null;
            }
        });
        return this.mScalpelViewController.wrapView(view);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!SDKUtils.isEmulator()) {
            return false;
        }
        if (keyCode == 82) {
            LaunchConfig.setDeviceId(null);
            LaunchConfig.setFrom(null);
            this.showDevOptions();
            return true;
        }
        return false;
    }

    @Override
    public void onException(WXSDKInstance instance, String errCode, String msg) {
        if (this.mConfig != null && this.mConfig.isShownJSException()) {
            try {
                JSExceptionCatcher.catchException(this.mContext, this.mConfig, instance, errCode, msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface OnLaunchListener {
        public void onLaunch(@NonNull String var1, @Nullable String var2);
    }

    static class LaunchUIReceiver
    extends BroadcastReceiver {
        private OnLaunchListener listener;

        public LaunchUIReceiver(@NonNull OnLaunchListener listener) {
            this.listener = listener;
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction() != null && WeexDevOptions.ACTION_LAUNCH.equals(intent.getAction())) {
                String from = intent.getStringExtra(WeexDevOptions.EXTRA_FROM);
                String deviceId = intent.getStringExtra(WeexDevOptions.EXTRA_DEVICE_ID);
                if (this.listener != null && !TextUtils.isEmpty((CharSequence)from)) {
                    this.listener.onLaunch(from, deviceId);
                }
            }
        }
    }
}

