/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.TextView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.VDomTracker;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;

public class VDomDepthSampleView
extends DragSupportOverlayView {
    private SampleTask mTask;

    public VDomDepthSampleView(Context application) {
        super(application);
        this.mWidth = -1;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        return View.inflate((Context)this.mContext, (int)R.layout.wxt_depth_sample_view, null);
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new SampleTask(this.mWholeView);
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
    }

    public void bindInstance(WXSDKInstance instance) {
        if (this.mTask != null) {
            this.mTask.setInstance(instance);
        }
    }

    private static class SampleTask
    extends AbstractLoopTask {
        WXSDKInstance instance;
        TextView resultTextView;

        SampleTask(@NonNull View hostView) {
            super(false);
            this.mDelayMillis = 1000;
            this.resultTextView = (TextView)hostView.findViewById(R.id.result);
        }

        void setInstance(WXSDKInstance instance) {
            this.instance = instance;
        }

        private String convertResult(boolean result) {
            return result ? "\u2713 " : "\u2715 ";
        }

        @Override
        protected void onRun() {
            if (this.instance == null) {
                return;
            }
            VDomTracker tracker = new VDomTracker(this.instance);
            HealthReport report = tracker.traverse();
            if (report == null) {
                return;
            }
            final StringBuilder builder = new StringBuilder();
            builder.append("weex-analyzer\u68c0\u6d4b\u7ed3\u679c:\n");
            builder.append(this.convertResult(report.maxLayer < 14));
            builder.append("\u68c0\u6d4b\u5230VDOM\u6700\u6df1\u5d4c\u5957\u5c42\u7ea7\u4e3a ").append(report.maxLayer + 1).append(",\u5efa\u8bae<14").append("\n");
            if (report.hasScroller) {
                builder.append(this.convertResult(true));
                builder.append("\u68c0\u6d4b\u5230\u8be5\u9875\u9762\u4f7f\u7528\u4e86Scroller,\u957f\u5217\u8868\u5efa\u8bae\u4f7f\u7528ListView").append("\n");
            }
            if (report.hasList) {
                builder.append(this.convertResult(true));
                builder.append("\u68c0\u6d4b\u5230\u8be5\u9875\u9762\u4f7f\u7528\u4e86List,cell\u4e2a\u6570\u4e3a").append(report.cellNum).append("\n");
                builder.append(this.convertResult(!report.hasBigCell));
                if (report.hasBigCell) {
                    builder.append("\u68c0\u6d4b\u5230\u9875\u9762\u53ef\u80fd\u5b58\u5728\u5927cell,\u6700\u5927\u7684cell\u4e2d\u5305\u542b").append(report.maxCellViewNum).append("\u4e2a\u7ec4\u4ef6,\u5efa\u8bae\u6309\u884c\u5408\u7406\u62c6\u5206");
                } else {
                    builder.append("\u7ecf\u68c0\u6d4b\uff0ccell\u5927\u5c0f\u5408\u7406");
                }
            }
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    SampleTask.this.resultTextView.setText((CharSequence)builder.toString());
                }
            });
        }

        @Override
        protected void onStop() {
            this.instance = null;
        }
    }
}

