/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.List;

public class DevOptionsConfig {
    private SharedPreferences mSharedPreferences;
    private static final String DEV_CONFIG_NAME = "weex_dev_config";
    private static final String CONFIG_PERF_COMMON = "config_perf_common";
    private static final String CONFIG_VDOM_DEPTH = "config_vdom_depth";
    private static final String CONFIG_LOG_OUTPUT = "config_log_output";
    private static final String CONFIG_JS_EXCEPTION = "config_js_exception";
    private static final String CONFIG_MEMORY_CHART = "config_mem_chart";
    private static final String CONFIG_FPS_CHART = "config_fps_chart";
    private static final String CONFIG_CPU_CHART = "config_cpu_chart";
    private static final String CONFIG_TRAFFIC_CHART = "config_traffic_chart";
    private static final String CONFIG_LOG_LEVEL = "config_log_level";
    private static final String CONFIG_LOG_FILTER = "config_log_filter";
    private static final String CONFIG_LOG_VIEW_SIZE = "config_log_view_size";
    public static final String TAG = "weex-analyzer";
    public static final List<String> WHITE_SCALPEL_VIEW_NAMES = Arrays.asList("WXRecyclerView", "WXScrollView", "WXFrameLayout");

    public DevOptionsConfig(@NonNull Context context) {
        this.mSharedPreferences = context.getSharedPreferences(DEV_CONFIG_NAME, 0);
    }

    public void setPerfCommonEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_PERF_COMMON, enabled).apply();
    }

    public boolean isPerfCommonEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_PERF_COMMON, false);
    }

    public void setVdomDepthEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_VDOM_DEPTH, enabled).apply();
    }

    public boolean isVDomDepthEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_VDOM_DEPTH, false);
    }

    public void setLogOutputEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_LOG_OUTPUT, enabled).apply();
    }

    public boolean isLogOutputEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_LOG_OUTPUT, false);
    }

    public void setMemoryChartEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_MEMORY_CHART, enabled).apply();
    }

    public boolean isMemoryChartEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_MEMORY_CHART, false);
    }

    public void setCpuChartEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_CPU_CHART, enabled).apply();
    }

    public boolean isCPUChartEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_CPU_CHART, false);
    }

    public void setTrafficChartEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_TRAFFIC_CHART, enabled).apply();
    }

    public boolean isTrafficChartEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_TRAFFIC_CHART, false);
    }

    public void setFpsChartEnabled(boolean enabled) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_FPS_CHART, enabled).apply();
    }

    public boolean isFpsChartEnabled() {
        return this.mSharedPreferences.getBoolean(CONFIG_FPS_CHART, false);
    }

    public void setShownJSException(boolean shown) {
        this.mSharedPreferences.edit().putBoolean(CONFIG_JS_EXCEPTION, shown).apply();
    }

    public boolean isShownJSException() {
        return this.mSharedPreferences.getBoolean(CONFIG_JS_EXCEPTION, true);
    }

    public void setLogLevel(int level) {
        this.mSharedPreferences.edit().putInt(CONFIG_LOG_LEVEL, level).apply();
    }

    public int getLogLevel() {
        return this.mSharedPreferences.getInt(CONFIG_LOG_LEVEL, 2);
    }

    public void setLogFilter(String filter) {
        this.mSharedPreferences.edit().putString(CONFIG_LOG_FILTER, filter).apply();
    }

    public String getLogFilter() {
        return this.mSharedPreferences.getString(CONFIG_LOG_FILTER, null);
    }

    public void setLogViewSize(int size) {
        this.mSharedPreferences.edit().putInt(CONFIG_LOG_VIEW_SIZE, size).apply();
    }

    public int getLogViewSize() {
        return this.mSharedPreferences.getInt(CONFIG_LOG_VIEW_SIZE, 1);
    }
}

