/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class HandlerThreadWrapper {
    private Handler mHandler;
    private HandlerThread mHandlerThread;

    public HandlerThreadWrapper(@NonNull String threadName) {
        this(threadName, null);
    }

    public HandlerThreadWrapper(@NonNull String threadName, @Nullable Handler.Callback callback) {
        this.mHandlerThread = new HandlerThread(threadName);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), callback);
    }

    @NonNull
    public Handler getHandler() {
        return this.mHandler;
    }

    public boolean isAlive() {
        if (this.mHandlerThread == null) {
            return false;
        }
        return this.mHandlerThread.isAlive();
    }

    public void quit() {
        if (this.mHandlerThread != null) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
            }
            this.mHandlerThread.quit();
        }
    }
}

