/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Looper;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.widget.Toast;
import com.taobao.weex.WXSDKEngine;
import java.util.List;

public class SDKUtils {
    private SDKUtils() {
    }

    public static boolean isWXInitialized() {
        return WXSDKEngine.isInitialized();
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static void copyToClipboard(@NonNull Context context, @Nullable String text, boolean allowNotification) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        ClipboardManager manager = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"copied text", (CharSequence)text);
        manager.setPrimaryClip(clip);
        if (allowNotification) {
            Toast.makeText((Context)context, (CharSequence)"copied to clipboard success", (int)0).show();
        }
    }

    public static boolean isDebugMode(@NonNull Context context) {
        boolean isDebug = false;
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDebug;
    }

    public static boolean isHostRunning(@NonNull Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        if (tasks == null || tasks.isEmpty()) {
            return false;
        }
        ComponentName cn = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity;
        if (cn == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)context.getPackageName()) && context.getPackageName().equals(cn.getPackageName());
    }

    public static boolean isInteractive(@NonNull Context context) {
        PowerManager manager = (PowerManager)context.getSystemService("power");
        return manager.isScreenOn();
    }

    public static boolean isInUiThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    @TargetApi(value=23)
    public static boolean canDrawOverlays(@NonNull Context context) {
        return Settings.canDrawOverlays((Context)context);
    }
}

