/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.core;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.analyzer.pojo.HealthReport;
import com.taobao.weex.analyzer.pojo.NodeInfo;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.WXA;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.component.WXEmbed;
import com.taobao.weex.ui.component.WXHeader;
import com.taobao.weex.ui.component.WXImage;
import com.taobao.weex.ui.component.WXInput;
import com.taobao.weex.ui.component.WXLoading;
import com.taobao.weex.ui.component.WXScroller;
import com.taobao.weex.ui.component.WXSlider;
import com.taobao.weex.ui.component.WXSwitch;
import com.taobao.weex.ui.component.WXText;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.WXVideo;
import com.taobao.weex.ui.component.list.HorizontalListComponent;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.ui.view.WXEditText;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VDomTracker {
    private WXSDKInstance mWxInstance;
    private Deque<LayeredVDomNode> mLayeredQueue;
    private ObjectPool<LayeredVDomNode> mObjectPool;
    private static Map<WXComponent, NodeInfo> mCachedMap;
    private static List<WXComponent> mCachedList;
    private static final String TAG = "VDomTracker";
    private static final Map<Class, String> sVDomMap;

    public VDomTracker(@NonNull WXSDKInstance instance) {
        this.mWxInstance = instance;
        this.mLayeredQueue = new ArrayDeque<LayeredVDomNode>();
        this.mObjectPool = new ObjectPool<LayeredVDomNode>(10){

            @Override
            LayeredVDomNode newObject() {
                return new LayeredVDomNode();
            }
        };
    }

    @Nullable
    public HealthReport traverse() {
        if (SDKUtils.isInUiThread()) {
            WXLogUtils.e((String)TAG, (String)"illegal thread...");
            return null;
        }
        WXComponent godComponent = this.mWxInstance.getGodCom();
        if (godComponent == null) {
            WXLogUtils.e((String)TAG, (String)"god component not found");
            return null;
        }
        LayeredVDomNode layeredNode = this.mObjectPool.obtain();
        layeredNode.set(godComponent, this.getComponentName(godComponent), 1);
        this.mLayeredQueue.add(layeredNode);
        if (mCachedMap == null) {
            mCachedMap = new HashMap<WXComponent, NodeInfo>();
        }
        Map<WXComponent, NodeInfo> map = mCachedMap;
        map.clear();
        HealthReport report = new HealthReport(this.mWxInstance.getBundleUrl());
        if (mCachedList == null) {
            mCachedList = new ArrayList<WXComponent>();
        }
        List<WXComponent> cellList = mCachedList;
        cellList.clear();
        while (!this.mLayeredQueue.isEmpty()) {
            NodeInfo nodeInfo;
            LayeredVDomNode domNode = this.mLayeredQueue.removeFirst();
            WXComponent component = domNode.component;
            int layer = domNode.layer;
            if (component instanceof WXListComponent) {
                report.hasList = true;
            }
            if (component instanceof WXScroller) {
                report.hasScroller = true;
            }
            if (component instanceof WXCell) {
                cellList.add(component);
            }
            if ((nodeInfo = map.get(component)) == null) {
                nodeInfo = this.createNode(domNode);
                map.put(component, nodeInfo);
            }
            domNode.clear();
            this.mObjectPool.recycle(domNode);
            if (!(component instanceof WXVContainer)) continue;
            WXVContainer container = (WXVContainer)component;
            int count = container.childCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                LayeredVDomNode childNode = this.mObjectPool.obtain();
                childNode.set(child, this.getComponentName(child), layer + 1);
                report.maxLayer = layer + 1;
                this.mLayeredQueue.add(childNode);
                NodeInfo childNodeInfo = this.createNode(childNode);
                if (nodeInfo.children == null) {
                    nodeInfo.children = new ArrayList<NodeInfo>();
                }
                nodeInfo.children.add(childNodeInfo);
                map.put(child, childNodeInfo);
            }
        }
        NodeInfo tree = map.get(godComponent);
        for (WXComponent com : cellList) {
            boolean isBigCell = false;
            if (com.getHostView() != null) {
                isBigCell = this.isBigCell(com.getHostView().getMeasuredHeight());
            }
            NodeInfo cellNode = map.get(com);
            int viewNum = this.getCellViewNum(cellNode);
            if (isBigCell) {
                WXLogUtils.d((String)TAG, (String)("[warning]please do not use big cell in list component or will cause terrible user experience," + com.getHostView() + "," + cellList.size()));
                WXLogUtils.d((String)TAG, (String)JSON.toJSONString((Object)cellNode, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
            report.maxCellViewNum = Math.max(report.maxCellViewNum, viewNum);
            report.hasBigCell |= isBigCell;
        }
        report.cellNum = cellList.size();
        cellList.clear();
        map.clear();
        report.vdom = tree;
        return report;
    }

    private int getCellViewNum(NodeInfo cellNode) {
        ArrayDeque<NodeInfo> deque = new ArrayDeque<NodeInfo>();
        deque.add(cellNode);
        int viewNum = 0;
        while (!deque.isEmpty()) {
            NodeInfo node = (NodeInfo)deque.removeFirst();
            ++viewNum;
            if (node.children == null || node.children.isEmpty()) continue;
            for (NodeInfo n : node.children) {
                deque.add(n);
            }
        }
        return viewNum;
    }

    private boolean isBigCell(float maxHeight) {
        if (maxHeight <= 0.0f) {
            return false;
        }
        return (double)maxHeight > (double)(WXViewUtils.getScreenHeight() * 2) / 3.0;
    }

    @NonNull
    private String getComponentName(@NonNull WXComponent component) {
        String name = sVDomMap.get(component.getClass());
        return TextUtils.isEmpty((CharSequence)name) ? "component" : name;
    }

    private NodeInfo createNode(@NonNull LayeredVDomNode layeredNode) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.layer = layeredNode.layer;
        nodeInfo.simpleName = layeredNode.simpleName;
        nodeInfo.realName = layeredNode.component.getClass().getName();
        WXDomObject domObject = layeredNode.component.getDomObject();
        WXStyle styles = null;
        if (domObject != null) {
            styles = domObject.getStyles();
        }
        if (styles != null && !styles.isEmpty()) {
            nodeInfo.styles = Collections.unmodifiableMap(styles);
        }
        WXAttr attr = null;
        if (domObject != null) {
            attr = domObject.getAttrs();
        }
        if (attr != null && !attr.isEmpty()) {
            nodeInfo.attrs = Collections.unmodifiableMap(attr);
        }
        return nodeInfo;
    }

    static {
        sVDomMap = new HashMap<Class, String>();
        sVDomMap.put(WXComponent.class, "component");
        sVDomMap.put(WXText.class, "text");
        sVDomMap.put(WXVContainer.class, "container");
        sVDomMap.put(WXDiv.class, "div");
        sVDomMap.put(WXEditText.class, "textarea");
        sVDomMap.put(WXA.class, "a");
        sVDomMap.put(WXInput.class, "input");
        sVDomMap.put(WXLoading.class, "loading");
        sVDomMap.put(WXScroller.class, "scroller");
        sVDomMap.put(WXSwitch.class, "switch");
        sVDomMap.put(WXSlider.class, "slider");
        sVDomMap.put(WXVideo.class, "video");
        sVDomMap.put(WXImage.class, "image");
        sVDomMap.put(WXHeader.class, "header");
        sVDomMap.put(WXEmbed.class, "embed");
        sVDomMap.put(WXListComponent.class, "list");
        sVDomMap.put(HorizontalListComponent.class, "hlist");
        sVDomMap.put(WXCell.class, "cell");
    }

    private static abstract class ObjectPool<T> {
        private final Deque<T> mPool;

        ObjectPool(int capacity) {
            capacity = Math.max(0, capacity);
            this.mPool = new ArrayDeque<T>(capacity);
            for (int i = 0; i < capacity; ++i) {
                this.mPool.add(this.newObject());
            }
        }

        abstract T newObject();

        T obtain() {
            return this.mPool.isEmpty() ? this.newObject() : this.mPool.removeLast();
        }

        void recycle(@NonNull T obj) {
            this.mPool.addLast(obj);
        }
    }

    private static class LayeredVDomNode {
        WXComponent component;
        String simpleName;
        int layer;

        private LayeredVDomNode() {
        }

        void set(WXComponent component, String simpleName, int layer) {
            this.component = component;
            this.layer = layer;
            this.simpleName = simpleName;
        }

        void clear() {
            this.component = null;
            this.layer = -1;
            this.simpleName = null;
        }
    }
}

