/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.taobao.weex.analyzer.view.IOverlayView;

public abstract class AbstractOverlayView
implements IOverlayView {
    protected Context mContext;
    protected WindowManager mWindowManager;
    protected View mWholeView;
    protected boolean isViewAttached;
    protected int mGravity;
    protected int mX;
    protected int mY;
    protected int mWidth;
    protected int mHeight;

    public AbstractOverlayView(Context application) {
        this.mContext = application;
        this.mWindowManager = (WindowManager)application.getSystemService("window");
        this.mGravity = 51;
        this.mY = 0;
        this.mX = 0;
        this.mWidth = -2;
        this.mHeight = -2;
    }

    @Override
    public boolean isViewAttached() {
        return this.isViewAttached;
    }

    @Override
    public void show() {
        try {
            this.mWholeView = this.onCreateView();
            this.onViewCreated(this.mWholeView);
            int w = this.mWidth;
            int h = this.mHeight;
            int flags = 40;
            int type = 2005;
            if (Build.VERSION.SDK_INT < 19) {
                type = 2002;
            }
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(w, h, type, flags, -3);
            layoutParams.gravity = this.mGravity;
            layoutParams.x = this.mX;
            layoutParams.y = this.mY;
            this.mWindowManager.addView(this.mWholeView, (ViewGroup.LayoutParams)layoutParams);
            this.isViewAttached = true;
            this.onShown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NonNull
    protected abstract View onCreateView();

    protected abstract void onShown();

    protected abstract void onDismiss();

    protected void onViewCreated(@NonNull View hostView) {
    }

    protected void onDestroy() {
    }

    @Override
    public void dismiss() {
        try {
            if (this.mWindowManager != null && this.mWholeView != null && this.isViewAttached) {
                this.mWindowManager.removeView(this.mWholeView);
                this.isViewAttached = false;
                this.onDismiss();
            }
            this.onDestroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

