/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.taobao.weex.analyzer.view.IAlertView;

public abstract class AbstractAlertView
extends Dialog
implements IAlertView {
    public AbstractAlertView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.requestFeature(1);
        int layoutId = this.getLayoutResId();
        if (layoutId != 0) {
            this.setContentView(layoutId);
        } else {
            View contentView = this.onCreateView();
            if (contentView != null) {
                this.setContentView(contentView);
            } else {
                throw new IllegalArgumentException("initialize failed.check if you have call onCreateView or getLayoutResId");
            }
        }
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
        if (Build.VERSION.SDK_INT <= 19) {
            window.setType(1000);
        }
        window.setLayout(-1, -1);
        window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.onInitView(window);
    }

    @Override
    public void show() {
        super.show();
        this.onShown();
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(window.getAttributes());
        lp.width = -1;
        lp.height = -1;
        lp.horizontalMargin = 0.0f;
        lp.verticalMargin = 0.0f;
        window.setAttributes(lp);
    }

    @Override
    public void dismiss() {
        super.dismiss();
        this.onDismiss();
    }

    protected abstract void onInitView(@NonNull Window var1);

    @LayoutRes
    protected abstract int getLayoutResId();

    protected void onShown() {
    }

    protected void onDismiss() {
    }

    @Nullable
    protected View onCreateView() {
        return null;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }
}

