/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.MemorySampler;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.DynamicChartViewController;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.chart.TimestampLabelFormatter;

public class MemorySampleView
extends DragSupportOverlayView {
    private DynamicChartViewController mChartViewController;
    private SampleMemoryTask mTask;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public MemorySampleView(Context application) {
        super(application);
        this.mWidth = -1;
        this.mHeight = (int)ViewUtils.dp2px(application, 150);
    }

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    @Override
    @NonNull
    protected View onCreateView() {
        double maxMemory = MemorySampler.maxMemory();
        double totalMemory = MemorySampler.totalMemory();
        double maxY = Math.min(totalMemory * 2.0, maxMemory);
        this.mChartViewController = new DynamicChartViewController.Builder(this.mContext).title(this.mContext.getResources().getString(R.string.wxt_memory)).titleOfAxisX(null).titleOfAxisY("MB").labelColor(-1).backgroundColor(Color.parseColor((String)"#ba000000")).lineColor(Color.parseColor((String)"#BACDDC39")).isFill(true).fillColor(Color.parseColor((String)"#BACDDC39")).numXLabels(5).minX(0.0).maxX(20.0).numYLabels(5).minY(0.0).maxY(ViewUtils.findSuitableVal(maxY, 4)).labelFormatter(new TimestampLabelFormatter()).maxDataPoints(22).build();
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        View chartView = this.mChartViewController.getChartView();
        frameLayout.addView(chartView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView closeBtn = new TextView(this.mContext);
        closeBtn.setTextColor(-1);
        closeBtn.setText((CharSequence)this.mContext.getResources().getString(R.string.wxt_close));
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MemorySampleView.this.mOnCloseListener != null && MemorySampleView.this.isViewAttached) {
                    MemorySampleView.this.mOnCloseListener.close(MemorySampleView.this);
                    MemorySampleView.this.dismiss();
                }
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)ViewUtils.dp2px(this.mContext, 50), (int)ViewUtils.dp2px(this.mContext, 30));
        params.gravity = 5;
        frameLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    @Override
    protected void onShown() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
        }
        this.mTask = new SampleMemoryTask(this.mChartViewController, SDKUtils.isDebugMode(this.mContext));
        this.mTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mTask != null) {
            this.mTask.stop();
            this.mTask = null;
            this.mChartViewController = null;
        }
    }

    private static class SampleMemoryTask
    extends AbstractLoopTask {
        private DynamicChartViewController mController;
        private int mAxisXValue = -1;
        private static final float LOAD_FACTOR = 0.75f;
        private boolean isDebug;

        SampleMemoryTask(@NonNull DynamicChartViewController controller, boolean isDebug) {
            super(false, 1000);
            this.mController = controller;
            this.isDebug = isDebug;
        }

        @Override
        protected void onRun() {
            if (this.mController == null) {
                return;
            }
            ++this.mAxisXValue;
            final double memoryUsed = MemorySampler.getMemoryUsage();
            if (this.isDebug) {
                Log.d((String)"weex-analyzer", (String)("memory usage : " + memoryUsed + "MB"));
            }
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (SampleMemoryTask.this.checkIfNeedUpdateYAxis(memoryUsed)) {
                        SampleMemoryTask.this.mController.updateAxisY(0.0, (SampleMemoryTask.this.mController.getMaxY() - SampleMemoryTask.this.mController.getMinY()) * 2.0, 0);
                    }
                    SampleMemoryTask.this.mController.appendPointAndInvalidate(SampleMemoryTask.this.mAxisXValue, memoryUsed);
                }
            });
        }

        private boolean checkIfNeedUpdateYAxis(double memoryUsed) {
            double currentMaxY = this.mController.getMaxY() - this.mController.getMinY();
            return currentMaxY * 0.75 <= memoryUsed;
        }

        @Override
        protected void onStop() {
            this.mController = null;
        }
    }
}

