/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.AbstractAlertView;
import com.taobao.weex.analyzer.view.DevOption;
import java.util.ArrayList;
import java.util.List;

public class EntranceView
extends AbstractAlertView {
    private RecyclerView mList;
    private List<DevOption> mDevOptions;

    public EntranceView(Context context) {
        super(context);
    }

    @Override
    protected void onInitView(@NonNull Window window) {
        Context context = this.getContext();
        this.mList = (RecyclerView)window.findViewById(R.id.list);
        GridLayoutManager layoutManager = new GridLayoutManager(context, 3, 1, false);
        this.mList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mList.addItemDecoration((RecyclerView.ItemDecoration)new Decoration(Color.parseColor((String)"#e0e0e0"), (int)ViewUtils.dp2px(context, 1), 3));
        this.findViewById(R.id.close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EntranceView.this.dismiss();
            }
        });
    }

    @Override
    protected void onShown() {
        if (this.mDevOptions == null) {
            return;
        }
        List<DevOption> options = this.mDevOptions;
        EntranceViewAdapter adapter = new EntranceViewAdapter(this.getContext(), options);
        this.mList.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.wxt_entrance_layout;
    }

    public void registerDevOption(@Nullable DevOption option) {
        if (option == null) {
            return;
        }
        if (this.mDevOptions == null) {
            this.mDevOptions = new ArrayList<DevOption>();
        }
        this.mDevOptions.add(option);
    }

    public void registerDevOptions(List<DevOption> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        if (this.mDevOptions == null) {
            this.mDevOptions = new ArrayList<DevOption>();
        }
        this.mDevOptions.addAll(options);
    }

    static class Decoration
    extends RecyclerView.ItemDecoration {
        Paint paint;
        int color;
        int size;
        int spanCount;

        Decoration(int color, int size, int spanCount) {
            this.color = color;
            this.size = size;
            this.spanCount = spanCount;
        }

        public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
            super.onDraw(c, parent, state);
            this.createPaint();
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                float dividerLeft = child.getX();
                float dividerRight = child.getX() + (float)child.getWidth();
                float dividerTop = child.getY();
                float dividerBottom = child.getY() + (float)child.getHeight();
                if ((i + 1) % this.spanCount == 1) {
                    c.drawRect(dividerLeft, dividerTop, dividerLeft + (float)this.size, dividerBottom, this.paint);
                }
                c.drawRect(dividerRight - (float)this.size, dividerTop, dividerRight, dividerBottom, this.paint);
                c.drawRect(dividerLeft, dividerTop, dividerRight, dividerTop + (float)this.size, this.paint);
                if (childCount - (i + 1) >= this.spanCount) continue;
                c.drawRect(dividerLeft, dividerBottom, dividerRight, dividerBottom + (float)this.size, this.paint);
            }
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            super.getItemOffsets(outRect, view, parent, state);
        }

        private void createPaint() {
            this.paint = new Paint(1);
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setStrokeWidth((float)this.size);
            this.paint.setColor(this.color);
        }
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView optionName;
        ImageView optionIcon;
        DevOption curOption;

        ViewHolder(View itemView) {
            super(itemView);
            this.optionName = (TextView)itemView.findViewById(R.id.option_name);
            this.optionIcon = (ImageView)itemView.findViewById(R.id.option_icon);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ViewHolder.this.curOption != null && ViewHolder.this.curOption.listener != null) {
                        try {
                            ViewHolder.this.curOption.listener.onOptionClick();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        EntranceView.this.dismiss();
                    }
                }
            });
        }

        void bind(DevOption option) {
            this.curOption = option;
            if (!TextUtils.isEmpty((CharSequence)option.optionName)) {
                this.optionName.setText((CharSequence)option.optionName);
            }
            if (option.iconRes != 0) {
                this.optionIcon.setImageResource(option.iconRes);
            }
        }
    }

    class EntranceViewAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        List<DevOption> mOptions;
        Context mContext;

        EntranceViewAdapter(Context context, List<DevOption> options) {
            this.mOptions = options;
            this.mContext = context;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.wxt_option_item, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.bind(this.mOptions.get(position));
        }

        public int getItemCount() {
            return this.mOptions == null ? 0 : this.mOptions.size();
        }

        public int getItemViewType(int position) {
            return super.getItemViewType(position);
        }
    }

    public static class Creator {
        private List<DevOption> options;
        private Context context;

        public Creator(@NonNull Context context) {
            this.context = context;
            this.options = new ArrayList<DevOption>();
        }

        public Creator injectOptions(List<DevOption> options) {
            this.options.addAll(options);
            return this;
        }

        public Creator injectOption(DevOption option) {
            this.options.add(option);
            return this;
        }

        public EntranceView create() {
            EntranceView entranceView = new EntranceView(this.context);
            entranceView.registerDevOptions(this.options);
            return entranceView;
        }
    }
}

