/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.analyzer.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.taobao.weex.analyzer.R;
import com.taobao.weex.analyzer.core.AbstractLoopTask;
import com.taobao.weex.analyzer.core.CpuSampler;
import com.taobao.weex.analyzer.utils.SDKUtils;
import com.taobao.weex.analyzer.utils.ViewUtils;
import com.taobao.weex.analyzer.view.DragSupportOverlayView;
import com.taobao.weex.analyzer.view.DynamicChartViewController;
import com.taobao.weex.analyzer.view.IOverlayView;
import com.taobao.weex.analyzer.view.chart.TimestampLabelFormatter;

public class CpuSampleView
extends DragSupportOverlayView {
    private SampleCpuTask mSampleCpuTask;
    private DynamicChartViewController mChartViewController;
    private IOverlayView.OnCloseListener mOnCloseListener;

    public void setOnCloseListener(@Nullable IOverlayView.OnCloseListener listener) {
        this.mOnCloseListener = listener;
    }

    public CpuSampleView(Context application) {
        super(application);
        this.mWidth = -1;
        this.mHeight = (int)ViewUtils.dp2px(application, 150);
    }

    @Override
    @NonNull
    protected View onCreateView() {
        int expectMaxCpuUsage = 40;
        this.mChartViewController = new DynamicChartViewController.Builder(this.mContext).title(this.mContext.getResources().getString(R.string.wxt_cpu)).titleOfAxisX(null).titleOfAxisY("cpu(%)").labelColor(-1).backgroundColor(Color.parseColor((String)"#ba000000")).lineColor(Color.parseColor((String)"#BACDDC39")).isFill(true).fillColor(Color.parseColor((String)"#BACDDC39")).numXLabels(5).minX(0.0).maxX(20.0).numYLabels(5).minY(0.0).maxY(expectMaxCpuUsage).labelFormatter(new TimestampLabelFormatter()).maxDataPoints(22).build();
        FrameLayout frameLayout = new FrameLayout(this.mContext);
        View chartView = this.mChartViewController.getChartView();
        frameLayout.addView(chartView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        TextView closeBtn = new TextView(this.mContext);
        closeBtn.setTextColor(-1);
        closeBtn.setText((CharSequence)this.mContext.getResources().getString(R.string.wxt_close));
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CpuSampleView.this.mOnCloseListener != null && CpuSampleView.this.isViewAttached) {
                    CpuSampleView.this.mOnCloseListener.close(CpuSampleView.this);
                    CpuSampleView.this.dismiss();
                }
            }
        });
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)ViewUtils.dp2px(this.mContext, 50), (int)ViewUtils.dp2px(this.mContext, 30));
        params.gravity = 5;
        frameLayout.addView((View)closeBtn, (ViewGroup.LayoutParams)params);
        return frameLayout;
    }

    @Override
    protected void onShown() {
        if (this.mSampleCpuTask != null) {
            this.mSampleCpuTask.stop();
            this.mSampleCpuTask = null;
        }
        this.mSampleCpuTask = new SampleCpuTask(this.mChartViewController, SDKUtils.isDebugMode(this.mContext));
        this.mSampleCpuTask.start();
    }

    @Override
    protected void onDismiss() {
        if (this.mSampleCpuTask != null) {
            this.mSampleCpuTask.stop();
            this.mSampleCpuTask = null;
        }
    }

    private static class SampleCpuTask
    extends AbstractLoopTask {
        private long mTotalCpuTimeLast = 0L;
        private long mPidTotalCpuTimeLast = 0L;
        private long mPidUserCpuTimeLast = 0L;
        private long mPidKernelCpuTimeLast = 0L;
        private int mAxisXValue = -1;
        private DynamicChartViewController mController;
        private boolean isDebug = false;
        private static final float LOAD_FACTOR = 0.75f;

        SampleCpuTask(DynamicChartViewController controller, boolean isDebug) {
            super(false, 1000);
            this.mController = controller;
            this.isDebug = isDebug;
        }

        @Override
        protected void onStart() {
            this.mTotalCpuTimeLast = 0L;
            this.mPidTotalCpuTimeLast = 0L;
            this.mPidUserCpuTimeLast = 0L;
            this.mPidKernelCpuTimeLast = 0L;
        }

        @Override
        protected void onRun() {
            long pidCpuUsage;
            String pidCpuRate = CpuSampler.samplePidCpuRate();
            String totalCpuRate = CpuSampler.sampleCpuRate();
            if (TextUtils.isEmpty((CharSequence)pidCpuRate) || TextUtils.isEmpty((CharSequence)totalCpuRate)) {
                return;
            }
            String[] cpuInfoArray = totalCpuRate.split(" ");
            if (cpuInfoArray.length < 9) {
                return;
            }
            String[] pidCpuInfoList = pidCpuRate.split(" ");
            if (pidCpuInfoList.length < 17) {
                return;
            }
            long user = Long.parseLong(cpuInfoArray[2]);
            long nice = Long.parseLong(cpuInfoArray[3]);
            long system = Long.parseLong(cpuInfoArray[4]);
            long idle = Long.parseLong(cpuInfoArray[5]);
            long ioWait = Long.parseLong(cpuInfoArray[6]);
            long hardIrq = Long.parseLong(cpuInfoArray[7]);
            long softIrq = Long.parseLong(cpuInfoArray[8]);
            long stealTime = Long.parseLong(cpuInfoArray[9]);
            long pidUTime = Long.parseLong(pidCpuInfoList[13]);
            long pidSTime = Long.parseLong(pidCpuInfoList[14]);
            long pidCUTime = Long.parseLong(pidCpuInfoList[15]);
            long pidCSTime = Long.parseLong(pidCpuInfoList[16]);
            long cpuTime = user + nice + system + idle + ioWait + hardIrq + softIrq + stealTime;
            long pidCpuTime = pidUTime + pidSTime + pidCUTime + pidCSTime;
            if (this.mTotalCpuTimeLast != 0L) {
                pidCpuUsage = (pidCpuTime - this.mPidTotalCpuTimeLast) * 100L / (cpuTime - this.mTotalCpuTimeLast);
                long pidUserCpuUsage = (pidUTime - this.mPidUserCpuTimeLast) * 100L / (cpuTime - this.mTotalCpuTimeLast);
                long pidKernelCpuUsage = (pidSTime - this.mPidKernelCpuTimeLast) * 100L / (cpuTime - this.mTotalCpuTimeLast);
                if (this.isDebug) {
                    Log.d((String)"weex-analyzer", (String)("cpu usage:" + pidCpuUsage + "% [user " + pidUserCpuUsage + ",kernel " + pidKernelCpuUsage + "]"));
                }
            } else {
                pidCpuUsage = 0L;
            }
            ++this.mAxisXValue;
            this.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (SampleCpuTask.this.checkIfNeedUpdateYAxis(pidCpuUsage)) {
                        SampleCpuTask.this.mController.updateAxisY(SampleCpuTask.this.mController.getMinY(), Math.max(100.0, SampleCpuTask.this.mController.getMaxY() - SampleCpuTask.this.mController.getMinY() + 10.0), 0);
                    }
                    SampleCpuTask.this.mController.appendPointAndInvalidate(SampleCpuTask.this.mAxisXValue, pidCpuUsage);
                }
            });
            this.mTotalCpuTimeLast = cpuTime;
            this.mPidTotalCpuTimeLast = pidCpuTime;
            this.mPidUserCpuTimeLast = pidUTime;
            this.mPidKernelCpuTimeLast = pidSTime;
        }

        private boolean checkIfNeedUpdateYAxis(double cpuUsage) {
            double currentMaxY = this.mController.getMaxY() - this.mController.getMinY();
            return currentMaxY * 0.75 <= cpuUsage;
        }

        @Override
        protected void onStop() {
            this.mTotalCpuTimeLast = 0L;
            this.mPidTotalCpuTimeLast = 0L;
            this.mPidUserCpuTimeLast = 0L;
            this.mPidKernelCpuTimeLast = 0L;
        }
    }
}

