/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.android.dexposed;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.taobao.android.dexposed.DeviceCheck;
import com.taobao.android.dexposed.XC_MethodHook;
import com.taobao.android.dexposed.XC_MethodReplacement;
import com.taobao.android.dexposed.XposedHelpers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DexposedBridge {
    private static final int RUNTIME_UNKNOW = 0;
    private static final int RUNTIME_DALVIK = 1;
    private static final int RUNTIME_ART = 2;
    private static int runtime = 0;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static final ClassLoader BOOTCLASSLOADER = ClassLoader.getSystemClassLoader();
    private static final Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> hookedMethodCallbacks = new HashMap<Member, CopyOnWriteSortedSet<XC_MethodHook>>();
    private static final ArrayList<XC_MethodHook.Unhook> allUnhookCallbacks = new ArrayList();

    private static int getRuntime() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        if (Build.VERSION.SDK_INT >= 20) {
            String vm = System.getProperty("persist.sys.dalvik.vm.lib", "");
            if (vm.contains("art")) {
                return 2;
            }
            return 1;
        }
        return 1;
    }

    public static synchronized void log(String text) {
        DexposedBridge.log(text);
    }

    public static synchronized void log(Throwable t) {
        DexposedBridge.log(Log.getStackTraceString((Throwable)t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XC_MethodHook.Unhook hookMethod(Member hookMethod, XC_MethodHook callback) {
        CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        if (!(hookMethod instanceof Method) && !(hookMethod instanceof Constructor)) {
            throw new IllegalArgumentException("only methods and constructors can be hooked");
        }
        boolean newMethod = false;
        Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> map = hookedMethodCallbacks;
        synchronized (map) {
            callbacks = hookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                callbacks = new CopyOnWriteSortedSet();
                hookedMethodCallbacks.put(hookMethod, callbacks);
                newMethod = true;
            }
        }
        callbacks.add(callback);
        if (newMethod) {
            Class<?> returnType;
            Class[] parameterTypes;
            int slot;
            Class<?> declaringClass = hookMethod.getDeclaringClass();
            if (runtime == 0) {
                runtime = DexposedBridge.getRuntime();
            }
            int n = slot = runtime == 1 ? XposedHelpers.getIntField(hookMethod, "slot") : 0;
            if (hookMethod instanceof Method) {
                parameterTypes = ((Method)hookMethod).getParameterTypes();
                returnType = ((Method)hookMethod).getReturnType();
            } else {
                parameterTypes = ((Constructor)hookMethod).getParameterTypes();
                returnType = null;
            }
            AdditionalHookInfo additionalInfo = new AdditionalHookInfo(callbacks, parameterTypes, returnType);
            DexposedBridge.hookMethodNative(hookMethod, declaringClass, slot, additionalInfo);
        }
        XC_MethodHook xC_MethodHook = callback;
        xC_MethodHook.getClass();
        return new XC_MethodHook.Unhook(xC_MethodHook, hookMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhookMethod(Member hookMethod, XC_MethodHook callback) {
        CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        Map<Member, CopyOnWriteSortedSet<XC_MethodHook>> map = hookedMethodCallbacks;
        synchronized (map) {
            callbacks = hookedMethodCallbacks.get(hookMethod);
            if (callbacks == null) {
                return;
            }
        }
        callbacks.remove(callback);
    }

    public static Set<XC_MethodHook.Unhook> hookAllMethods(Class<?> hookClass, String methodName, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Method method : hookClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            unhooks.add(DexposedBridge.hookMethod(method, callback));
        }
        return unhooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XC_MethodHook.Unhook findAndHookMethod(Class<?> clazz, String methodName, Object ... parameterTypesAndCallback) {
        if (parameterTypesAndCallback.length == 0 || !(parameterTypesAndCallback[parameterTypesAndCallback.length - 1] instanceof XC_MethodHook)) {
            throw new IllegalArgumentException("no callback defined");
        }
        XC_MethodHook callback = (XC_MethodHook)parameterTypesAndCallback[parameterTypesAndCallback.length - 1];
        Method m = XposedHelpers.findMethodExact(clazz, methodName, parameterTypesAndCallback);
        XC_MethodHook.Unhook unhook = DexposedBridge.hookMethod(m, callback);
        if (!(callback instanceof XC_MethodHook.XC_MethodKeepHook) && !(callback instanceof XC_MethodReplacement.XC_MethodKeepReplacement)) {
            ArrayList<XC_MethodHook.Unhook> arrayList = allUnhookCallbacks;
            synchronized (arrayList) {
                allUnhookCallbacks.add(unhook);
            }
        }
        return unhook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhookAllMethods() {
        ArrayList<XC_MethodHook.Unhook> arrayList = allUnhookCallbacks;
        synchronized (arrayList) {
            for (int i = 0; i < allUnhookCallbacks.size(); ++i) {
                allUnhookCallbacks.get(i).unhook();
            }
            allUnhookCallbacks.clear();
        }
    }

    public static Set<XC_MethodHook.Unhook> hookAllConstructors(Class<?> hookClass, XC_MethodHook callback) {
        HashSet<XC_MethodHook.Unhook> unhooks = new HashSet<XC_MethodHook.Unhook>();
        for (Constructor<?> constructor : hookClass.getDeclaredConstructors()) {
            unhooks.add(DexposedBridge.hookMethod(constructor, callback));
        }
        return unhooks;
    }

    private static Object handleHookedMethod(Member method, int originalMethodId, Object additionalInfoObj, Object thisObject, Object[] args) throws Throwable {
        AdditionalHookInfo additionalInfo = (AdditionalHookInfo)additionalInfoObj;
        Object[] callbacksSnapshot = additionalInfo.callbacks.getSnapshot();
        int callbacksLength = callbacksSnapshot.length;
        if (callbacksLength == 0) {
            try {
                return DexposedBridge.invokeOriginalMethodNative(method, originalMethodId, additionalInfo.parameterTypes, additionalInfo.returnType, thisObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        XC_MethodHook.MethodHookParam param = new XC_MethodHook.MethodHookParam();
        param.method = method;
        param.thisObject = thisObject;
        param.args = args;
        int beforeIdx = 0;
        do {
            try {
                ((XC_MethodHook)callbacksSnapshot[beforeIdx]).beforeHookedMethod(param);
            }
            catch (Throwable t) {
                DexposedBridge.log(t);
                param.setResult(null);
                param.returnEarly = false;
                continue;
            }
            if (!param.returnEarly) continue;
            ++beforeIdx;
            break;
        } while (++beforeIdx < callbacksLength);
        if (!param.returnEarly) {
            try {
                param.setResult(DexposedBridge.invokeOriginalMethodNative(method, originalMethodId, additionalInfo.parameterTypes, additionalInfo.returnType, param.thisObject, param.args));
            }
            catch (InvocationTargetException e) {
                param.setThrowable(e.getCause());
            }
        }
        int afterIdx = beforeIdx - 1;
        do {
            Object lastResult = param.getResult();
            Throwable lastThrowable = param.getThrowable();
            try {
                ((XC_MethodHook)callbacksSnapshot[afterIdx]).afterHookedMethod(param);
            }
            catch (Throwable t) {
                DexposedBridge.log(t);
                if (lastThrowable == null) {
                    param.setResult(lastResult);
                    continue;
                }
                param.setThrowable(lastThrowable);
            }
        } while (--afterIdx >= 0);
        if (param.hasThrowable()) {
            throw param.getThrowable();
        }
        return param.getResult();
    }

    public static synchronized boolean canDexposed(Context context) {
        if (!DeviceCheck.isDeviceSupport(context)) {
            return false;
        }
        return DexposedBridge.loadDexposedLib(context);
    }

    private static boolean loadDexposedLib(Context context) {
        try {
            if (Build.VERSION.SDK_INT > 19 && Build.VERSION.SDK_INT < 21) {
                System.loadLibrary("dexposed_l");
            } else if (Build.VERSION.SDK_INT > 14) {
                System.loadLibrary("dexposed");
            } else {
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static native Object invokeSuperNative(Object var0, Object[] var1, Member var2, Class<?> var3, Class<?>[] var4, Class<?> var5, int var6) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public static Object invokeSuper(Object obj, Member method, Object ... args) throws NoSuchFieldException {
        try {
            if (runtime == 0) {
                runtime = DexposedBridge.getRuntime();
            }
            int slot = 0;
            if (runtime == 1) {
                Method m = XposedHelpers.findMethodExact(obj.getClass().getSuperclass(), method.getName(), ((Method)method).getParameterTypes());
                slot = XposedHelpers.getIntField(m, "slot");
            }
            return DexposedBridge.invokeSuperNative(obj, args, method, method.getDeclaringClass(), ((Method)method).getParameterTypes(), ((Method)method).getReturnType(), slot);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new XposedHelpers.InvocationTargetError(e.getCause());
        }
    }

    private static synchronized native void hookMethodNative(Member var0, Class<?> var1, int var2, Object var3);

    private static native Object invokeOriginalMethodNative(Member var0, int var1, Class<?>[] var2, Class<?> var3, Object var4, Object[] var5) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public static Object invokeOriginalMethod(Member method, Object thisObject, Object[] args) throws NullPointerException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> returnType;
        Class<?>[] parameterTypes;
        if (args == null) {
            args = EMPTY_ARRAY;
        }
        if (method instanceof Method) {
            parameterTypes = ((Method)method).getParameterTypes();
            returnType = ((Method)method).getReturnType();
        } else if (method instanceof Constructor) {
            parameterTypes = ((Constructor)method).getParameterTypes();
            returnType = null;
        } else {
            throw new IllegalArgumentException("method must be of type Method or Constructor");
        }
        return DexposedBridge.invokeOriginalMethodNative(method, 0, parameterTypes, returnType, thisObject, args);
    }

    private static class AdditionalHookInfo {
        final CopyOnWriteSortedSet<XC_MethodHook> callbacks;
        final Class<?>[] parameterTypes;
        final Class<?> returnType;

        private AdditionalHookInfo(CopyOnWriteSortedSet<XC_MethodHook> callbacks, Class<?>[] parameterTypes, Class<?> returnType) {
            this.callbacks = callbacks;
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }
    }

    public static class CopyOnWriteSortedSet<E> {
        private volatile transient Object[] elements = DexposedBridge.access$100();

        public synchronized boolean add(E e) {
            int index = this.indexOf(e);
            if (index >= 0) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length + 1];
            System.arraycopy(this.elements, 0, newElements, 0, this.elements.length);
            newElements[this.elements.length] = e;
            Arrays.sort(newElements);
            this.elements = newElements;
            return true;
        }

        public synchronized boolean remove(E e) {
            int index = this.indexOf(e);
            if (index == -1) {
                return false;
            }
            Object[] newElements = new Object[this.elements.length - 1];
            System.arraycopy(this.elements, 0, newElements, 0, index);
            System.arraycopy(this.elements, index + 1, newElements, index, this.elements.length - index - 1);
            this.elements = newElements;
            return true;
        }

        public synchronized void clear() {
            this.elements = EMPTY_ARRAY;
        }

        private int indexOf(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!o.equals(this.elements[i])) continue;
                return i;
            }
            return -1;
        }

        public Object[] getSnapshot() {
            return this.elements;
        }
    }
}

