/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk.wifi;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.tamoco.sdk.DataRepositories;
import com.tamoco.sdk.JobDispatcher;
import com.tamoco.sdk.NotificationUtils;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.StoredWifi;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TamocoRequestCallback;
import com.tamoco.sdk.WifiEntity;
import com.tamoco.sdk.WifiState;
import com.tamoco.sdk.wifi.WifiBroadcast;
import com.tamoco.sdk.wifi.WifiJobService;
import com.tamoco.sdk.wifi.WifiTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

class a {
    private static a a;
    private ExecutorService b;
    private PreferencesManager c;
    private DataRepositories d;
    private JobDispatcher e;
    private AtomicBoolean f = new AtomicBoolean(false);

    private a() {
    }

    static synchronized a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    void a(@NonNull PreferencesManager preferencesManager, @NonNull DataRepositories dataRepositories, @NonNull JobDispatcher jobDispatcher, @NonNull ExecutorService executorService) {
        this.c = preferencesManager;
        this.d = dataRepositories;
        this.e = jobDispatcher;
        this.b = executorService;
    }

    void b() {
        if (this.c != null && this.e != null) {
            this.e.scheduleRecurringJob("wifi-scan-recurring", WifiJobService.class, null, this.c.getWifiScanInterval());
        }
    }

    void c() {
        if (this.e != null) {
            this.e.dispatchImmediateJob("wifi-scan", WifiJobService.class, null);
        }
    }

    void d() {
        if (this.e != null) {
            this.e.cancelJob("wifi-scan-recurring");
        }
    }

    void a(final @NonNull Context context, final @Nullable WifiInfo wifiInfo, final @Nullable List<ScanResult> list) {
        if (this.b != null) {
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    if (!a.this.f.get()) {
                        TamocoLog.d("WifiScanner", "Processing scan results");
                        a.this.f.set(true);
                        if (wifiInfo != null) {
                            a.this.a(context, wifiInfo);
                        }
                        if (list != null && !list.isEmpty()) {
                            a.this.a(context, list);
                        }
                        a.this.f.set(false);
                        TamocoLog.d("WifiScanner", "Finished processing scan results");
                    }
                }
            });
        }
    }

    @WorkerThread
    private void a(@NonNull Context context, @NonNull List<ScanResult> list) {
        TamocoLog.d("WifiScanner", "Processing " + list.size() + " wifi networks");
        if (this.d != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.a(context, list, arrayList);
            this.b(context, arrayList);
        }
    }

    @WorkerThread
    private void a(@NonNull Context context, @NonNull List<ScanResult> list, List<String> list2) {
        for (ScanResult scanResult : list) {
            String string = scanResult.SSID;
            String string2 = scanResult.BSSID;
            if (string == null) continue;
            list2.add(string);
            StoredWifi storedWifi = this.a(string, string2);
            if (storedWifi != null && storedWifi.entity != null) {
                WifiState wifiState = storedWifi.getEntityState();
                boolean bl = false;
                Integer n2 = 0;
                long l2 = System.currentTimeMillis();
                if (wifiState.getProximityStatus() == 0 || wifiState.getProximityStatus() == 30) {
                    n2 = 31;
                    bl = true;
                } else if (wifiState.getProximityStatus() == 31 && this.a(storedWifi.entity, storedWifi.state)) {
                    n2 = 32;
                    bl = true;
                    wifiState.setDwellReported(true);
                    l2 = storedWifi.state.getProximityStatusTimestamp() + this.a(storedWifi.entity);
                }
                if (bl) {
                    boolean bl2;
                    wifiState.setScanValues(scanResult);
                    wifiState.setLastEvent(n2);
                    wifiState.setLastEventTimeStamp(l2);
                    boolean bl3 = bl2 = wifiState.getProximityStatus() != 31;
                    if (bl2) {
                        wifiState.setProximityStatus(31);
                        wifiState.setProximityStatusTimestamp(System.currentTimeMillis());
                    }
                    this.d.inventory().updateWifiState(wifiState);
                    this.a(context, storedWifi);
                }
            }
            this.d.inventory().reportWifiAroundMe(context, scanResult);
        }
    }

    @WorkerThread
    private void b(@NonNull Context context, List<String> list) {
        List<StoredWifi> list2 = this.d.inventory().getWifisNotScanned(31, list);
        for (StoredWifi storedWifi : list2) {
            if (storedWifi.entity == null) continue;
            WifiState wifiState = storedWifi.getEntityState();
            wifiState.setLastEvent(33);
            wifiState.setLastEventTimeStamp(System.currentTimeMillis());
            wifiState.setProximityStatus(30);
            wifiState.setProximityStatusTimestamp(System.currentTimeMillis());
            wifiState.setDwellReported(false);
            this.d.inventory().updateWifiState(wifiState);
            this.a(context, storedWifi);
        }
    }

    private boolean a(@NonNull WifiEntity wifiEntity, @NonNull WifiState wifiState) {
        long l2 = this.a(wifiEntity);
        return !wifiState.isDwellReported() && wifiState.getProximityStatus() == 31 && System.currentTimeMillis() - wifiState.getProximityStatusTimestamp() >= l2;
    }

    private long a(@NonNull WifiEntity wifiEntity) {
        return wifiEntity.getDwellMillis() > 0L ? wifiEntity.getDwellMillis() : this.c.getDefaultWifiDwellDelay();
    }

    @WorkerThread
    private StoredWifi a(String string, String string2) {
        StoredWifi storedWifi = null;
        List<StoredWifi> list = this.d.inventory().getWifiBySSid(string);
        for (StoredWifi storedWifi2 : list) {
            if (storedWifi2.entity == null) continue;
            if (string2 != null && (string2.equals(storedWifi2.entity.getMac()) || storedWifi2.state != null && string2.equals(storedWifi2.state.getScannedMac()))) {
                return storedWifi2;
            }
            storedWifi = storedWifi2;
        }
        return storedWifi;
    }

    @WorkerThread
    private void a(@NonNull Context context, @NonNull WifiInfo wifiInfo) {
        TamocoLog.d("WifiScanner", "Connected to wifi:" + wifiInfo.getSSID());
        if (this.d != null) {
            String string = wifiInfo.getSSID();
            if (string == null || "<unknown ssid>".equals(wifiInfo.getSSID())) {
                this.a(context);
            } else {
                StoredWifi storedWifi = this.a(string.replace("\"", ""), wifiInfo.getBSSID());
                if (storedWifi != null) {
                    if (storedWifi.state == null || storedWifi.state.getConnectionStatus() != 2) {
                        WifiState wifiState = storedWifi.getEntityState();
                        wifiState.setConnectionStatus(2);
                        wifiState.setLastEvent(34);
                        wifiState.setLastEventTimeStamp(System.currentTimeMillis());
                        this.d.inventory().updateWifiState(wifiState);
                        this.a(context, storedWifi);
                    }
                } else {
                    this.a(context);
                }
            }
        }
    }

    @WorkerThread
    private void a(@NonNull Context context) {
        List<StoredWifi> list = this.d.inventory().getWifiByStatus(2);
        for (StoredWifi storedWifi : list) {
            if (storedWifi.entity == null) continue;
            WifiState wifiState = storedWifi.getEntityState();
            wifiState.setConnectionStatus(1);
            wifiState.setLastEvent(35);
            wifiState.setLastEventTimeStamp(System.currentTimeMillis());
            this.d.inventory().updateWifiState(wifiState);
            this.a(context, storedWifi);
        }
    }

    @WorkerThread
    private void a(Context context, @NonNull StoredWifi storedWifi) {
        WifiBroadcast.a(context, new WifiTrigger(storedWifi.entity, storedWifi.state));
        this.a(context, storedWifi.entity, storedWifi.state);
        this.d.hits().trackWifiHit(context, storedWifi);
    }

    private void a(@NonNull Context context, @NonNull WifiEntity wifiEntity, @NonNull WifiState wifiState) {
        String string = "Unknown";
        switch (wifiState.getLastEvent()) {
            case 31: {
                string = "Enter";
                break;
            }
            case 32: {
                string = "Dwell";
                break;
            }
            case 33: {
                string = "Exit";
                break;
            }
            case 34: {
                string = "Connect";
                break;
            }
            case 35: {
                string = "Disconnect";
            }
        }
        this.a(context, wifiEntity, string);
    }

    private void a(@NonNull Context context, @NonNull WifiEntity wifiEntity, @NonNull String string) {
        TamocoLog.d("WifiScanner", "Wifi update: " + string + ": " + wifiEntity.getName());
        int n2 = (int)System.currentTimeMillis();
        NotificationUtils.showDebugNotification(context, n2, "Wifi Trigger Hit", String.format(Locale.UK, "%s : %s", string, wifiEntity.getName()));
    }

    void a(final @NonNull TamocoRequestCallback<List<WifiTrigger>> tamocoRequestCallback) {
        if (this.b != null) {
            final Handler handler = new Handler();
            this.b.submit(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<WifiTrigger> arrayList = new ArrayList<WifiTrigger>();
                    List<StoredWifi> list = a.this.d.inventory().getWifiNetworks();
                    if (list != null) {
                        for (StoredWifi storedWifi : list) {
                            arrayList.add(new WifiTrigger(storedWifi.entity, storedWifi.state));
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            tamocoRequestCallback.onResult(arrayList);
                        }
                    });
                }
            });
        } else {
            tamocoRequestCallback.onResult(null);
        }
    }

    ExecutorService e() {
        return this.b != null ? this.b : Executors.newSingleThreadExecutor();
    }
}

