/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.ProcessLifecycleOwner;
import android.arch.persistence.room.Room;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.LocalBroadcastManager;
import com.firebase.jobdispatcher.Driver;
import com.firebase.jobdispatcher.FirebaseJobDispatcher;
import com.firebase.jobdispatcher.GooglePlayDriver;
import com.google.android.gms.location.ActivityTransitionEvent;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingClient;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.tamoco.sdk.ActivityRecognitionManager;
import com.tamoco.sdk.AdvertisingIdentifierWrapper;
import com.tamoco.sdk.AroundMeJobService;
import com.tamoco.sdk.DataRepositories;
import com.tamoco.sdk.HitsUploadJobService;
import com.tamoco.sdk.InventoryUpdateJobService;
import com.tamoco.sdk.InventoryUpdateReceiver;
import com.tamoco.sdk.JobDispatcher;
import com.tamoco.sdk.Kit;
import com.tamoco.sdk.LifecycleListener;
import com.tamoco.sdk.LocalDatabase;
import com.tamoco.sdk.LocationsUploadJobService;
import com.tamoco.sdk.NotificationUtils;
import com.tamoco.sdk.PermissionUtils;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.RemoteSettingsJobService;
import com.tamoco.sdk.ScanningKit;
import com.tamoco.sdk.TamocoConfig;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TamocoRequestCallback;
import com.tamoco.sdk.WakeupGeofence;
import com.tamoco.sdk.a;
import com.tamoco.sdk.anrwatchdogs.ANRError;
import com.tamoco.sdk.anrwatchdogs.ANRWatchDog;
import com.tamoco.sdk.f;
import com.tamoco.sdk.i;
import com.tamoco.sdk.j;
import com.tamoco.sdk.n;
import com.tamoco.sdk.o;
import com.tamoco.sdk.p;
import com.tamoco.sdk.q;
import com.tamoco.sdk.t;
import io.sentry.Sentry;
import io.sentry.SentryClientFactory;
import io.sentry.android.AndroidSentryClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class v {
    private Map<Class<? extends Kit>, Kit> a;
    private DataRepositories b;
    private JobDispatcher c;
    private ExecutorService d;
    private q e;
    private ActivityRecognitionManager f;
    private PreferencesManager g;
    private GeofencingClient h;
    private a i;

    v(@NonNull Context context, @Nullable TamocoConfig tamocoConfig) {
        this.g = new t(context);
        if (tamocoConfig != null) {
            TamocoLog.setEnabled(tamocoConfig.b());
            this.g.setForegroundOnly(tamocoConfig.c());
            this.g.setStopped(!tamocoConfig.isStartImmediately());
            this.g.setCrashReportingEnabled(true);
            this.a = new HashMap<Class<? extends Kit>, Kit>();
            if (tamocoConfig.a() != null) {
                for (Kit object2 : tamocoConfig.a()) {
                    this.a.put(object2.getClass(), object2);
                }
            }
        }
        this.i = this.h(context);
        Kit[] kitArray = (Kit[])Room.databaseBuilder((Context)context, LocalDatabase.class, (String)"tamoco-db").fallbackToDestructiveMigration().build();
        f f2 = new f(context);
        this.e = new q(context);
        this.f = new ActivityRecognitionManager(context);
        n n2 = new n(this.i.a(), (LocalDatabase)kitArray, f2, this.e, this.g);
        o o2 = new o(this.i.a(), (LocalDatabase)kitArray, f2, this.e, this.g);
        this.b = new i(n2, o2);
        FirebaseJobDispatcher firebaseJobDispatcher = new FirebaseJobDispatcher((Driver)new GooglePlayDriver(context));
        this.c = new p(firebaseJobDispatcher);
        this.d = Executors.newFixedThreadPool(3);
        this.h = LocationServices.getGeofencingClient((Context)context);
        this.i(context);
    }

    private a h(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            int n2 = bundle.getInt("com.tamoco.APP_ID");
            String string = bundle.getString("com.tamoco.APP_SECRET");
            if (n2 != 0 && string != null) {
                return new a(String.valueOf(n2), string);
            }
            TamocoLog.w("Tamoco", "Invalid SDK credentials. Make sure com.tamoco.APP_ID and com.tamoco.APP_SECRET meta-data are correctly set in your Manifest.xml.");
            return new a("", "");
        }
        catch (PackageManager.NameNotFoundException | NullPointerException throwable) {
            TamocoLog.e("Tamoco", "Unable to retrieve appId and appSecret", throwable);
            return new a("", "");
        }
    }

    private void i(final Context context) {
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                AdvertisingIdentifierWrapper.init(context);
            }
        });
    }

    String a() {
        return this.g.getCustomId();
    }

    String b() {
        return this.g.getConsentString();
    }

    Integer c() {
        return this.g.getConsentStatus();
    }

    void a(@NonNull String string) {
        this.g.setCustomId(string);
    }

    ExecutorService d() {
        return this.d != null ? this.d : Executors.newSingleThreadExecutor();
    }

    boolean e() {
        return this.g.isStopped();
    }

    void a(@NonNull Context context) {
        if (!this.g.isStopped()) {
            this.g.setStopped(true);
            this.j(context);
            this.c.cancelAllJobs();
            Context context2 = context.getApplicationContext();
            this.o(context2);
            this.q(context2);
            this.x(context2);
        }
    }

    private void j(@NonNull Context context) {
        for (Kit kit : this.q()) {
            if (!(kit instanceof ScanningKit)) continue;
            ((ScanningKit)kit).stopScanning(context);
        }
    }

    void b(@NonNull Context context) {
        if (this.g.isStopped()) {
            this.g.setStopped(false);
            this.l();
            this.k(context);
            if (this.g.isFirstOpen()) {
                this.j();
            }
        }
    }

    private void k(@NonNull Context context) {
        for (Kit kit : this.q()) {
            if (!(kit instanceof ScanningKit)) continue;
            ((ScanningKit)kit).startScanning(context);
        }
    }

    boolean c(@NonNull Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    String[] a(Activity activity) {
        return this.a(activity, new String[0]);
    }

    String[] a(Activity activity, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray) {
            if (PermissionUtils.hasPermission((Context)activity, string)) continue;
            hashSet.add(string);
        }
        String string = "android.permission.ACCESS_FINE_LOCATION";
        if (!PermissionUtils.hasPermission((Context)activity, string)) {
            hashSet.add(string);
        }
        if (hashSet.size() > 0) {
            String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
            ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray2, (int)1992);
            return stringArray2;
        }
        return new String[0];
    }

    void a(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        if (n2 == 1992) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!"android.permission.ACCESS_FINE_LOCATION".equals(stringArray[i2]) || i2 >= nArray.length || nArray[i2] != 0) continue;
                this.p();
                break;
            }
        }
    }

    void d(@NonNull Context context) {
        this.l(context);
        this.s(context);
        this.m(context);
    }

    private void l(@NonNull Context context) {
        boolean bl = true;
        boolean bl2 = this.g.isCrashReportingEnabled();
        if (bl2 && Build.VERSION.SDK_INT >= 19) {
            Object object;
            PackageManager packageManager = context.getPackageManager();
            String string = "unknwown_package";
            try {
                string = packageManager.getPackageInfo((String)context.getPackageName(), (int)0).packageName;
            }
            catch (Exception exception) {
                string = "unknwownPackage";
                exception.printStackTrace();
            }
            if (bl) {
                object = "https://0fe6bb2d5e6043f6b81da7c79c9489fa@sentry.io/1553008?uncaught.handler.enabled=false&environment=".concat(string);
                Sentry.init((String)object, (SentryClientFactory)new AndroidSentryClientFactory(context));
            } else {
                object = "https://aef1da8b35794bc38987bc3fea7aa991@sentry.io/1553011?uncaught.handler.enabled=false&environment=".concat(string);
                Sentry.init((String)object, (SentryClientFactory)new AndroidSentryClientFactory(context));
            }
            object = new j(context);
            ((j)object).a(Thread.getDefaultUncaughtExceptionHandler());
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)object);
            new ANRWatchDog().setIgnoreDebugger(true).setReportMainThreadOnly().setANRListener(new ANRWatchDog.ANRListener((j)object){
                final /* synthetic */ j a;
                {
                    this.a = j2;
                }

                @Override
                public void onAppNotResponding(ANRError error) {
                    this.a.a(Thread.currentThread(), error, true);
                }
            }).start();
        }
    }

    private void m(@NonNull Context context) {
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)new LifecycleListener(context));
    }

    private void n(@NonNull Context context) {
        this.e.a(context, this.g.getLocationUpdateInterval());
    }

    private void o(@NonNull Context context) {
        this.e.b(context);
    }

    private void p(@NonNull Context context) {
        this.f.registerActivityRecognition(context);
    }

    private void q(@NonNull Context context) {
        this.f.stopActivityRecognition(context);
    }

    private void g() {
        this.c.scheduleRecurringJob("locations-upload-recurring", LocationsUploadJobService.class, new int[]{2}, this.g.getLocationsUploadInterval());
    }

    private void h() {
        this.c.dispatchImmediateJob("locations-upload", LocationsUploadJobService.class, new int[]{2});
    }

    private void i() {
        this.c.scheduleRecurringJob("inventory-update-recurring", InventoryUpdateJobService.class, new int[]{2}, this.g.getLastUpdateInterval());
    }

    private void j() {
        this.c.dispatchImmediateJob("inventory-update", InventoryUpdateJobService.class, new int[]{2});
    }

    private void k() {
        this.c.scheduleRecurringJob("remote-settings-update-recurring", RemoteSettingsJobService.class, new int[]{2}, this.g.getSettingsUpdateInterval());
    }

    private void l() {
        this.c.dispatchImmediateJob("remote-settings-update", RemoteSettingsJobService.class, new int[]{2});
    }

    private void m() {
        this.c.dispatchImmediateJob("around-me", AroundMeJobService.class, new int[]{1, 4, 8});
    }

    private void n() {
        this.c.scheduleRecurringJob("hits-upload-recurring", HitsUploadJobService.class, new int[]{2}, this.g.getHitUploadInterval());
    }

    private void o() {
        this.c.dispatchImmediateJob("hits-upload-recurring", HitsUploadJobService.class, new int[]{2});
    }

    private void r(@NonNull Context context) {
        Context context2 = context.getApplicationContext();
        this.n();
        this.i();
        this.g();
        this.k();
        this.n(context2);
        this.p(context2);
    }

    private void s(@NonNull Context context) {
        for (Kit kit : this.q()) {
            kit.init(context, this.g, this.b, this.c, this.d);
        }
    }

    void e(@NonNull Context context) {
        if (!this.g.isStopped()) {
            Context context2 = context.getApplicationContext();
            this.r(context2);
            this.m();
            for (Kit kit : this.q()) {
                if (!(kit instanceof ScanningKit)) continue;
                ((ScanningKit)kit).onDeviceBooted(context2);
            }
        }
    }

    void f(@NonNull Context context) {
        final Context context2 = context.getApplicationContext();
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                v.this.g.setIsInForeground(true);
                if (!v.this.g.isStopped()) {
                    if (v.this.g.isFirstOpen()) {
                        v.this.g.setIsFirstOpen(false);
                        v.this.r(context2);
                    }
                    v.this.h();
                    v.this.j();
                    v.this.l();
                    v.this.o();
                    v.this.m();
                    for (Kit kit : v.this.q()) {
                        if (!(kit instanceof ScanningKit)) continue;
                        ((ScanningKit)kit).onAppDidEnterForeground(context2, v.this.g.isForegroundOnly());
                    }
                }
            }
        });
    }

    void g(@NonNull Context context) {
        Context context2 = context.getApplicationContext();
        this.g.setIsInForeground(false);
        if (!this.g.isStopped()) {
            for (Kit kit : this.q()) {
                if (!(kit instanceof ScanningKit)) continue;
                ((ScanningKit)kit).onAppDidExitForeground(context2, this.g.isForegroundOnly());
            }
        }
    }

    private void t(@NonNull Context context) {
        this.j(context);
    }

    private void u(@NonNull Context context) {
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent("com.tamoco.sdk.ACTION_INVENTORY_UPDATED"));
        int n2 = (int)System.currentTimeMillis();
        NotificationUtils.showDebugNotification(context, n2, "Inventory updated", String.format(Locale.UK, "Interval: %d s - Threshold: %d m", TimeUnit.SECONDS.convert(this.g.getLastUpdateInterval(), TimeUnit.MILLISECONDS), Math.round(this.g.getLastUpdateThreshold())));
        if (!(this.g.isStopped() || this.g.isForegroundOnly() && !this.g.isInForeground())) {
            this.k(context);
        }
    }

    private void v(@NonNull Context context) {
        this.j(context);
    }

    private void w(@NonNull Context context) {
        this.r(context);
        if (!(this.g.isStopped() || this.g.isForegroundOnly() && !this.g.isInForeground())) {
            this.k(context);
        }
    }

    void a(final @NonNull Context context, final @Nullable TamocoRequestCallback<Boolean> tamocoRequestCallback) {
        this.d.submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = v.this.b.hits().flushExpiredHits(context);
                if (bl) {
                    NotificationUtils.showDebugNotification(context, (int)System.currentTimeMillis(), "Trigger hits", "Hits pushed to the API");
                }
                if (tamocoRequestCallback != null) {
                    tamocoRequestCallback.onResult(bl);
                }
            }
        });
    }

    private void p() {
        if (!this.e()) {
            this.j();
        }
    }

    void a(final Context context, final String string) {
        this.d.submit(new Runnable(){

            @Override
            public void run() {
                v.this.b.hits().trackNotificationClicked(context, string);
            }
        });
    }

    void a(final @NonNull Context context, final @Nullable Location location, final @Nullable TamocoRequestCallback<Boolean> tamocoRequestCallback) {
        TamocoLog.d("Tamoco", "updateInventory");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                Location location3;
                Context context2 = context.getApplicationContext();
                Location location2 = location3 = location != null ? location : v.this.e.a(context2);
                if (location3 != null) {
                    v.this.t(context2);
                    boolean bl = v.this.b.inventory().updateInventory(context2, location3);
                    if (bl) {
                        v.this.a(context2, location3);
                        v.this.i();
                    }
                    v.this.u(context2);
                    if (tamocoRequestCallback != null) {
                        tamocoRequestCallback.onResult(bl);
                    }
                } else if (tamocoRequestCallback != null) {
                    tamocoRequestCallback.onResult(true);
                }
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void a(@NonNull Context context, @Nullable Location location) {
        final Context context2 = context.getApplicationContext();
        if (PermissionUtils.hasPermission(context2, "android.permission.ACCESS_FINE_LOCATION") && location != null) {
            float f2;
            Location location2;
            if (this.g.getWakeupGeofenceCenter() != null) {
                location2 = this.g.getWakeupGeofenceCenter();
                f2 = this.g.getWakeupGeofenceRadius();
            } else {
                location2 = location;
                f2 = this.g.getLastUpdateThreshold();
                this.g.setWakeupGeofenceCenter(location2);
                this.g.setWakeupGeofenceRadius(f2);
            }
            long l2 = this.g.getLastUpdateInterval();
            Geofence geofence = new Geofence.Builder().setRequestId("inventoryUpdateGeofence").setCircularRegion(location2.getLatitude(), location2.getLongitude(), f2).setExpirationDuration(l2).setTransitionTypes(2).build();
            GeofencingRequest geofencingRequest = new GeofencingRequest.Builder().addGeofence(geofence).build();
            this.h.addGeofences(geofencingRequest, InventoryUpdateReceiver.getPendingIntent(context)).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e2) {
                    TamocoLog.e("Tamoco", "Unable to register inventory update geofence", e2);
                    NotificationUtils.showDebugNotification(context2, (int)System.currentTimeMillis(), "Inventory Update", "Unable to register inventory update geofence");
                }
            });
        }
    }

    private void x(@NonNull Context context) {
        this.h.removeGeofences(InventoryUpdateReceiver.getPendingIntent(context));
    }

    void b(final @NonNull Context context, final @Nullable TamocoRequestCallback<Boolean> tamocoRequestCallback) {
        TamocoLog.d("Tamoco", "flushTriggersAroundMe");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                Context context2 = context.getApplicationContext();
                boolean bl = v.this.b.inventory().flushTriggersAroundMe(context2);
                if (bl) {
                    NotificationUtils.showDebugNotification(context2, (int)System.currentTimeMillis(), "Unknown triggers", "Unknown triggers flushed to the API");
                }
                if (tamocoRequestCallback != null) {
                    tamocoRequestCallback.onResult(bl);
                }
            }
        });
    }

    void c(final @NonNull Context context, final @NonNull TamocoRequestCallback<Boolean> tamocoRequestCallback) {
        TamocoLog.d("Tamoco", "updateSettings");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                Context context2 = context.getApplicationContext();
                v.this.v(context2);
                boolean bl = v.this.b.inventory().updateRemoteSettings(context2);
                if (bl) {
                    NotificationUtils.showDebugNotification(context, (int)System.currentTimeMillis(), "Remote settings", "Remote settings updated");
                }
                v.this.w(context2);
                tamocoRequestCallback.onResult(bl);
            }
        });
    }

    void a(final @NonNull List<Location> list) {
        TamocoLog.d("Tamoco", "reportLocations");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                v.this.b.hits().reportLocations(list);
            }
        });
    }

    public void b(final List<ActivityTransitionEvent> list) {
        TamocoLog.d("Tamoco", "reportActivities");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                v.this.b.hits().reportActivities(list);
            }
        });
    }

    void d(final @NonNull Context context, final @Nullable TamocoRequestCallback<Boolean> tamocoRequestCallback) {
        TamocoLog.d("Tamoco", "flushBatchedLocations");
        this.d.execute(new Runnable(){

            @Override
            public void run() {
                Context context2 = context.getApplicationContext();
                boolean bl = v.this.b.hits().flushBatchedLocations(context2);
                if (tamocoRequestCallback != null) {
                    tamocoRequestCallback.onResult(bl);
                }
            }
        });
    }

    @Nullable
    WakeupGeofence f() {
        Location location = this.g.getWakeupGeofenceCenter();
        float f2 = this.g.getWakeupGeofenceRadius();
        if (location != null && f2 > 0.0f) {
            return new WakeupGeofence(location.getLatitude(), location.getLongitude(), f2);
        }
        return null;
    }

    private Collection<Kit> q() {
        return this.a != null ? this.a.values() : new ArrayList();
    }
}

