/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.Log;
import com.tamoco.sdk.beacon.c;
import com.tamoco.sdk.beacon.d;
import com.tamoco.sdk.beacon.e;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class BeaconParser {
    private static final Pattern u = Pattern.compile("i\\:(\\d+)\\-(\\d+)([blv]*)?");
    private static final Pattern v = Pattern.compile("m\\:(\\d+)-(\\d+)\\=([0-9A-Fa-f]+)");
    private static final Pattern w = Pattern.compile("s\\:(\\d+)-(\\d+)\\=([0-9A-Fa-f]+)");
    private static final Pattern x = Pattern.compile("d\\:(\\d+)\\-(\\d+)([bl]*)?");
    private static final Pattern y = Pattern.compile("p\\:(\\d+)\\-(\\d+)\\:?([\\-\\d]+)?");
    private static final Pattern z = Pattern.compile("x");
    private static final char[] A = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected final List<Integer> a = new ArrayList<Integer>();
    protected final List<Integer> b = new ArrayList<Integer>();
    protected final List<Boolean> c = new ArrayList<Boolean>();
    protected final List<Integer> d = new ArrayList<Integer>();
    protected final List<Integer> e = new ArrayList<Integer>();
    protected final List<Boolean> f = new ArrayList<Boolean>();
    protected final List<Boolean> g = new ArrayList<Boolean>();
    protected Integer h;
    protected Integer i;
    protected Integer j;
    protected Integer k;
    protected Long l;
    protected Boolean m;
    protected Integer n;
    protected Integer o;
    protected Integer p;
    protected Integer q;
    protected Boolean r = true;
    protected String s;
    protected int[] t = new int[]{76};
    private Long B;

    public BeaconParser() {
    }

    public BeaconParser(String identifier) {
        this.s = identifier;
    }

    protected static String a(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = A[n2 >>> 4];
            cArray[i2 * 2 + 1] = A[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] a(long l2, int n2) {
        return BeaconParser.a(l2, n2, true);
    }

    public static byte[] a(long l2, int n2, boolean bl) {
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = bl ? i2 : n2 - i2 - 1;
            long l3 = 255L << (n2 - n3 - 1) * 8;
            long l4 = (n2 - n3 - 1) * 8;
            long l5 = (l2 & l3) >> (int)l4;
            byArray[i2] = (byte)l5;
        }
        return byArray;
    }

    public BeaconParser a(String string) {
        String[] stringArray = string.split(",");
        this.m = false;
        for (String string2 : stringArray) {
            Boolean bl;
            int n2;
            int n3;
            boolean bl2 = false;
            Matcher matcher = u.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                try {
                    n3 = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    bl = matcher.group(3).contains("l");
                    this.c.add(bl);
                    Boolean bl3 = matcher.group(3).contains("v");
                    this.g.add(bl3);
                    this.a.add(n3);
                    this.b.add(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + string2);
                }
            }
            matcher = x.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                try {
                    n3 = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    bl = matcher.group(3).contains("l");
                    this.f.add(bl);
                    this.d.add(n3);
                    this.e.add(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + string2);
                }
            }
            matcher = y.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                try {
                    n3 = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    int n4 = 0;
                    if (matcher.group(3) != null) {
                        n4 = Integer.parseInt(matcher.group(3));
                    }
                    this.p = n4;
                    this.n = n3;
                    this.o = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse integer power byte offset in term: " + string2);
                }
            }
            matcher = v.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                try {
                    int n5 = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    this.h = n5;
                    this.i = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + string2);
                }
                String string3 = matcher.group(3);
                try {
                    this.B = Long.decode("0x" + string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse beacon type code: " + string3 + " in term: " + string2);
                }
            }
            matcher = w.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                try {
                    int n6 = Integer.parseInt(matcher.group(1));
                    n2 = Integer.parseInt(matcher.group(2));
                    this.j = n6;
                    this.k = n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + string2);
                }
                String string4 = matcher.group(3);
                try {
                    this.l = Long.decode("0x" + string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BeaconLayoutException("Cannot parse serviceUuid: " + string4 + " in term: " + string2);
                }
            }
            matcher = z.matcher(string2);
            while (matcher.find()) {
                bl2 = true;
                this.m = true;
            }
            if (bl2) continue;
            com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "cannot parse term %s", string2);
            throw new BeaconLayoutException("Cannot parse beacon layout term: " + string2);
        }
        if (!this.m.booleanValue()) {
            if (this.a.size() == 0 || this.b.size() == 0) {
                throw new BeaconLayoutException("You must supply at least one identifier offset with a prefix of 'i'");
            }
            if (this.n == null || this.o == null) {
                throw new BeaconLayoutException("You must supply a power byte offset with a prefix of 'p'");
            }
        }
        if (this.h == null || this.i == null) {
            throw new BeaconLayoutException("You must supply a matching beacon type expression with a prefix of 'm'");
        }
        this.q = this.c();
        return this;
    }

    public Long a() {
        return this.B;
    }

    public Long b() {
        return this.l;
    }

    @TargetApi(value=5)
    public com.tamoco.sdk.beacon.a a(byte[] byArray, int n2, BluetoothDevice bluetoothDevice) {
        return this.a(byArray, n2, bluetoothDevice, new com.tamoco.sdk.beacon.a());
    }

    @TargetApi(value=5)
    protected com.tamoco.sdk.beacon.a a(byte[] byArray, int n2, BluetoothDevice bluetoothDevice, com.tamoco.sdk.beacon.a a2) {
        Object object;
        int n3;
        c c2 = new c(byArray);
        boolean bl = false;
        e e2 = null;
        int n4 = 0;
        ArrayList<d> arrayList = new ArrayList<d>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (e object22 : c2.a()) {
            if (object22.a() == 22 || object22.a() == -1) {
                e2 = object22;
                if (!com.tamoco.sdk.beacon.BeaconParser$a.a()) break;
                com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Processing pdu type %02X: %s with startIndex: %d, endIndex: %d", object22.a(), BeaconParser.a(byArray), object22.c(), object22.d());
                break;
            }
            if (!com.tamoco.sdk.beacon.BeaconParser$a.a()) continue;
            com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Ignoring pdu type %02X", object22.a());
        }
        if (e2 == null) {
            if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "No PDUs to process in this packet.");
            }
            bl = true;
        } else {
            Object object3 = null;
            byte[] byArray2 = BeaconParser.a(this.a(), this.i - this.h + 1);
            if (this.b() != null) {
                object3 = BeaconParser.a(this.b(), this.k - this.j + 1, false);
            }
            n4 = e2.c();
            n3 = 0;
            if (this.b() == null) {
                if (this.a(byArray, n4 + this.h, byArray2, 0)) {
                    n3 = 1;
                }
            } else if (object3 != null && this.a(byArray, n4 + this.j, (byte[])object3, 0) && this.a(byArray, n4 + this.h, byArray2, 0)) {
                n3 = 1;
            }
            if (n3 == 0) {
                if (this.b() == null) {
                    if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                        com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "This is not a matching Beacon advertisement. (Was expecting %s.  The bytes I see are: %s", this.b(byArray2), BeaconParser.a(byArray));
                    }
                } else if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                    com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "This is not a matching Beacon advertisement. Was expecting %s at offset %d and %s at offset %d.  The bytes I see are: %s", this.b((byte[])object3), n4 + this.j, this.b(byArray2), n4 + this.h, BeaconParser.a(byArray));
                }
                bl = true;
                a2 = null;
            } else if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "This is a recognized beacon advertisement -- %s seen", this.b(byArray2));
                com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Bytes are: %s", BeaconParser.a(byArray));
            }
            if (n3 != 0) {
                int n5;
                int n6;
                if (byArray.length <= n4 + this.q && this.r.booleanValue()) {
                    if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                        com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Expanding buffer because it is too short to parse: " + byArray.length + ", needed: " + (n4 + this.q));
                    }
                    byArray = this.a(byArray, n4 + this.q);
                }
                for (n6 = 0; n6 < this.b.size(); ++n6) {
                    n5 = this.b.get(n6) + n4;
                    if (n5 > e2.d() && this.g.get(n6).booleanValue()) {
                        if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                            com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Need to truncate identifier by " + (n5 - e2.d()));
                        }
                        object = com.tamoco.sdk.beacon.d.a(byArray, this.a.get(n6) + n4, e2.d() + 1, this.c.get(n6));
                        arrayList.add((d)object);
                        continue;
                    }
                    if (n5 > e2.d() && !this.r.booleanValue()) {
                        bl = true;
                        if (!com.tamoco.sdk.beacon.BeaconParser$a.a()) continue;
                        com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Cannot parse identifier " + n6 + " because PDU is too short.  endIndex: " + n5 + " PDU endIndex: " + e2.d());
                        continue;
                    }
                    object = com.tamoco.sdk.beacon.d.a(byArray, this.a.get(n6) + n4, n5 + 1, this.c.get(n6));
                    arrayList.add((d)object);
                }
                for (n6 = 0; n6 < this.e.size(); ++n6) {
                    n5 = this.e.get(n6) + n4;
                    if (n5 > e2.d() && !this.r.booleanValue()) {
                        if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                            com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Cannot parse data field " + n6 + " because PDU is too short.  endIndex: " + n5 + " PDU endIndex: " + e2.d() + ".  Setting value to 0");
                        }
                        arrayList2.add(0L);
                        continue;
                    }
                    object = this.a(byArray, this.d.get(n6) + n4, n5, this.f.get(n6));
                    arrayList2.add(Long.decode((String)object));
                }
                if (this.n != null) {
                    n6 = this.o + n4;
                    n5 = 0;
                    try {
                        if (n6 > e2.d() && !this.r.booleanValue()) {
                            bl = true;
                            if (com.tamoco.sdk.beacon.BeaconParser$a.a()) {
                                com.tamoco.sdk.beacon.BeaconParser$a.a("BeaconParser", "Cannot parse power field because PDU is too short.  endIndex: " + n6 + " PDU endIndex: " + e2.d());
                            }
                        } else {
                            object = this.a(byArray, this.n + n4, this.o + n4, false);
                            n5 = Integer.parseInt((String)object) + this.p;
                            if (n5 > 127) {
                                n5 -= 256;
                            }
                            a2.d = n5;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        if (bl) {
            a2 = null;
        } else {
            int n7 = 0;
            String string = this.a(byArray, this.h + n4, this.i + n4, false);
            n7 = Integer.parseInt(string);
            n3 = 0;
            String string2 = this.a(byArray, n4, n4 + 1, true);
            n3 = Integer.parseInt(string2);
            String string3 = null;
            object = null;
            if (bluetoothDevice != null) {
                string3 = bluetoothDevice.getAddress();
                object = bluetoothDevice.getName();
            }
            a2.a = arrayList;
            a2.b = arrayList2;
            a2.a(n2);
            a2.f = n7;
            a2.h = this.l != null ? (int)this.l.longValue() : -1;
            a2.e = string3;
            a2.i = object;
            a2.g = n3;
            a2.j = this.s;
        }
        return a2;
    }

    private int c() {
        int n2 = 0;
        if (this.b != null) {
            for (int n3 : this.b) {
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        if (this.e != null) {
            for (int n3 : this.e) {
                if (n3 <= n2) continue;
                n2 = n3;
            }
        }
        if (this.o != null && this.o > n2) {
            n2 = this.o;
        }
        if (this.k != null && this.k > n2) {
            n2 = this.k;
        }
        return n2 + 1;
    }

    private boolean a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5 = n4 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        if (n2 + n4 > byArray.length || n3 + n4 > byArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (byArray[i2 + n2] == byArray2[i2 + n3]) continue;
            return false;
        }
        return true;
    }

    private String b(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuilder.append(String.format("%02x", byArray[i2]));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private String a(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        byte[] byArray2 = new byte[n3 - n2 + 1];
        if (bl) {
            for (n4 = 0; n4 <= n3 - n2; ++n4) {
                byArray2[n4] = byArray[n2 + byArray2.length - 1 - n4];
            }
        } else {
            for (n4 = 0; n4 <= n3 - n2; ++n4) {
                byArray2[n4] = byArray[n2 + n4];
            }
        }
        if ((n4 = n3 - n2 + 1) < 5) {
            long l2 = 0L;
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                long l3 = byArray2[byArray2.length - i2 - 1] & 0xFF;
                long l4 = (long)Math.pow(256.0, (double)i2 * 1.0);
                long l5 = l3 * l4;
                l2 += l5;
            }
            return Long.toString(l2);
        }
        String string = BeaconParser.a(byArray2);
        if (byArray2.length == 16) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string, 0, 8);
            stringBuilder.append("-");
            stringBuilder.append(string, 8, 12);
            stringBuilder.append("-");
            stringBuilder.append(string, 12, 16);
            stringBuilder.append("-");
            stringBuilder.append(string, 16, 20);
            stringBuilder.append("-");
            stringBuilder.append(string, 20, 32);
            return stringBuilder.toString();
        }
        return "0x" + string;
    }

    @TargetApi(value=9)
    private byte[] a(byte[] byArray, int n2) {
        if (byArray.length >= n2) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n2);
    }

    static class a {
        private static boolean a = false;

        public static boolean a() {
            return a;
        }

        public static void a(String string, Object ... objectArray) {
            if (a) {
                String string2 = objectArray.length == 0 ? string : String.format(string, objectArray);
                Log.d((String)"BeaconParser", (String)string2);
            }
        }
    }

    public static class BeaconLayoutException
    extends RuntimeException {
        public BeaconLayoutException(String s2) {
            super(s2);
        }
    }
}

