/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Embedded;
import android.arch.persistence.room.Ignore;
import android.bluetooth.BluetoothManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.text.TextUtils;
import com.squareup.moshi.Json;
import com.tamoco.sdk.AdvertisingIdentifierWrapper;
import com.tamoco.sdk.BatteryData;
import com.tamoco.sdk.ChargingData;
import com.tamoco.sdk.PermissionUtils;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.h;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;

class DeviceData {
    private static final String TAG = "DeviceData";
    private static final int TYPE_PHONE = 1;
    private static final int TYPE_TABLET = 2;
    @Json(name="device_id")
    @ColumnInfo(name="device_id")
    String deviceId;
    @Json(name="lmt")
    @ColumnInfo(name="lmt")
    boolean limitedAddTracking;
    @Json(name="device_type")
    @ColumnInfo(name="device_type")
    int deviceType;
    @Json(name="make")
    @ColumnInfo(name="make")
    String make;
    @Json(name="model")
    @ColumnInfo(name="model")
    String model;
    @Json(name="screen_width")
    @ColumnInfo(name="screen_width")
    int screenWidth;
    @Json(name="screen_height")
    @ColumnInfo(name="screen_height")
    int screenHeight;
    @Json(name="sd_card_mounted")
    @ColumnInfo(name="sd_card_mounted")
    boolean sdCardMounted;
    @Json(name="battery")
    @Embedded(prefix="battery_")
    BatteryData battery;
    @Json(name="charging")
    @Embedded(prefix="charging_")
    ChargingData charging;
    @Json(name="locale")
    @ColumnInfo(name="locale")
    String locale;
    @Json(name="os")
    @ColumnInfo(name="os")
    String os;
    @Json(name="os_version")
    @ColumnInfo(name="os_version")
    String osVersion;
    @Json(name="timezone")
    @ColumnInfo(name="timezone")
    String timezone;
    @Json(name="location")
    @ColumnInfo(name="location")
    boolean locationEnabled;
    @Json(name="ip")
    @ColumnInfo(name="ip")
    String ip;
    @Json(name="bluetooth")
    @ColumnInfo(name="bluetooth")
    boolean bluetoothEnabled;
    @Json(name="wifi")
    @ColumnInfo(name="wifi")
    boolean wifiEnabled;
    @Json(name="nfc")
    @ColumnInfo(name="nfc")
    boolean nfcEnabled;
    @Json(name="carrier")
    @Embedded(prefix="carrier_")
    h carrier;
    @Json(name="pressure")
    @ColumnInfo(name="pressure")
    Float pressure;

    DeviceData() {
    }

    @Ignore
    DeviceData(Context context) {
        this.deviceId = AdvertisingIdentifierWrapper.getInstance(context).getId();
        this.limitedAddTracking = AdvertisingIdentifierWrapper.getInstance(context).isLimitAdTrackingEnabled();
        this.deviceType = this.isTablet(context) ? 2 : 1;
        this.make = Build.MANUFACTURER;
        this.model = Build.MODEL;
        this.screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.screenHeight = context.getResources().getDisplayMetrics().heightPixels;
        this.sdCardMounted = "mounted".equals(Environment.getExternalStorageState());
        Intent intent = context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        this.battery = new BatteryData(context, intent);
        this.charging = new ChargingData(intent);
        this.os = "Android";
        this.osVersion = Build.VERSION.RELEASE;
        this.locale = this.getCurrentLocale(context).toString();
        this.timezone = TimeZone.getDefault().getID();
        this.locationEnabled = this.areLocationServicesEnabled(context);
        this.ip = this.getLocalIpAddress();
        this.bluetoothEnabled = this.isBluetoothEnabled(context);
        this.wifiEnabled = this.isWifiEnabled(context);
        this.nfcEnabled = this.isNfcEnabled(context);
        this.carrier = new h(context);
    }

    Locale getCurrentLocale(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return context.getResources().getConfiguration().getLocales().get(0);
        }
        return context.getResources().getConfiguration().locale;
    }

    private String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (NullPointerException | SocketException exception) {
            TamocoLog.d(TAG, "Failed to get local ip address", exception);
        }
        return null;
    }

    private boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    private boolean areLocationServicesEnabled(Context context) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                bl = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode") != 0;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                bl = this.areLocationsEnabledPreKitKat(context);
            }
        } else {
            bl = this.areLocationsEnabledPreKitKat(context);
        }
        return bl;
    }

    private boolean areLocationsEnabledPreKitKat(Context context) {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)string);
    }

    private boolean isBluetoothEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 18 && PermissionUtils.hasPermissions(context, "android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN")) {
            BluetoothManager bluetoothManager = (BluetoothManager)context.getApplicationContext().getSystemService("bluetooth");
            return bluetoothManager != null && bluetoothManager.getAdapter() != null && bluetoothManager.getAdapter().isEnabled();
        }
        return false;
    }

    private boolean isWifiEnabled(Context context) {
        if (PermissionUtils.hasPermission(context, "android.permission.ACCESS_WIFI_STATE")) {
            WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            return wifiManager != null && wifiManager.isWifiEnabled();
        }
        return false;
    }

    private boolean isNfcEnabled(Context context) {
        NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)context);
        return nfcAdapter != null && nfcAdapter.isEnabled();
    }
}

