/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.tamoco.sdk.TamocoLog;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AdvertisingIdentifierWrapper {
    public static final String TAG = AdvertisingIdentifierWrapper.class.getSimpleName();
    private static AdvertisingIdentifierWrapper a;
    private static final Lock b;
    private final Type c;
    private final String d;
    private final boolean e;

    private AdvertisingIdentifierWrapper(Type type, String id, boolean isLimitAdTrackingEnabled) {
        this.c = type;
        this.d = id;
        this.e = isLimitAdTrackingEnabled;
    }

    public static void init(Context context) {
        AdvertisingIdentifierWrapper.getInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdvertisingIdentifierWrapper getInstance(Context context) {
        if (a == null || AdvertisingIdentifierWrapper.a.c == Type.ANDROID_ID) {
            b.lock();
            try {
                String string;
                if (a == null) {
                    string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                    a = new AdvertisingIdentifierWrapper(Type.ANDROID_ID, string, false);
                }
                if (a.getType() == Type.ANDROID_ID) {
                    try {
                        string = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
                        String string2 = string.getId();
                        boolean bl = string.isLimitAdTrackingEnabled();
                        a = new AdvertisingIdentifierWrapper(Type.GOOGLEPLAY_ADVERTISING_ID, string2, bl);
                    }
                    catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                        TamocoLog.d(TAG, "Not a Google Play device, using Android ID");
                    }
                    catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                        TamocoLog.i(TAG, "Google Play version does not support Advertising Id, using Android ID.");
                    }
                    catch (IllegalStateException illegalStateException) {
                        TamocoLog.e(TAG, "AdvertisingIdentifier.getInstance() can not be called from the main thread.");
                    }
                    catch (Exception exception) {
                        TamocoLog.e(TAG, "Couldn't Get Advertising ID, defaulting to Android ID.  Error : " + exception);
                    }
                }
            }
            finally {
                b.unlock();
            }
        }
        return a;
    }

    public Type getType() {
        return this.c;
    }

    public String getId() {
        return this.d;
    }

    public boolean isLimitAdTrackingEnabled() {
        return this.e;
    }

    static {
        b = new ReentrantLock(true);
    }

    public static enum Type {
        ANDROID_ID,
        GOOGLEPLAY_ADVERTISING_ID;

    }
}

