package com.tamoco.sdk.wifi.doc;

import com.tamoco.sdk.doc.ITrigger;
import com.tamoco.sdk.wifi.WifiTrigger;

/*
 * *******************************************************
 * Copyright (C) 2013-2018 Tamoco Limited
 * This file is part of the Tamoco SDKs.
 *
 * Tamocos SDKs can not be copied and/or distributed without the express
 * permission of Tamoco Limited.
 *
 * https://www.tamoco.com/terms-and-conditions/
 * *******************************************************
 */

/**
 * Representation of a monitored wifi network from the Tamoco inventory.
 */
public interface IWifiTrigger extends ITrigger {

    /**
     * Gets the SSID of the wifi network.
     *
     * @return the SSID.
     */
    String getSSid();

    /**
     * Gets the mac of the access point of the wifi network, as of the Tamoco inventory.
     *
     * @return the mac.
     */
    String getMac();

    /**
     * Gets the actual mac of the access point of the wifi network as it was scanned.
     *
     * @return the mac.
     */
    String getScannedMac();

    /**
     * Gets the connection status of the wifi network in regards to the user device.
     * (see {@link WifiTrigger.ConnectionStatus})
     *
     * @return the status.
     */
    @WifiTrigger.ConnectionStatus
    int getConnectionStatus();
}
