package com.tamoco.sdk.geofence.doc;

import com.tamoco.sdk.doc.ITrigger;

/*
 * *******************************************************
 * Copyright (C) 2013-2018 Tamoco Limited
 * This file is part of the Tamoco SDKs.
 *
 * Tamocos SDKs can not be copied and/or distributed without the express
 * permission of Tamoco Limited.
 *
 * https://www.tamoco.com/terms-and-conditions/
 * *******************************************************
 */

/**
 * Representation of a monitored geofence from the Tamoco inventory.
 */
public interface IGeofenceTrigger extends ITrigger {
    /**
     * Gets the radius of the geofence (in meters).
     *
     * @return the radius.
     */
    float getRadius();
}
