package com.tamoco.sdk.beacon.doc;

import com.tamoco.sdk.doc.ITrigger;

/*
 * *******************************************************
 * Copyright (C) 2013-2018 Tamoco Limited
 * This file is part of the Tamoco SDKs.
 *
 * Tamocos SDKs can not be copied and/or distributed without the express
 * permission of Tamoco Limited.
 *
 * https://www.tamoco.com/terms-and-conditions/
 * *******************************************************
 */

/**
 * Representation of a monitored beacon from the Tamoco inventory.
 */
public interface IBeaconTrigger extends ITrigger {

    /**
     * Gets the uuid of the beacon.
     *
     * @return the uuid.
     */
    String getBeaconId();

    /**
     * Gets the namespace of the beacon.
     *
     * @return the namespace.
     */
    String getNamespace();

    /**
     * Gets the major of the beacon.
     *
     * @return the major.
     */
    Integer getMajor();

    /**
     * Gets the minor of the beacon.
     *
     * @return the minor.
     */
    Integer getMinor();

    /**
     * Gets the instance of the beacon.
     *
     * @return the instance.
     */
    String getInstance();

    /**
     * Gets the mac of the beacon, as of the Tamoco inventory.
     *
     * @return the mac
     */
    String getMac();

    /**
     * Gets the actual mac of the beacon as it was scanned.
     *
     * @return the mac.
     */
    String getScannedMac();
}
