/*
 * Decompiled with CFR 0.152.
 */
package com.tamoco.sdk;

import android.content.Context;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import com.google.android.gms.location.DetectedActivity;
import com.tamoco.sdk.BatchedLocation;
import com.tamoco.sdk.ClickBody;
import com.tamoco.sdk.HitsRepository;
import com.tamoco.sdk.LocalDatabase;
import com.tamoco.sdk.PreferencesManager;
import com.tamoco.sdk.StoredBeacon;
import com.tamoco.sdk.StoredGeofence;
import com.tamoco.sdk.StoredWifi;
import com.tamoco.sdk.TamocoLog;
import com.tamoco.sdk.TrackBody;
import com.tamoco.sdk.TrackBodyBroadcast;
import com.tamoco.sdk.c;
import com.tamoco.sdk.f;
import com.tamoco.sdk.l;
import com.tamoco.sdk.q;
import com.tamoco.sdk.w;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.Duration;
import retrofit2.Response;

@WorkerThread
class n
implements HitsRepository {
    private LocalDatabase a;
    private q b;
    private f c;
    private PreferencesManager d;
    private c e;

    n(@NonNull c c2, @NonNull LocalDatabase localDatabase, @NonNull f f2, @NonNull q q2, @NonNull PreferencesManager preferencesManager) {
        this.a = localDatabase;
        this.b = q2;
        this.c = f2;
        this.d = preferencesManager;
        this.e = c2;
    }

    @Override
    public void trackGeofenceHit(@NonNull Context context, @NonNull StoredGeofence geofence) {
        l l2 = this.d.getGeoMotionData();
        Location location = this.b.a(context);
        TrackBody trackBody = new TrackBody(context, geofence, location, this.d.isInForeground(), this.d.getDefaultInventoryTtl(), l2);
        this.a(context, trackBody);
    }

    @Override
    public void trackWifiHit(@NonNull Context context, @NonNull StoredWifi wifi) {
        Location location = this.b.a(context);
        Float f2 = null;
        if (this.d.isBarometerEnabled()) {
            f2 = Float.valueOf(this.c.a());
        }
        l l2 = this.d.getGeoMotionData();
        TrackBody trackBody = new TrackBody(context, wifi, location, f2, this.d.isInForeground(), this.d.getDefaultInventoryTtl(), l2);
        this.a(context, trackBody);
    }

    @Override
    public void trackBeaconHit(@NonNull Context context, @NonNull StoredBeacon beacon) {
        l l2 = this.d.getGeoMotionData();
        Location location = this.b.a(context);
        TrackBody trackBody = new TrackBody(context, beacon, location, this.d.isInForeground(), this.d.getDefaultInventoryTtl(), l2);
        this.a(context, trackBody);
    }

    @Override
    public void trackNotificationClicked(@NonNull Context context, @NonNull String trackedId) {
        Location location = this.b.a(context);
        try {
            l l2 = this.d.getGeoMotionData();
            ClickBody clickBody = new ClickBody(context, location, trackedId, this.d.isInForeground(), l2);
            this.e.a(clickBody).execute();
        }
        catch (IOException iOException) {
            TamocoLog.d("EventsRepositoryImpl", "Unable to track notification click", iOException);
        }
    }

    private void a(@NonNull Context context, TrackBody trackBody) {
        if (System.currentTimeMillis() - trackBody.expiration < this.d.getHitUploadInterval()) {
            if (!this.b(context, trackBody)) {
                this.a.hitDao().a(trackBody);
            }
        } else {
            this.a.hitDao().a(trackBody);
        }
    }

    @Override
    public synchronized boolean flushExpiredHits(@NonNull Context context) {
        List<TrackBody> list = this.a.hitDao().a(System.currentTimeMillis());
        ArrayList<TrackBody> arrayList = new ArrayList<TrackBody>();
        for (TrackBody trackBody : list) {
            if (!this.b(context, trackBody)) continue;
            arrayList.add(trackBody);
        }
        this.a.hitDao().a(arrayList);
        return arrayList.size() == list.size();
    }

    private boolean b(@NonNull Context context, TrackBody trackBody) {
        try {
            Response response = this.e.a(trackBody).execute();
            TrackBodyBroadcast.sendBodyTrigger(context, new w(trackBody, response.code()), 12);
            if (response.isSuccessful()) {
                return true;
            }
        }
        catch (IOException iOException) {
            TamocoLog.d("EventsRepositoryImpl", "Unable to post hit", iOException);
        }
        return false;
    }

    @Override
    public void reportLocations(@NonNull List<Location> locations) {
        ArrayList<BatchedLocation> arrayList = new ArrayList<BatchedLocation>();
        for (Location location : locations) {
            arrayList.add(new BatchedLocation(location));
        }
        this.a.batchedLocationDao().a(arrayList);
        List<BatchedLocation> list = this.a.batchedLocationDao().a();
        TamocoLog.i("BatchedLocation", "" + list.size());
    }

    @Override
    public void reportActivities(@NonNull List<DetectedActivity> activities) {
        DetectedActivity detectedActivity = null;
        for (DetectedActivity detectedActivity2 : activities) {
            if ((detectedActivity2.getConfidence() <= 70 || detectedActivity != null) && (detectedActivity == null || detectedActivity.getConfidence() >= detectedActivity2.getConfidence())) continue;
            detectedActivity = detectedActivity2;
        }
        if (detectedActivity != null) {
            this.d.setGeoMotionData(detectedActivity.getType(), detectedActivity.getConfidence());
        }
    }

    @Override
    public synchronized boolean flushBatchedLocations(@NonNull Context context) {
        List<BatchedLocation> list = this.a.batchedLocationDao().a();
        ArrayList<BatchedLocation> arrayList = new ArrayList<BatchedLocation>();
        for (BatchedLocation batchedLocation : list) {
            if (batchedLocation.sdkTimestamp >= System.currentTimeMillis() - Duration.ofDays((long)5L).getSeconds() * 1000L && !this.a(context, batchedLocation)) continue;
            arrayList.add(batchedLocation);
        }
        this.a.batchedLocationDao().b(arrayList);
        return arrayList.size() == list.size();
    }

    private boolean a(@NonNull Context context, BatchedLocation batchedLocation) {
        try {
            l l2 = this.d.getGeoMotionData();
            TrackBody trackBody = new TrackBody(context, batchedLocation.toLocation(), this.d.isInForeground(), 1, batchedLocation.sdkTimestamp, l2);
            Response response = this.e.b(trackBody).execute();
            TrackBodyBroadcast.sendBodyTrigger(context, new w(trackBody, response.code()), 12);
            if (response.isSuccessful()) {
                return true;
            }
        }
        catch (IOException iOException) {
            TamocoLog.d("EventsRepositoryImpl", "Unable to post hit", iOException);
        }
        return false;
    }
}

